/*
 * Decompiled with CFR 0.152.
 */
package android.app.role;

import android.annotation.RequiresPermission;
import android.app.role.IRoleController;
import android.app.role.RoleManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteCallback;
import android.permission.jarjar.com.android.internal.annotations.GuardedBy;
import android.permission.jarjar.com.android.internal.infra.AndroidFuture;
import android.permission.jarjar.com.android.internal.infra.ServiceConnector;
import android.util.Log;
import android.util.SparseArray;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class RoleControllerManager {
    private static final String LOG_TAG = RoleControllerManager.class.getSimpleName();
    private static final long REQUEST_TIMEOUT_MILLIS = 15000L;
    private static volatile ComponentName sRemoteServiceComponentName;
    private static final Object sRemoteServicesLock;
    @GuardedBy(value={"sRemoteServicesLock"})
    private static final SparseArray<ServiceConnector<IRoleController>> sRemoteServices;
    private final ServiceConnector<IRoleController> mRemoteService;

    public static void initializeRemoteServiceComponentName(Context context) {
        sRemoteServiceComponentName = RoleControllerManager.getRemoteServiceComponentName(context);
    }

    public static RoleControllerManager createWithInitializedRemoteServiceComponentName(Handler handler, Context context) {
        return new RoleControllerManager(sRemoteServiceComponentName, handler, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoleControllerManager(ComponentName remoteServiceComponentName, final Handler handler, Context context) {
        Object object = sRemoteServicesLock;
        synchronized (object) {
            int userId = context.getUser().getIdentifier();
            ServiceConnector.Impl<IRoleController> remoteService = sRemoteServices.get(userId);
            if (remoteService == null) {
                remoteService = new ServiceConnector.Impl<IRoleController>(context.getApplicationContext(), new Intent("android.app.role.RoleControllerService").setComponent(remoteServiceComponentName), 0, userId, IRoleController.Stub::asInterface){

                    @Override
                    protected Handler getJobHandler() {
                        return handler;
                    }
                };
                sRemoteServices.put(userId, (ServiceConnector<IRoleController>)remoteService);
            }
            this.mRemoteService = remoteService;
        }
    }

    public RoleControllerManager(Context context) {
        this(RoleControllerManager.getRemoteServiceComponentName(context), new Handler(Looper.getMainLooper()), context);
    }

    private static ComponentName getRemoteServiceComponentName(Context context) {
        Intent intent = new Intent("android.app.role.RoleControllerService");
        PackageManager packageManager = context.getPackageManager();
        intent.setPackage(packageManager.getPermissionControllerPackageName());
        ServiceInfo serviceInfo = packageManager.resolveService((Intent)intent, (int)0).serviceInfo;
        return new ComponentName(serviceInfo.packageName, serviceInfo.name);
    }

    public void grantDefaultRoles(Executor executor, Consumer<Boolean> callback) {
        AndroidFuture<Bundle> operation = this.mRemoteService.postAsync(service -> {
            AndroidFuture future = new AndroidFuture();
            service.grantDefaultRoles(new RemoteCallback(future::complete));
            return future;
        });
        this.propagateCallback(operation, "grantDefaultRoles", executor, callback);
    }

    public void onAddRoleHolder(String roleName, String packageName, @RoleManager.ManageHoldersFlags int flags, RemoteCallback callback) {
        AndroidFuture<Bundle> operation = this.mRemoteService.postAsync(service -> {
            AndroidFuture future = new AndroidFuture();
            service.onAddRoleHolder(roleName, packageName, flags, new RemoteCallback(future::complete));
            return future;
        });
        this.propagateCallback(operation, "onAddRoleHolder", callback);
    }

    public void onRemoveRoleHolder(String roleName, String packageName, @RoleManager.ManageHoldersFlags int flags, RemoteCallback callback) {
        AndroidFuture<Bundle> operation = this.mRemoteService.postAsync(service -> {
            AndroidFuture future = new AndroidFuture();
            service.onRemoveRoleHolder(roleName, packageName, flags, new RemoteCallback(future::complete));
            return future;
        });
        this.propagateCallback(operation, "onRemoveRoleHolder", callback);
    }

    public void onClearRoleHolders(String roleName, @RoleManager.ManageHoldersFlags int flags, RemoteCallback callback) {
        AndroidFuture<Bundle> operation = this.mRemoteService.postAsync(service -> {
            AndroidFuture future = new AndroidFuture();
            service.onClearRoleHolders(roleName, flags, new RemoteCallback(future::complete));
            return future;
        });
        this.propagateCallback(operation, "onClearRoleHolders", callback);
    }

    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void isApplicationVisibleForRole(String roleName, String packageName, Executor executor, Consumer<Boolean> callback) {
        AndroidFuture<Bundle> operation = this.mRemoteService.postAsync(service -> {
            AndroidFuture future = new AndroidFuture();
            service.isApplicationVisibleForRole(roleName, packageName, new RemoteCallback(future::complete));
            return future;
        });
        this.propagateCallback(operation, "isApplicationVisibleForRole", executor, callback);
    }

    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void isRoleVisible(String roleName, Executor executor, Consumer<Boolean> callback) {
        AndroidFuture<Bundle> operation = this.mRemoteService.postAsync(service -> {
            AndroidFuture future = new AndroidFuture();
            service.isRoleVisible(roleName, new RemoteCallback(future::complete));
            return future;
        });
        this.propagateCallback(operation, "isRoleVisible", executor, callback);
    }

    private void propagateCallback(AndroidFuture<Bundle> operation, String opName, Executor executor, Consumer<Boolean> destination) {
        ((AndroidFuture)operation.orTimeout(15000L, TimeUnit.MILLISECONDS)).whenComplete((res, err) -> executor.execute(() -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(LOG_TAG, "Error calling " + opName + "()", err);
                    destination.accept(false);
                } else {
                    destination.accept(res != null);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }));
    }

    private void propagateCallback(AndroidFuture<Bundle> operation, String opName, RemoteCallback destination) {
        ((AndroidFuture)operation.orTimeout(15000L, TimeUnit.MILLISECONDS)).whenComplete((res, err) -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(LOG_TAG, "Error calling " + opName + "()", err);
                    destination.sendResult(null);
                } else {
                    destination.sendResult((Bundle)res);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        });
    }

    static {
        sRemoteServicesLock = new Object();
        sRemoteServices = new SparseArray();
    }
}

