/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControlViewHost;

public interface IRequestSurfacePackageCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.sdksandbox.IRequestSurfacePackageCallback";

    public void onSurfacePackageReady(SurfaceControlViewHost.SurfacePackage var1, int var2, Bundle var3, long var4) throws RemoteException;

    public void onSurfacePackageError(int var1, String var2, long var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRequestSurfacePackageCallback {
        static final int TRANSACTION_onSurfacePackageReady = 1;
        static final int TRANSACTION_onSurfacePackageError = 2;

        public Stub() {
            this.attachInterface(this, IRequestSurfacePackageCallback.DESCRIPTOR);
        }

        public static IRequestSurfacePackageCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRequestSurfacePackageCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IRequestSurfacePackageCallback) {
                return (IRequestSurfacePackageCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSurfacePackageReady";
                }
                case 2: {
                    return "onSurfacePackageError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRequestSurfacePackageCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    SurfaceControlViewHost.SurfacePackage _arg0 = data.readTypedObject(SurfaceControlViewHost.SurfacePackage.CREATOR);
                    int _arg1 = data.readInt();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    long _arg3 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onSurfacePackageReady(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onSurfacePackageError(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IRequestSurfacePackageCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRequestSurfacePackageCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSurfacePackageReady(SurfaceControlViewHost.SurfacePackage surfacePackage, int surfacePackageId, Bundle params, long timeSystemServerCalledApp) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRequestSurfacePackageCallback.DESCRIPTOR);
                    _data.writeTypedObject(surfacePackage, 0);
                    _data.writeInt(surfacePackageId);
                    _data.writeTypedObject(params, 0);
                    _data.writeLong(timeSystemServerCalledApp);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSurfacePackageError(int errorCode, String errorMsg, long timeSystemServerCalledApp) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRequestSurfacePackageCallback.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    _data.writeString(errorMsg);
                    _data.writeLong(timeSystemServerCalledApp);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRequestSurfacePackageCallback {
        @Override
        public void onSurfacePackageReady(SurfaceControlViewHost.SurfacePackage surfacePackage, int surfacePackageId, Bundle params, long timeSystemServerCalledApp) throws RemoteException {
        }

        @Override
        public void onSurfacePackageError(int errorCode, String errorMsg, long timeSystemServerCalledApp) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

