/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.app.sdksandbox.ILoadSdkCallback;
import android.app.sdksandbox.IRequestSurfacePackageCallback;
import android.app.sdksandbox.ISdkSandboxProcessDeathCallback;
import android.app.sdksandbox.ISharedPreferencesSyncCallback;
import android.app.sdksandbox.SandboxedSdk;
import android.app.sdksandbox.SharedPreferencesUpdate;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ISdkSandboxManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.sdksandbox.ISdkSandboxManager";
    public static final String LOAD_SDK = "LOAD_SDK";
    public static final String REQUEST_SURFACE_PACKAGE = "REQUEST_SURFACE_PACKAGE";

    public void addSdkSandboxProcessDeathCallback(String var1, long var2, ISdkSandboxProcessDeathCallback var4) throws RemoteException;

    public void removeSdkSandboxProcessDeathCallback(String var1, long var2, ISdkSandboxProcessDeathCallback var4) throws RemoteException;

    public void loadSdk(String var1, IBinder var2, String var3, long var4, Bundle var6, ILoadSdkCallback var7) throws RemoteException;

    public void unloadSdk(String var1, String var2, long var3) throws RemoteException;

    public void requestSurfacePackage(String var1, String var2, IBinder var3, int var4, int var5, int var6, long var7, Bundle var9, IRequestSurfacePackageCallback var10) throws RemoteException;

    public List<SandboxedSdk> getSandboxedSdks(String var1, long var2) throws RemoteException;

    public void syncDataFromClient(String var1, long var2, SharedPreferencesUpdate var4, ISharedPreferencesSyncCallback var5) throws RemoteException;

    public void stopSdkSandbox(String var1) throws RemoteException;

    public void logLatencyFromSystemServerToApp(String var1, int var2) throws RemoteException;

    public IBinder getAdServicesManager() throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N = value.size();
                parcel.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements ISdkSandboxManager {
        static final int TRANSACTION_addSdkSandboxProcessDeathCallback = 1;
        static final int TRANSACTION_removeSdkSandboxProcessDeathCallback = 2;
        static final int TRANSACTION_loadSdk = 3;
        static final int TRANSACTION_unloadSdk = 4;
        static final int TRANSACTION_requestSurfacePackage = 5;
        static final int TRANSACTION_getSandboxedSdks = 6;
        static final int TRANSACTION_syncDataFromClient = 7;
        static final int TRANSACTION_stopSdkSandbox = 8;
        static final int TRANSACTION_logLatencyFromSystemServerToApp = 9;
        static final int TRANSACTION_getAdServicesManager = 10;

        public Stub() {
            this.attachInterface(this, ISdkSandboxManager.DESCRIPTOR);
        }

        public static ISdkSandboxManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISdkSandboxManager.DESCRIPTOR);
            if (iin != null && iin instanceof ISdkSandboxManager) {
                return (ISdkSandboxManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addSdkSandboxProcessDeathCallback";
                }
                case 2: {
                    return "removeSdkSandboxProcessDeathCallback";
                }
                case 3: {
                    return "loadSdk";
                }
                case 4: {
                    return "unloadSdk";
                }
                case 5: {
                    return "requestSurfacePackage";
                }
                case 6: {
                    return "getSandboxedSdks";
                }
                case 7: {
                    return "syncDataFromClient";
                }
                case 8: {
                    return "stopSdkSandbox";
                }
                case 9: {
                    return "logLatencyFromSystemServerToApp";
                }
                case 10: {
                    return "getAdServicesManager";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISdkSandboxManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    ISdkSandboxProcessDeathCallback _arg2 = ISdkSandboxProcessDeathCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addSdkSandboxProcessDeathCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    ISdkSandboxProcessDeathCallback _arg2 = ISdkSandboxProcessDeathCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeSdkSandboxProcessDeathCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    String _arg2 = data.readString();
                    long _arg3 = data.readLong();
                    Bundle _arg4 = data.readTypedObject(Bundle.CREATOR);
                    ILoadSdkCallback _arg5 = ILoadSdkCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.loadSdk(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.unloadSdk(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IBinder _arg2 = data.readStrongBinder();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    long _arg6 = data.readLong();
                    Bundle _arg7 = data.readTypedObject(Bundle.CREATOR);
                    IRequestSurfacePackageCallback _arg8 = IRequestSurfacePackageCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestSurfacePackage(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    List<SandboxedSdk> _result = this.getSandboxedSdks(_arg0, _arg1);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    SharedPreferencesUpdate _arg2 = data.readTypedObject(SharedPreferencesUpdate.CREATOR);
                    ISharedPreferencesSyncCallback _arg3 = ISharedPreferencesSyncCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.syncDataFromClient(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.stopSdkSandbox(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.logLatencyFromSystemServerToApp(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IBinder _result = this.getAdServicesManager();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 9;
        }

        private static class Proxy
        implements ISdkSandboxManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISdkSandboxManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSdkSandboxProcessDeathCallback(String callingPackageName, long timeAppCalledSystemServer, ISdkSandboxProcessDeathCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkSandboxManager.DESCRIPTOR);
                    _data.writeString(callingPackageName);
                    _data.writeLong(timeAppCalledSystemServer);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSdkSandboxProcessDeathCallback(String callingPackageName, long timeAppCalledSystemServer, ISdkSandboxProcessDeathCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkSandboxManager.DESCRIPTOR);
                    _data.writeString(callingPackageName);
                    _data.writeLong(timeAppCalledSystemServer);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void loadSdk(String callingPackageName, IBinder appProcessToken, String sdkName, long timeAppCalledSystemServer, Bundle params, ILoadSdkCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISdkSandboxManager.DESCRIPTOR);
                    _data.writeString(callingPackageName);
                    _data.writeStrongBinder(appProcessToken);
                    _data.writeString(sdkName);
                    _data.writeLong(timeAppCalledSystemServer);
                    _data.writeTypedObject(params, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unloadSdk(String callingPackageName, String sdkName, long timeAppCalledSystemServer) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkSandboxManager.DESCRIPTOR);
                    _data.writeString(callingPackageName);
                    _data.writeString(sdkName);
                    _data.writeLong(timeAppCalledSystemServer);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestSurfacePackage(String callingPackageName, String sdkName, IBinder hostToken, int displayId, int width, int height, long timeAppCalledSystemServer, Bundle params, IRequestSurfacePackageCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISdkSandboxManager.DESCRIPTOR);
                    _data.writeString(callingPackageName);
                    _data.writeString(sdkName);
                    _data.writeStrongBinder(hostToken);
                    _data.writeInt(displayId);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeLong(timeAppCalledSystemServer);
                    _data.writeTypedObject(params, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SandboxedSdk> getSandboxedSdks(String callingPackageName, long timeAppCalledSystemServer) throws RemoteException {
                ArrayList<SandboxedSdk> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkSandboxManager.DESCRIPTOR);
                    _data.writeString(callingPackageName);
                    _data.writeLong(timeAppCalledSystemServer);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SandboxedSdk.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void syncDataFromClient(String callingPackageName, long timeAppCalledSystemServer, SharedPreferencesUpdate update, ISharedPreferencesSyncCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISdkSandboxManager.DESCRIPTOR);
                    _data.writeString(callingPackageName);
                    _data.writeLong(timeAppCalledSystemServer);
                    _data.writeTypedObject(update, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopSdkSandbox(String callingPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkSandboxManager.DESCRIPTOR);
                    _data.writeString(callingPackageName);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void logLatencyFromSystemServerToApp(String method, int latency) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkSandboxManager.DESCRIPTOR);
                    _data.writeString(method);
                    _data.writeInt(latency);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getAdServicesManager() throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkSandboxManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ISdkSandboxManager {
        @Override
        public void addSdkSandboxProcessDeathCallback(String callingPackageName, long timeAppCalledSystemServer, ISdkSandboxProcessDeathCallback callback) throws RemoteException {
        }

        @Override
        public void removeSdkSandboxProcessDeathCallback(String callingPackageName, long timeAppCalledSystemServer, ISdkSandboxProcessDeathCallback callback) throws RemoteException {
        }

        @Override
        public void loadSdk(String callingPackageName, IBinder appProcessToken, String sdkName, long timeAppCalledSystemServer, Bundle params, ILoadSdkCallback callback) throws RemoteException {
        }

        @Override
        public void unloadSdk(String callingPackageName, String sdkName, long timeAppCalledSystemServer) throws RemoteException {
        }

        @Override
        public void requestSurfacePackage(String callingPackageName, String sdkName, IBinder hostToken, int displayId, int width, int height, long timeAppCalledSystemServer, Bundle params, IRequestSurfacePackageCallback callback) throws RemoteException {
        }

        @Override
        public List<SandboxedSdk> getSandboxedSdks(String callingPackageName, long timeAppCalledSystemServer) throws RemoteException {
            return null;
        }

        @Override
        public void syncDataFromClient(String callingPackageName, long timeAppCalledSystemServer, SharedPreferencesUpdate update, ISharedPreferencesSyncCallback callback) throws RemoteException {
        }

        @Override
        public void stopSdkSandbox(String callingPackageName) throws RemoteException {
        }

        @Override
        public void logLatencyFromSystemServerToApp(String method, int latency) throws RemoteException {
        }

        @Override
        public IBinder getAdServicesManager() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

