/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.app.sdksandbox.SandboxedSdk;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ISdkToServiceCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.sdksandbox.ISdkToServiceCallback";

    public List<SandboxedSdk> getSandboxedSdks(String var1) throws RemoteException;

    public void logLatenciesFromSandbox(int var1, int var2, int var3, boolean var4) throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N = value.size();
                parcel.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements ISdkToServiceCallback {
        static final int TRANSACTION_getSandboxedSdks = 1;
        static final int TRANSACTION_logLatenciesFromSandbox = 2;

        public Stub() {
            this.attachInterface(this, ISdkToServiceCallback.DESCRIPTOR);
        }

        public static ISdkToServiceCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISdkToServiceCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISdkToServiceCallback) {
                return (ISdkToServiceCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getSandboxedSdks";
                }
                case 2: {
                    return "logLatenciesFromSandbox";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISdkToServiceCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    List<SandboxedSdk> _result = this.getSandboxedSdks(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.logLatenciesFromSandbox(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ISdkToServiceCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISdkToServiceCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SandboxedSdk> getSandboxedSdks(String clientPackageName) throws RemoteException {
                ArrayList<SandboxedSdk> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkToServiceCallback.DESCRIPTOR);
                    _data.writeString(clientPackageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SandboxedSdk.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void logLatenciesFromSandbox(int latencyFromSystemServerToSandboxMillis, int latencySandboxMillis, int method, boolean success) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISdkToServiceCallback.DESCRIPTOR);
                    _data.writeInt(latencyFromSystemServerToSandboxMillis);
                    _data.writeInt(latencySandboxMillis);
                    _data.writeInt(method);
                    _data.writeBoolean(success);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISdkToServiceCallback {
        @Override
        public List<SandboxedSdk> getSandboxedSdks(String clientPackageName) throws RemoteException {
            return null;
        }

        @Override
        public void logLatenciesFromSandbox(int latencyFromSystemServerToSandboxMillis, int latencySandboxMillis, int method, boolean success) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

