/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.content.pm.SharedLibraryInfo;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class SandboxedSdk
implements Parcelable {
    public static final Parcelable.Creator<SandboxedSdk> CREATOR = new Parcelable.Creator<SandboxedSdk>(){

        @Override
        public SandboxedSdk createFromParcel(Parcel in) {
            return new SandboxedSdk(in);
        }

        public SandboxedSdk[] newArray(int size) {
            return new SandboxedSdk[size];
        }
    };
    private IBinder mInterface;
    private SharedLibraryInfo mSharedLibraryInfo;

    public SandboxedSdk(IBinder sdkInterface) {
        this.mInterface = sdkInterface;
    }

    private SandboxedSdk(Parcel in) {
        this.mInterface = in.readStrongBinder();
        if (in.readInt() != 0) {
            this.mSharedLibraryInfo = SharedLibraryInfo.CREATOR.createFromParcel(in);
        }
    }

    public void attachSharedLibraryInfo(SharedLibraryInfo sharedLibraryInfo) {
        if (this.mSharedLibraryInfo != null) {
            throw new IllegalStateException("SharedLibraryInfo already set");
        }
        Objects.requireNonNull(sharedLibraryInfo, "SharedLibraryInfo cannot be null");
        this.mSharedLibraryInfo = sharedLibraryInfo;
    }

    public IBinder getInterface() {
        return this.mInterface;
    }

    public SharedLibraryInfo getSharedLibraryInfo() {
        if (this.mSharedLibraryInfo == null) {
            throw new IllegalStateException("SharedLibraryInfo has not been set. This is populated by our system service once the SandboxedSdk is sent back from as a response to android.app.sdksandbox.SandboxedSdkProvider$onLoadSdk. Please use android.app.sdksandbox.SdkSandboxManager#getSandboxedSdks or android.app.sdksandbox.SdkSandboxController#getSandboxedSdks to get the correctly populated SandboxedSdks.");
        }
        return this.mSharedLibraryInfo;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStrongBinder(this.mInterface);
        if (this.mSharedLibraryInfo != null) {
            dest.writeInt(1);
            this.mSharedLibraryInfo.writeToParcel(dest, 0);
        } else {
            dest.writeInt(0);
        }
    }
}

