/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.app.sdksandbox.SdkSandboxSystemServiceRegistry;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;

public class SandboxedSdkContext
extends ContextWrapper {
    private final Resources mResources;
    private final AssetManager mAssets;
    private final String mClientPackageName;
    private final String mSdkName;
    private final ApplicationInfo mSdkProviderInfo;
    private final File mCeDataDir;
    private final File mDeDataDir;
    private final SdkSandboxSystemServiceRegistry mSdkSandboxSystemServiceRegistry;
    private final ClassLoader mClassLoader;
    private final boolean mCustomizedSdkContextEnabled;

    public SandboxedSdkContext(Context baseContext, ClassLoader classLoader, String clientPackageName, ApplicationInfo info, String sdkName, String sdkCeDataDir, String sdkDeDataDir, boolean isCustomizedSdkContextEnabled) {
        this(baseContext, classLoader, clientPackageName, info, sdkName, sdkCeDataDir, sdkDeDataDir, isCustomizedSdkContextEnabled, SdkSandboxSystemServiceRegistry.getInstance());
    }

    @VisibleForTesting
    public SandboxedSdkContext(Context baseContext, ClassLoader classLoader, String clientPackageName, ApplicationInfo info, String sdkName, String sdkCeDataDir, String sdkDeDataDir, boolean isCustomizedSdkContextEnabled, SdkSandboxSystemServiceRegistry sdkSandboxSystemServiceRegistry) {
        super(baseContext);
        this.mClientPackageName = clientPackageName;
        this.mSdkName = sdkName;
        this.mSdkProviderInfo = info;
        Resources resources = null;
        try {
            resources = baseContext.getPackageManager().getResourcesForApplication(info);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resources != null) {
            this.mResources = resources;
            this.mAssets = resources.getAssets();
        } else {
            this.mResources = null;
            this.mAssets = null;
        }
        this.mCeDataDir = sdkCeDataDir != null ? new File(sdkCeDataDir) : null;
        this.mDeDataDir = sdkDeDataDir != null ? new File(sdkDeDataDir) : null;
        this.mSdkSandboxSystemServiceRegistry = sdkSandboxSystemServiceRegistry;
        this.mClassLoader = classLoader;
        this.mCustomizedSdkContextEnabled = isCustomizedSdkContextEnabled;
    }

    @Override
    public Context createCredentialProtectedStorageContext() {
        Context newBaseContext = this.getBaseContext().createCredentialProtectedStorageContext();
        return new SandboxedSdkContext(newBaseContext, this.mClassLoader, this.mClientPackageName, this.mSdkProviderInfo, this.mSdkName, this.mCeDataDir != null ? this.mCeDataDir.toString() : null, this.mDeDataDir != null ? this.mDeDataDir.toString() : null, this.mCustomizedSdkContextEnabled);
    }

    @Override
    public Context createDeviceProtectedStorageContext() {
        Context newBaseContext = this.getBaseContext().createDeviceProtectedStorageContext();
        return new SandboxedSdkContext(newBaseContext, this.mClassLoader, this.mClientPackageName, this.mSdkProviderInfo, this.mSdkName, this.mCeDataDir != null ? this.mCeDataDir.toString() : null, this.mDeDataDir != null ? this.mDeDataDir.toString() : null, this.mCustomizedSdkContextEnabled);
    }

    public String getSdkName() {
        return this.mSdkName;
    }

    public String getSdkPackageName() {
        return this.mSdkProviderInfo.packageName;
    }

    public String getClientPackageName() {
        return this.mClientPackageName;
    }

    @Override
    public Resources getResources() {
        if (this.mCustomizedSdkContextEnabled) {
            return this.getBaseContext().getResources();
        }
        return this.mResources;
    }

    @Override
    public AssetManager getAssets() {
        if (this.mCustomizedSdkContextEnabled) {
            return this.getBaseContext().getAssets();
        }
        return this.mAssets;
    }

    @Override
    public File getDataDir() {
        if (this.mCustomizedSdkContextEnabled) {
            return this.getBaseContext().getDataDir();
        }
        File res = null;
        if (this.isCredentialProtectedStorage()) {
            res = this.mCeDataDir;
        } else if (this.isDeviceProtectedStorage()) {
            res = this.mDeDataDir;
        }
        if (res == null) {
            throw new RuntimeException("No data directory found for sdk: " + this.getSdkName());
        }
        return res;
    }

    @Override
    public Object getSystemService(String name) {
        if (name == null) {
            return null;
        }
        Object service = this.getBaseContext().getSystemService(name);
        SdkSandboxSystemServiceRegistry.ServiceMutator serviceMutator = this.mSdkSandboxSystemServiceRegistry.getServiceMutator(name);
        if (serviceMutator != null) {
            service = serviceMutator.setContext(service, this);
        }
        return service;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.mCustomizedSdkContextEnabled) {
            return this.getBaseContext().getClassLoader();
        }
        return this.mClassLoader;
    }
}

