/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.app.sdksandbox.ISdkToServiceCallback;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Objects;

public class SdkSandboxLocalSingleton {
    private static final String TAG = "SandboxLocalSingleton";
    private static SdkSandboxLocalSingleton sInstance = null;
    private final ISdkToServiceCallback mSdkToServiceCallback;

    private SdkSandboxLocalSingleton(ISdkToServiceCallback sdkToServiceCallback) {
        this.mSdkToServiceCallback = sdkToServiceCallback;
    }

    public static synchronized void initInstance(IBinder sdkToServiceBinder) {
        if (sInstance != null) {
            Log.d(TAG, "Already Initialised");
            return;
        }
        try {
            if (Objects.nonNull(sdkToServiceBinder) && sdkToServiceBinder.getInterfaceDescriptor().equals("android.app.sdksandbox.ISdkToServiceCallback")) {
                sInstance = new SdkSandboxLocalSingleton(ISdkToServiceCallback.Stub.asInterface(sdkToServiceBinder));
                return;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("IBinder not supported");
    }

    public static SdkSandboxLocalSingleton getExistingInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("SdkSandboxLocalSingleton not found");
        }
        return sInstance;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static void destroySingleton() {
        sInstance = null;
    }

    public ISdkToServiceCallback getSdkToServiceCallback() {
        return this.mSdkToServiceCallback;
    }
}

