/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.sdksandbox.ILoadSdkCallback;
import android.app.sdksandbox.IRequestSurfacePackageCallback;
import android.app.sdksandbox.ISdkSandboxManager;
import android.app.sdksandbox.ISdkSandboxProcessDeathCallback;
import android.app.sdksandbox.LoadSdkException;
import android.app.sdksandbox.RequestSurfacePackageException;
import android.app.sdksandbox.SandboxedSdk;
import android.app.sdksandbox.SdkLevel;
import android.app.sdksandbox.SharedPreferencesSyncManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.util.Log;
import android.view.SurfaceControlViewHost;
import androidx.annotation.RequiresApi;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.lang.System_Delegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

public class SdkSandboxManager {
    public static final String SDK_SANDBOX_SERVICE = "sdk_sandbox";
    public static final int SDK_SANDBOX_PROCESS_NOT_AVAILABLE = 503;
    public static final int LOAD_SDK_NOT_FOUND = 100;
    public static final int LOAD_SDK_ALREADY_LOADED = 101;
    public static final int LOAD_SDK_SDK_DEFINED_ERROR = 102;
    public static final int LOAD_SDK_SDK_SANDBOX_DISABLED = 103;
    public static final int LOAD_SDK_INTERNAL_ERROR = 500;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String ACTION_START_SANDBOXED_ACTIVITY = "android.app.sdksandbox.action.START_SANDBOXED_ACTIVITY";
    public static final String EXTRA_SANDBOXED_ACTIVITY_HANDLER = "android.app.sdksandbox.extra.SANDBOXED_ACTIVITY_HANDLER";
    private static final String TAG = "SdkSandboxManager";
    public static final int REQUEST_SURFACE_PACKAGE_INTERNAL_ERROR = 700;
    public static final int REQUEST_SURFACE_PACKAGE_SDK_NOT_LOADED = 701;
    public static final int SDK_SANDBOX_STATE_DISABLED = 0;
    public static final int SDK_SANDBOX_STATE_ENABLED_PROCESS_ISOLATION = 2;
    public static final String EXTRA_WIDTH_IN_PIXELS = "android.app.sdksandbox.extra.WIDTH_IN_PIXELS";
    public static final String EXTRA_HEIGHT_IN_PIXELS = "android.app.sdksandbox.extra.HEIGHT_IN_PIXELS";
    public static final String EXTRA_DISPLAY_ID = "android.app.sdksandbox.extra.DISPLAY_ID";
    public static final String EXTRA_HOST_TOKEN = "android.app.sdksandbox.extra.HOST_TOKEN";
    public static final String EXTRA_SURFACE_PACKAGE = "android.app.sdksandbox.extra.SURFACE_PACKAGE";
    private final ISdkSandboxManager mService;
    private final Context mContext;
    @GuardedBy(value={"mLifecycleCallbacks"})
    private final ArrayList<SdkSandboxProcessDeathCallbackProxy> mLifecycleCallbacks = new ArrayList();
    private final SharedPreferencesSyncManager mSyncManager;

    public SdkSandboxManager(Context context, ISdkSandboxManager binder) {
        this.mContext = Objects.requireNonNull(context, "context should not be null");
        this.mService = Objects.requireNonNull(binder, "binder should not be null");
        this.mSyncManager = SharedPreferencesSyncManager.getInstance(context, binder);
    }

    public static int getSdkSandboxState() {
        return 2;
    }

    @RequiresPermission(value="com.android.app.sdksandbox.permission.STOP_SDK_SANDBOX")
    public void stopSdkSandbox() {
        try {
            this.mService.stopSdkSandbox(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSdkSandboxProcessDeathCallback(Executor callbackExecutor, SdkSandboxProcessDeathCallback callback) {
        Objects.requireNonNull(callbackExecutor, "callbackExecutor should not be null");
        Objects.requireNonNull(callback, "callback should not be null");
        ArrayList<SdkSandboxProcessDeathCallbackProxy> arrayList = this.mLifecycleCallbacks;
        synchronized (arrayList) {
            SdkSandboxProcessDeathCallbackProxy callbackProxy = new SdkSandboxProcessDeathCallbackProxy(callbackExecutor, callback);
            try {
                this.mService.addSdkSandboxProcessDeathCallback(this.mContext.getPackageName(), System_Delegate.currentTimeMillis(), callbackProxy);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mLifecycleCallbacks.add(callbackProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSdkSandboxProcessDeathCallback(SdkSandboxProcessDeathCallback callback) {
        Objects.requireNonNull(callback, "callback should not be null");
        ArrayList<SdkSandboxProcessDeathCallbackProxy> arrayList = this.mLifecycleCallbacks;
        synchronized (arrayList) {
            for (int i = this.mLifecycleCallbacks.size() - 1; i >= 0; --i) {
                SdkSandboxProcessDeathCallbackProxy callbackProxy = this.mLifecycleCallbacks.get(i);
                if (callbackProxy.callback != callback) continue;
                try {
                    this.mService.removeSdkSandboxProcessDeathCallback(this.mContext.getPackageName(), System_Delegate.currentTimeMillis(), callbackProxy);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                this.mLifecycleCallbacks.remove(i);
            }
        }
    }

    public void loadSdk(String sdkName, Bundle params, Executor executor, OutcomeReceiver<SandboxedSdk, LoadSdkException> receiver) {
        Objects.requireNonNull(sdkName, "sdkName should not be null");
        Objects.requireNonNull(params, "params should not be null");
        Objects.requireNonNull(executor, "executor should not be null");
        Objects.requireNonNull(receiver, "receiver should not be null");
        LoadSdkReceiverProxy callbackProxy = new LoadSdkReceiverProxy(executor, receiver, this.mService);
        IBinder appProcessToken = SdkLevel.isAtLeastU() ? this.mContext.getProcessToken() : null;
        try {
            this.mService.loadSdk(this.mContext.getPackageName(), appProcessToken, sdkName, System_Delegate.currentTimeMillis(), params, callbackProxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<SandboxedSdk> getSandboxedSdks() {
        try {
            return this.mService.getSandboxedSdks(this.mContext.getPackageName(), System_Delegate.currentTimeMillis());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unloadSdk(String sdkName) {
        Objects.requireNonNull(sdkName, "sdkName should not be null");
        try {
            this.mService.unloadSdk(this.mContext.getPackageName(), sdkName, System_Delegate.currentTimeMillis());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestSurfacePackage(String sdkName, Bundle params, Executor callbackExecutor, OutcomeReceiver<Bundle, RequestSurfacePackageException> receiver) {
        Objects.requireNonNull(sdkName, "sdkName should not be null");
        Objects.requireNonNull(params, "params should not be null");
        Objects.requireNonNull(callbackExecutor, "callbackExecutor should not be null");
        Objects.requireNonNull(receiver, "receiver should not be null");
        try {
            int width = params.getInt(EXTRA_WIDTH_IN_PIXELS, -1);
            if (width <= 0) {
                throw new IllegalArgumentException("Field params should have the entry for the key (android.app.sdksandbox.extra.WIDTH_IN_PIXELS) with positive integer value");
            }
            int height = params.getInt(EXTRA_HEIGHT_IN_PIXELS, -1);
            if (height <= 0) {
                throw new IllegalArgumentException("Field params should have the entry for the key (android.app.sdksandbox.extra.HEIGHT_IN_PIXELS) with positive integer value");
            }
            int displayId = params.getInt(EXTRA_DISPLAY_ID, -1);
            if (displayId < 0) {
                throw new IllegalArgumentException("Field params should have the entry for the key (android.app.sdksandbox.extra.DISPLAY_ID) with integer >= 0");
            }
            IBinder hostToken = params.getBinder(EXTRA_HOST_TOKEN);
            if (hostToken == null) {
                throw new IllegalArgumentException("Field params should have the entry for the key (android.app.sdksandbox.extra.HOST_TOKEN) with not null IBinder value");
            }
            RequestSurfacePackageReceiverProxy callbackProxy = new RequestSurfacePackageReceiverProxy(callbackExecutor, receiver, this.mService);
            this.mService.requestSurfacePackage(this.mContext.getPackageName(), sdkName, hostToken, displayId, width, height, System_Delegate.currentTimeMillis(), params, callbackProxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=34)
    public void startSdkSandboxActivity(Activity fromActivity, IBinder sdkActivityToken) {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        Intent intent = new Intent();
        intent.setAction(ACTION_START_SANDBOXED_ACTIVITY);
        intent.setPackage(this.mContext.getPackageManager().getSdkSandboxPackageName());
        Bundle params = new Bundle();
        params.putBinder(EXTRA_SANDBOXED_ACTIVITY_HANDLER, sdkActivityToken);
        intent.putExtras(params);
        fromActivity.startActivity(intent);
    }

    public void addSyncedSharedPreferencesKeys(Set<String> keys) {
        Objects.requireNonNull(keys, "keys cannot be null");
        for (String key : keys) {
            if (key != null) continue;
            throw new IllegalArgumentException("keys cannot contain null");
        }
        this.mSyncManager.addSharedPreferencesSyncKeys(keys);
    }

    public void removeSyncedSharedPreferencesKeys(Set<String> keys) {
        for (String key : keys) {
            if (key != null) continue;
            throw new IllegalArgumentException("keys cannot contain null");
        }
        this.mSyncManager.removeSharedPreferencesSyncKeys(keys);
    }

    public Set<String> getSyncedSharedPreferencesKeys() {
        return this.mSyncManager.getSharedPreferencesSyncKeys();
    }

    public IBinder getAdServicesManager() {
        try {
            return this.mService.getAdServicesManager();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static class SdkSandboxProcessDeathCallbackProxy
    extends ISdkSandboxProcessDeathCallback.Stub {
        private final Executor mExecutor;
        public final SdkSandboxProcessDeathCallback callback;

        SdkSandboxProcessDeathCallbackProxy(Executor executor, SdkSandboxProcessDeathCallback lifecycleCallback) {
            this.mExecutor = executor;
            this.callback = lifecycleCallback;
        }

        @Override
        public void onSdkSandboxDied() {
            this.mExecutor.execute(() -> this.callback.onSdkSandboxDied());
        }
    }

    public static interface SdkSandboxProcessDeathCallback {
        public void onSdkSandboxDied();
    }

    private static class LoadSdkReceiverProxy
    extends ILoadSdkCallback.Stub {
        private final Executor mExecutor;
        private final OutcomeReceiver<SandboxedSdk, LoadSdkException> mCallback;
        private final ISdkSandboxManager mService;

        LoadSdkReceiverProxy(Executor executor, OutcomeReceiver<SandboxedSdk, LoadSdkException> callback, ISdkSandboxManager service) {
            this.mExecutor = executor;
            this.mCallback = callback;
            this.mService = service;
        }

        @Override
        public void onLoadSdkSuccess(SandboxedSdk sandboxedSdk, long timeSystemServerCalledApp) {
            this.logLatencyFromSystemServerToApp(timeSystemServerCalledApp);
            this.mExecutor.execute(() -> this.mCallback.onResult(sandboxedSdk));
        }

        @Override
        public void onLoadSdkFailure(LoadSdkException exception, long timeSystemServerCalledApp) {
            this.logLatencyFromSystemServerToApp(timeSystemServerCalledApp);
            this.mExecutor.execute(() -> this.mCallback.onError(exception));
        }

        private void logLatencyFromSystemServerToApp(long timeSystemServerCalledApp) {
            try {
                this.mService.logLatencyFromSystemServerToApp("LOAD_SDK", (int)(System_Delegate.currentTimeMillis() - timeSystemServerCalledApp));
            }
            catch (RemoteException e) {
                Log.w(SdkSandboxManager.TAG, "Remote exception while calling logLatencyFromSystemServerToApp.Error: " + e.getMessage());
            }
        }
    }

    private static class RequestSurfacePackageReceiverProxy
    extends IRequestSurfacePackageCallback.Stub {
        private final Executor mExecutor;
        private final OutcomeReceiver<Bundle, RequestSurfacePackageException> mReceiver;
        private final ISdkSandboxManager mService;

        RequestSurfacePackageReceiverProxy(Executor executor, OutcomeReceiver<Bundle, RequestSurfacePackageException> receiver, ISdkSandboxManager service) {
            this.mExecutor = executor;
            this.mReceiver = receiver;
            this.mService = service;
        }

        @Override
        public void onSurfacePackageReady(SurfaceControlViewHost.SurfacePackage surfacePackage, int surfacePackageId, Bundle params, long timeSystemServerCalledApp) {
            this.logLatencyFromSystemServerToApp(timeSystemServerCalledApp);
            this.mExecutor.execute(() -> {
                params.putParcelable(SdkSandboxManager.EXTRA_SURFACE_PACKAGE, surfacePackage);
                this.mReceiver.onResult(params);
            });
        }

        @Override
        public void onSurfacePackageError(int errorCode, String errorMsg, long timeSystemServerCalledApp) {
            this.logLatencyFromSystemServerToApp(timeSystemServerCalledApp);
            this.mExecutor.execute(() -> this.mReceiver.onError(new RequestSurfacePackageException(errorCode, errorMsg)));
        }

        private void logLatencyFromSystemServerToApp(long timeSystemServerCalledApp) {
            try {
                this.mService.logLatencyFromSystemServerToApp("REQUEST_SURFACE_PACKAGE", (int)(System_Delegate.currentTimeMillis() - timeSystemServerCalledApp));
            }
            catch (RemoteException e) {
                Log.w(SdkSandboxManager.TAG, "Remote exception while calling logLatencyFromSystemServerToApp.Error: " + e.getMessage());
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SdkSandboxState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestSurfacePackageErrorCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LoadSdkErrorCode {
    }
}

