/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.app.sdksandbox.ISdkSandboxManager;
import android.app.sdksandbox.ISharedPreferencesSyncCallback;
import android.app.sdksandbox.SharedPreferencesKey;
import android.app.sdksandbox.SharedPreferencesUpdate;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.RemoteException;
import android.preference.PreferenceManager;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.lang.System_Delegate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SharedPreferencesSyncManager {
    private static final String TAG = "SdkSandboxSyncManager";
    private static ArrayMap<String, SharedPreferencesSyncManager> sInstanceMap = new ArrayMap();
    private final ISdkSandboxManager mService;
    private final Context mContext;
    private final Object mLock = new Object();
    private final ISharedPreferencesSyncCallback mCallback = new SharedPreferencesSyncCallback();
    @GuardedBy(value={"mLock"})
    private boolean mWaitingForSandbox = false;
    @GuardedBy(value={"mLock"})
    private ChangeListener mListener = null;
    @GuardedBy(value={"mLock"})
    private ArraySet<String> mKeysToSync = new ArraySet();

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public SharedPreferencesSyncManager(Context context, ISdkSandboxManager service) {
        this.mContext = context.getApplicationContext();
        this.mService = service;
    }

    public static synchronized SharedPreferencesSyncManager getInstance(Context context, ISdkSandboxManager service) {
        String packageName = context.getPackageName();
        if (!sInstanceMap.containsKey(packageName)) {
            sInstanceMap.put(packageName, new SharedPreferencesSyncManager(context, service));
        }
        return sInstanceMap.get(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSharedPreferencesSyncKeys(Set<String> keyNames) {
        Object object = this.mLock;
        synchronized (object) {
            this.mKeysToSync.addAll(keyNames);
            if (this.mListener == null) {
                this.mListener = new ChangeListener();
                this.getDefaultSharedPreferences().registerOnSharedPreferenceChangeListener(this.mListener);
            }
            this.syncData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSharedPreferencesSyncKeys(Set<String> keys) {
        Object object = this.mLock;
        synchronized (object) {
            this.mKeysToSync.removeAll(keys);
            ArrayList<SharedPreferencesKey> keysWithTypeBeingRemoved = new ArrayList<SharedPreferencesKey>();
            for (String key : keys) {
                keysWithTypeBeingRemoved.add(new SharedPreferencesKey(key, 5));
            }
            SharedPreferencesUpdate update = new SharedPreferencesUpdate(keysWithTypeBeingRemoved, new Bundle());
            try {
                this.mService.syncDataFromClient(this.mContext.getPackageName(), System_Delegate.currentTimeMillis(), update, this.mCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Couldn't connect to SdkSandboxManagerService: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSharedPreferencesSyncKeys() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArraySet<String>(this.mKeysToSync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public boolean isWaitingForSandbox() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mWaitingForSandbox;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncData() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mKeysToSync.isEmpty()) {
                return;
            }
            this.bulkSyncData();
        }
    }

    @GuardedBy(value={"mLock"})
    private void bulkSyncData() {
        Bundle data = new Bundle();
        SharedPreferences pref = this.getDefaultSharedPreferences();
        Map<String, ?> allData = pref.getAll();
        ArrayList<SharedPreferencesKey> keysWithTypeBeingSynced = new ArrayList<SharedPreferencesKey>();
        for (int i = 0; i < this.mKeysToSync.size(); ++i) {
            String key = this.mKeysToSync.valueAt(i);
            Object value = allData.get(key);
            if (value == null) {
                keysWithTypeBeingSynced.add(new SharedPreferencesKey(key, 5));
                continue;
            }
            SharedPreferencesKey keyWithTypeAdded = this.updateBundle(data, key, value);
            keysWithTypeBeingSynced.add(keyWithTypeAdded);
        }
        SharedPreferencesUpdate update = new SharedPreferencesUpdate(keysWithTypeBeingSynced, data);
        try {
            this.mService.syncDataFromClient(this.mContext.getPackageName(), System_Delegate.currentTimeMillis(), update, this.mCallback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Couldn't connect to SdkSandboxManagerService: " + e.getMessage());
        }
    }

    private SharedPreferences getDefaultSharedPreferences() {
        Context appContext = this.mContext.getApplicationContext();
        return PreferenceManager.getDefaultSharedPreferences(appContext);
    }

    @GuardedBy(value={"mLock"})
    private SharedPreferencesKey updateBundle(Bundle data, String key, Object value) {
        String type = value.getClass().getSimpleName();
        try {
            switch (type) {
                case "String": {
                    data.putString(key, value.toString());
                    return new SharedPreferencesKey(key, 5);
                }
                case "Boolean": {
                    data.putBoolean(key, (Boolean)value);
                    return new SharedPreferencesKey(key, 1);
                }
                case "Integer": {
                    data.putInt(key, (Integer)value);
                    return new SharedPreferencesKey(key, 3);
                }
                case "Float": {
                    data.putFloat(key, ((Float)value).floatValue());
                    return new SharedPreferencesKey(key, 2);
                }
                case "Long": {
                    data.putLong(key, (Long)value);
                    return new SharedPreferencesKey(key, 4);
                }
                case "HashSet": {
                    data.putStringArrayList(key, new ArrayList<String>((Set)value));
                    return new SharedPreferencesKey(key, 6);
                }
            }
            Log.e(TAG, "Unknown type found in default SharedPreferences for Key: " + key + " type: " + type);
        }
        catch (ClassCastException ignore) {
            data.remove(key);
            Log.e(TAG, "Wrong type found in default SharedPreferences for Key: " + key + " Type: " + type);
        }
        return new SharedPreferencesKey(key, 5);
    }

    private class SharedPreferencesSyncCallback
    extends ISharedPreferencesSyncCallback.Stub {
        private SharedPreferencesSyncCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSandboxStart() {
            Object object = SharedPreferencesSyncManager.this.mLock;
            synchronized (object) {
                if (SharedPreferencesSyncManager.this.mWaitingForSandbox) {
                    SharedPreferencesSyncManager.this.mWaitingForSandbox = false;
                    SharedPreferencesSyncManager.this.bulkSyncData();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(int errorCode, String errorMsg) {
            Object object = SharedPreferencesSyncManager.this.mLock;
            synchronized (object) {
                if (!SharedPreferencesSyncManager.this.mWaitingForSandbox && errorCode == 1) {
                    Log.w(SharedPreferencesSyncManager.TAG, "Waiting for SdkSandbox: " + errorMsg);
                    SharedPreferencesSyncManager.this.mWaitingForSandbox = true;
                    return;
                }
                Log.e(SharedPreferencesSyncManager.TAG, "errorCode: " + errorCode + " errorMsg: " + errorMsg);
            }
        }
    }

    private class ChangeListener
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        private ChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSharedPreferenceChanged(SharedPreferences pref, String key) {
            Object object = SharedPreferencesSyncManager.this.mLock;
            synchronized (object) {
                if (SharedPreferencesSyncManager.this.mWaitingForSandbox) {
                    return;
                }
                if (key == null) {
                    SharedPreferencesSyncManager.this.bulkSyncData();
                    return;
                }
                if (!SharedPreferencesSyncManager.this.mKeysToSync.contains(key)) {
                    return;
                }
                Bundle data = new Bundle();
                Object value = pref.getAll().get(key);
                SharedPreferencesKey keyWithType = value != null ? SharedPreferencesSyncManager.this.updateBundle(data, key, value) : new SharedPreferencesKey(key, 5);
                SharedPreferencesUpdate update = new SharedPreferencesUpdate(List.of(keyWithType), data);
                try {
                    SharedPreferencesSyncManager.this.mService.syncDataFromClient(SharedPreferencesSyncManager.this.mContext.getPackageName(), System_Delegate.currentTimeMillis(), update, SharedPreferencesSyncManager.this.mCallback);
                }
                catch (RemoteException e) {
                    Log.e(SharedPreferencesSyncManager.TAG, "Couldn't connect to SdkSandboxManagerService: " + e.getMessage());
                }
            }
        }
    }
}

