/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox.sdkprovider;

import android.app.Activity;
import android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler;
import android.os.Binder;
import android.os.IBinder;
import android.util.ArrayMap;
import androidx.annotation.RequiresApi;
import com.android.internal.annotations.GuardedBy;
import java.util.Map;

public class SdkSandboxActivityRegistry {
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static SdkSandboxActivityRegistry sInstance;
    private final Object mMapsLock = new Object();
    @GuardedBy(value={"mMapsLock"})
    private final Map<SdkSandboxActivityHandler, HandlerInfo> mHandlerToHandlerInfoMap = new ArrayMap<SdkSandboxActivityHandler, HandlerInfo>();
    @GuardedBy(value={"mMapsLock"})
    private final Map<IBinder, HandlerInfo> mTokenToHandlerInfoMap = new ArrayMap<IBinder, HandlerInfo>();

    private SdkSandboxActivityRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SdkSandboxActivityRegistry getInstance() {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new SdkSandboxActivityRegistry();
            }
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=34)
    public IBinder register(String sdkName, SdkSandboxActivityHandler handler) {
        Object object = this.mMapsLock;
        synchronized (object) {
            if (this.mHandlerToHandlerInfoMap.containsKey(handler)) {
                HandlerInfo handlerInfo = this.mHandlerToHandlerInfoMap.get(handler);
                return handlerInfo.getToken();
            }
            Binder token = new Binder();
            HandlerInfo handlerInfo = new HandlerInfo(sdkName, handler, token);
            this.mHandlerToHandlerInfoMap.put(handlerInfo.getHandler(), handlerInfo);
            this.mTokenToHandlerInfoMap.put(handlerInfo.getToken(), handlerInfo);
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=34)
    public void unregister(SdkSandboxActivityHandler handler) {
        Object object = this.mMapsLock;
        synchronized (object) {
            HandlerInfo handlerInfo = this.mHandlerToHandlerInfoMap.get(handler);
            if (handlerInfo == null) {
                return;
            }
            this.mHandlerToHandlerInfoMap.remove(handlerInfo.getHandler());
            this.mTokenToHandlerInfoMap.remove(handlerInfo.getToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=34)
    public void notifyOnActivityCreation(IBinder token, Activity activity) {
        Object object = this.mMapsLock;
        synchronized (object) {
            HandlerInfo handlerInfo = this.mTokenToHandlerInfoMap.get(token);
            if (handlerInfo == null) {
                throw new IllegalArgumentException("There is no registered SdkSandboxActivityHandler to notify");
            }
            handlerInfo.getHandler().onActivityCreated(activity);
        }
    }

    private static class HandlerInfo {
        private final String mSdkName;
        private final SdkSandboxActivityHandler mHandler;
        private final IBinder mToken;

        HandlerInfo(String sdkName, SdkSandboxActivityHandler handler, IBinder token) {
            this.mSdkName = sdkName;
            this.mHandler = handler;
            this.mToken = token;
        }

        public String getSdkName() {
            return this.mSdkName;
        }

        public SdkSandboxActivityHandler getHandler() {
            return this.mHandler;
        }

        public IBinder getToken() {
            return this.mToken;
        }
    }
}

