/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox.sdkprovider;

import android.app.sdksandbox.SandboxedSdk;
import android.app.sdksandbox.SandboxedSdkContext;
import android.app.sdksandbox.SdkLevel;
import android.app.sdksandbox.SdkSandboxLocalSingleton;
import android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler;
import android.app.sdksandbox.sdkprovider.SdkSandboxActivityRegistry;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.RequiresApi;
import java.util.List;

public class SdkSandboxController {
    public static final String SDK_SANDBOX_CONTROLLER_SERVICE = "sdk_sandbox_controller_service";
    public static final String CLIENT_SHARED_PREFERENCES_NAME = "com.android.sdksandbox.client_sharedpreferences";
    private static final String TAG = "SdkSandboxController";
    private SdkSandboxLocalSingleton mSdkSandboxLocalSingleton;
    private SdkSandboxActivityRegistry mSdkSandboxActivityRegistry;
    private Context mContext;

    public SdkSandboxController(Context context) {
        this.initialize(context);
    }

    public SdkSandboxController initialize(Context context) {
        this.mContext = context;
        this.mSdkSandboxLocalSingleton = SdkSandboxLocalSingleton.getExistingInstance();
        this.mSdkSandboxActivityRegistry = SdkSandboxActivityRegistry.getInstance();
        return this;
    }

    public List<SandboxedSdk> getSandboxedSdks() {
        this.enforceSandboxedSdkContextInitialization();
        try {
            return this.mSdkSandboxLocalSingleton.getSdkToServiceCallback().getSandboxedSdks(((SandboxedSdkContext)this.mContext).getClientPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public SharedPreferences getClientSharedPreferences() {
        this.enforceSandboxedSdkContextInitialization();
        return this.mContext.getApplicationContext().getSharedPreferences(CLIENT_SHARED_PREFERENCES_NAME, 0);
    }

    @RequiresApi(value=34)
    public IBinder registerSdkSandboxActivityHandler(SdkSandboxActivityHandler sdkSandboxActivityHandler) {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        this.enforceSandboxedSdkContextInitialization();
        return this.mSdkSandboxActivityRegistry.register(this.getSdkName(), sdkSandboxActivityHandler);
    }

    @RequiresApi(value=34)
    public void unregisterSdkSandboxActivityHandler(SdkSandboxActivityHandler sdkSandboxActivityHandler) {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        this.enforceSandboxedSdkContextInitialization();
        this.mSdkSandboxActivityRegistry.unregister(sdkSandboxActivityHandler);
    }

    private void enforceSandboxedSdkContextInitialization() {
        if (!(this.mContext instanceof SandboxedSdkContext)) {
            throw new UnsupportedOperationException("Only available from the context obtained by calling android.app.sdksandbox.SandboxedSdkProvider#getContext()");
        }
    }

    private String getSdkName() {
        return ((SandboxedSdkContext)this.mContext).getSdkName();
    }
}

