/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.content.Intent;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.text.TextUtils;
import java.util.Objects;

@SystemApi
public class SmartspaceAction
implements Parcelable {
    private static final String TAG = "SmartspaceAction";
    private final String mId;
    private final Icon mIcon;
    private final CharSequence mTitle;
    private final CharSequence mSubtitle;
    private final CharSequence mContentDescription;
    private final PendingIntent mPendingIntent;
    private final Intent mIntent;
    private final UserHandle mUserHandle;
    private Bundle mExtras;
    public static final Parcelable.Creator<SmartspaceAction> CREATOR = new Parcelable.Creator<SmartspaceAction>(){

        @Override
        public SmartspaceAction createFromParcel(Parcel in) {
            return new SmartspaceAction(in);
        }

        public SmartspaceAction[] newArray(int size) {
            return new SmartspaceAction[size];
        }
    };

    SmartspaceAction(Parcel in) {
        this.mId = in.readString();
        this.mIcon = in.readTypedObject(Icon.CREATOR);
        this.mTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mSubtitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mPendingIntent = in.readTypedObject(PendingIntent.CREATOR);
        this.mIntent = in.readTypedObject(Intent.CREATOR);
        this.mUserHandle = in.readTypedObject(UserHandle.CREATOR);
        this.mExtras = in.readBundle();
    }

    private SmartspaceAction(String id2, Icon icon, CharSequence title, CharSequence subtitle, CharSequence contentDescription, PendingIntent pendingIntent, Intent intent, UserHandle userHandle, Bundle extras) {
        this.mId = Objects.requireNonNull(id2);
        this.mIcon = icon;
        this.mTitle = Objects.requireNonNull(title);
        this.mSubtitle = subtitle;
        this.mContentDescription = contentDescription;
        this.mPendingIntent = pendingIntent;
        this.mIntent = intent;
        this.mUserHandle = userHandle;
        this.mExtras = extras;
    }

    public String getId() {
        return this.mId;
    }

    public Icon getIcon() {
        return this.mIcon;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public UserHandle getUserHandle() {
        return this.mUserHandle;
    }

    @SuppressLint(value={"NullableCollection"})
    public Bundle getExtras() {
        return this.mExtras;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SmartspaceAction)) {
            return false;
        }
        SmartspaceAction that = (SmartspaceAction)o;
        return this.mId.equals(that.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mId);
        out.writeTypedObject(this.mIcon, flags);
        TextUtils.writeToParcel(this.mTitle, out, flags);
        TextUtils.writeToParcel(this.mSubtitle, out, flags);
        TextUtils.writeToParcel(this.mContentDescription, out, flags);
        out.writeTypedObject(this.mPendingIntent, flags);
        out.writeTypedObject(this.mIntent, flags);
        out.writeTypedObject(this.mUserHandle, flags);
        out.writeBundle(this.mExtras);
    }

    public String toString() {
        return "SmartspaceAction{mId='" + this.mId + '\'' + ", mIcon=" + this.mIcon + ", mTitle=" + this.mTitle + ", mSubtitle=" + this.mSubtitle + ", mContentDescription=" + this.mContentDescription + ", mPendingIntent=" + this.mPendingIntent + ", mIntent=" + this.mIntent + ", mUserHandle=" + this.mUserHandle + ", mExtras=" + this.mExtras + '}';
    }

    @SystemApi
    public static class Builder {
        private String mId;
        private Icon mIcon;
        private CharSequence mTitle;
        private CharSequence mSubtitle;
        private CharSequence mContentDescription;
        private PendingIntent mPendingIntent;
        private Intent mIntent;
        private UserHandle mUserHandle;
        private Bundle mExtras;

        public Builder(String id2, String title) {
            this.mId = Objects.requireNonNull(id2);
            this.mTitle = Objects.requireNonNull(title);
        }

        public Builder setIcon(Icon icon) {
            this.mIcon = icon;
            return this;
        }

        public Builder setSubtitle(CharSequence subtitle) {
            this.mSubtitle = subtitle;
            return this;
        }

        public Builder setContentDescription(CharSequence contentDescription) {
            this.mContentDescription = contentDescription;
            return this;
        }

        public Builder setPendingIntent(PendingIntent pendingIntent) {
            this.mPendingIntent = pendingIntent;
            return this;
        }

        public Builder setUserHandle(UserHandle userHandle) {
            this.mUserHandle = userHandle;
            return this;
        }

        public Builder setIntent(Intent intent) {
            this.mIntent = intent;
            return this;
        }

        public Builder setExtras(@SuppressLint(value={"NullableCollection"}) Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        public SmartspaceAction build() {
            if (this.mIcon != null) {
                this.mIcon.convertToAshmem();
            }
            return new SmartspaceAction(this.mId, this.mIcon, this.mTitle, this.mSubtitle, this.mContentDescription, this.mPendingIntent, this.mIntent, this.mUserHandle, this.mExtras);
        }
    }
}

