/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class TimeConfiguration
implements Parcelable {
    public static final Parcelable.Creator<TimeConfiguration> CREATOR = new Parcelable.Creator<TimeConfiguration>(){

        @Override
        public TimeConfiguration createFromParcel(Parcel source) {
            return TimeConfiguration.readFromParcel(source);
        }

        public TimeConfiguration[] newArray(int size) {
            return new TimeConfiguration[size];
        }
    };
    private static final String SETTING_AUTO_DETECTION_ENABLED = "autoDetectionEnabled";
    private final Bundle mBundle;

    private TimeConfiguration(Builder builder) {
        this.mBundle = builder.mBundle;
    }

    private static TimeConfiguration readFromParcel(Parcel in) {
        return new Builder().setPropertyBundleInternal(in.readBundle()).build();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.mBundle);
    }

    public boolean isComplete() {
        return this.hasIsAutoDetectionEnabled();
    }

    public boolean isAutoDetectionEnabled() {
        this.enforceSettingPresent(SETTING_AUTO_DETECTION_ENABLED);
        return this.mBundle.getBoolean(SETTING_AUTO_DETECTION_ENABLED);
    }

    public boolean hasIsAutoDetectionEnabled() {
        return this.mBundle.containsKey(SETTING_AUTO_DETECTION_ENABLED);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeConfiguration that = (TimeConfiguration)o;
        return this.mBundle.kindofEquals(that.mBundle);
    }

    public int hashCode() {
        return Objects.hash(this.mBundle);
    }

    public String toString() {
        return "TimeConfiguration{mBundle=" + this.mBundle + '}';
    }

    private void enforceSettingPresent(String setting) {
        if (!this.mBundle.containsKey(setting)) {
            throw new IllegalStateException(setting + " is not set");
        }
    }

    @SystemApi
    public static class Builder {
        private final Bundle mBundle = new Bundle();

        public Builder() {
        }

        public Builder(TimeConfiguration toCopy) {
            this.mergeProperties(toCopy);
        }

        public Builder mergeProperties(TimeConfiguration toCopy) {
            this.mBundle.putAll(toCopy.mBundle);
            return this;
        }

        Builder setPropertyBundleInternal(Bundle bundle) {
            this.mBundle.putAll(bundle);
            return this;
        }

        public Builder setAutoDetectionEnabled(boolean enabled) {
            this.mBundle.putBoolean(TimeConfiguration.SETTING_AUTO_DETECTION_ENABLED, enabled);
            return this;
        }

        public TimeConfiguration build() {
            return new TimeConfiguration(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Setting {
    }
}

