/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.SystemApi;
import android.app.time.TimeZoneConfiguration;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.util.Objects;

@SystemApi
public class TimeZoneCapabilities
implements Parcelable {
    public static final Parcelable.Creator<TimeZoneCapabilities> CREATOR = new Parcelable.Creator<TimeZoneCapabilities>(){

        @Override
        public TimeZoneCapabilities createFromParcel(Parcel in) {
            return TimeZoneCapabilities.createFromParcel(in);
        }

        public TimeZoneCapabilities[] newArray(int size) {
            return new TimeZoneCapabilities[size];
        }
    };
    private final UserHandle mUserHandle;
    private final int mConfigureAutoDetectionEnabledCapability;
    private final boolean mUseLocationEnabled;
    private final int mConfigureGeoDetectionEnabledCapability;
    private final int mSetManualTimeZoneCapability;

    private TimeZoneCapabilities(Builder builder) {
        this.mUserHandle = Objects.requireNonNull(builder.mUserHandle);
        this.mConfigureAutoDetectionEnabledCapability = builder.mConfigureAutoDetectionEnabledCapability;
        this.mUseLocationEnabled = builder.mUseLocationEnabled;
        this.mConfigureGeoDetectionEnabledCapability = builder.mConfigureGeoDetectionEnabledCapability;
        this.mSetManualTimeZoneCapability = builder.mSetManualTimeZoneCapability;
    }

    private static TimeZoneCapabilities createFromParcel(Parcel in) {
        UserHandle userHandle = UserHandle.readFromParcel(in);
        return new Builder(userHandle).setConfigureAutoDetectionEnabledCapability(in.readInt()).setUseLocationEnabled(in.readBoolean()).setConfigureGeoDetectionEnabledCapability(in.readInt()).setSetManualTimeZoneCapability(in.readInt()).build();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        UserHandle.writeToParcel(this.mUserHandle, dest);
        dest.writeInt(this.mConfigureAutoDetectionEnabledCapability);
        dest.writeBoolean(this.mUseLocationEnabled);
        dest.writeInt(this.mConfigureGeoDetectionEnabledCapability);
        dest.writeInt(this.mSetManualTimeZoneCapability);
    }

    public int getConfigureAutoDetectionEnabledCapability() {
        return this.mConfigureAutoDetectionEnabledCapability;
    }

    public boolean isUseLocationEnabled() {
        return this.mUseLocationEnabled;
    }

    public int getConfigureGeoDetectionEnabledCapability() {
        return this.mConfigureGeoDetectionEnabledCapability;
    }

    public int getSetManualTimeZoneCapability() {
        return this.mSetManualTimeZoneCapability;
    }

    public TimeZoneConfiguration tryApplyConfigChanges(TimeZoneConfiguration config, TimeZoneConfiguration requestedChanges) {
        TimeZoneConfiguration.Builder newConfigBuilder = new TimeZoneConfiguration.Builder(config);
        if (requestedChanges.hasIsAutoDetectionEnabled()) {
            if (this.getConfigureAutoDetectionEnabledCapability() < 30) {
                return null;
            }
            newConfigBuilder.setAutoDetectionEnabled(requestedChanges.isAutoDetectionEnabled());
        }
        if (requestedChanges.hasIsGeoDetectionEnabled()) {
            if (this.getConfigureGeoDetectionEnabledCapability() < 30) {
                return null;
            }
            newConfigBuilder.setGeoDetectionEnabled(requestedChanges.isGeoDetectionEnabled());
        }
        return newConfigBuilder.build();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeZoneCapabilities that = (TimeZoneCapabilities)o;
        return this.mUserHandle.equals(that.mUserHandle) && this.mConfigureAutoDetectionEnabledCapability == that.mConfigureAutoDetectionEnabledCapability && this.mUseLocationEnabled == that.mUseLocationEnabled && this.mConfigureGeoDetectionEnabledCapability == that.mConfigureGeoDetectionEnabledCapability && this.mSetManualTimeZoneCapability == that.mSetManualTimeZoneCapability;
    }

    public int hashCode() {
        return Objects.hash(this.mUserHandle, this.mConfigureAutoDetectionEnabledCapability, this.mConfigureGeoDetectionEnabledCapability, this.mSetManualTimeZoneCapability);
    }

    public String toString() {
        return "TimeZoneDetectorCapabilities{mUserHandle=" + this.mUserHandle + ", mConfigureAutoDetectionEnabledCapability=" + this.mConfigureAutoDetectionEnabledCapability + ", mUseLocationEnabled=" + this.mUseLocationEnabled + ", mConfigureGeoDetectionEnabledCapability=" + this.mConfigureGeoDetectionEnabledCapability + ", mSetManualTimeZoneCapability=" + this.mSetManualTimeZoneCapability + '}';
    }

    public static class Builder {
        private UserHandle mUserHandle;
        private int mConfigureAutoDetectionEnabledCapability;
        private Boolean mUseLocationEnabled;
        private int mConfigureGeoDetectionEnabledCapability;
        private int mSetManualTimeZoneCapability;

        public Builder(UserHandle userHandle) {
            this.mUserHandle = Objects.requireNonNull(userHandle);
        }

        public Builder(TimeZoneCapabilities capabilitiesToCopy) {
            Objects.requireNonNull(capabilitiesToCopy);
            this.mUserHandle = capabilitiesToCopy.mUserHandle;
            this.mConfigureAutoDetectionEnabledCapability = capabilitiesToCopy.mConfigureAutoDetectionEnabledCapability;
            this.mUseLocationEnabled = capabilitiesToCopy.mUseLocationEnabled;
            this.mConfigureGeoDetectionEnabledCapability = capabilitiesToCopy.mConfigureGeoDetectionEnabledCapability;
            this.mSetManualTimeZoneCapability = capabilitiesToCopy.mSetManualTimeZoneCapability;
        }

        public Builder setConfigureAutoDetectionEnabledCapability(int value) {
            this.mConfigureAutoDetectionEnabledCapability = value;
            return this;
        }

        public Builder setUseLocationEnabled(boolean useLocation) {
            this.mUseLocationEnabled = useLocation;
            return this;
        }

        public Builder setConfigureGeoDetectionEnabledCapability(int value) {
            this.mConfigureGeoDetectionEnabledCapability = value;
            return this;
        }

        public Builder setSetManualTimeZoneCapability(int value) {
            this.mSetManualTimeZoneCapability = value;
            return this;
        }

        public TimeZoneCapabilities build() {
            this.verifyCapabilitySet(this.mConfigureAutoDetectionEnabledCapability, "configureAutoDetectionEnabledCapability");
            Objects.requireNonNull(this.mUseLocationEnabled, "useLocationEnabled");
            this.verifyCapabilitySet(this.mConfigureGeoDetectionEnabledCapability, "configureGeoDetectionEnabledCapability");
            this.verifyCapabilitySet(this.mSetManualTimeZoneCapability, "mSetManualTimeZoneCapability");
            return new TimeZoneCapabilities(this);
        }

        private void verifyCapabilitySet(int value, String name) {
            if (value == 0) {
                throw new IllegalStateException(name + " not set");
            }
        }
    }
}

