/*
 * Decompiled with CFR 0.152.
 */
package android.app.timedetector;

import android.app.time.UnixEpochTime;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ShellCommand;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TelephonyTimeSuggestion
implements Parcelable {
    public static final Parcelable.Creator<TelephonyTimeSuggestion> CREATOR = new Parcelable.Creator<TelephonyTimeSuggestion>(){

        @Override
        public TelephonyTimeSuggestion createFromParcel(Parcel in) {
            return TelephonyTimeSuggestion.createFromParcel(in);
        }

        public TelephonyTimeSuggestion[] newArray(int size) {
            return new TelephonyTimeSuggestion[size];
        }
    };
    private final int mSlotIndex;
    private final UnixEpochTime mUnixEpochTime;
    private ArrayList<String> mDebugInfo;

    private TelephonyTimeSuggestion(Builder builder) {
        this.mSlotIndex = builder.mSlotIndex;
        this.mUnixEpochTime = builder.mUnixEpochTime;
        this.mDebugInfo = builder.mDebugInfo != null ? new ArrayList<String>(builder.mDebugInfo) : null;
    }

    private static TelephonyTimeSuggestion createFromParcel(Parcel in) {
        int slotIndex = in.readInt();
        UnixEpochTime unixEpochTime = in.readParcelable(null, UnixEpochTime.class);
        TelephonyTimeSuggestion suggestion = new Builder(slotIndex).setUnixEpochTime(unixEpochTime).build();
        ArrayList<String> debugInfo = in.readArrayList(null, String.class);
        if (debugInfo != null) {
            suggestion.addDebugInfo(debugInfo);
        }
        return suggestion;
    }

    public static TelephonyTimeSuggestion parseCommandLineArg(ShellCommand cmd) throws IllegalArgumentException {
        String opt;
        Integer slotIndex = null;
        Long elapsedRealtimeMillis = null;
        Long unixEpochTimeMillis = null;
        block11: while ((opt = cmd.getNextArg()) != null) {
            switch (opt) {
                case "--slot_index": {
                    slotIndex = Integer.parseInt(cmd.getNextArgRequired());
                    continue block11;
                }
                case "--reference_time": 
                case "--elapsed_realtime": {
                    elapsedRealtimeMillis = Long.parseLong(cmd.getNextArgRequired());
                    continue block11;
                }
                case "--unix_epoch_time": {
                    unixEpochTimeMillis = Long.parseLong(cmd.getNextArgRequired());
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Unknown option: " + opt);
        }
        if (slotIndex == null) {
            throw new IllegalArgumentException("No slotIndex specified.");
        }
        if (elapsedRealtimeMillis == null) {
            throw new IllegalArgumentException("No elapsedRealtimeMillis specified.");
        }
        if (unixEpochTimeMillis == null) {
            throw new IllegalArgumentException("No unixEpochTimeMillis specified.");
        }
        UnixEpochTime timeSignal = new UnixEpochTime(elapsedRealtimeMillis, unixEpochTimeMillis);
        Builder builder = new Builder(slotIndex).setUnixEpochTime(timeSignal).addDebugInfo("Command line injection");
        return builder.build();
    }

    public static void printCommandLineOpts(PrintWriter pw) {
        pw.println("Telephony suggestion options:");
        pw.println("  --slot_index <number>");
        pw.println("  --elapsed_realtime <elapsed realtime millis>");
        pw.println("  --unix_epoch_time <Unix epoch time millis>");
        pw.println();
        pw.println("See " + TelephonyTimeSuggestion.class.getName() + " for more information");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSlotIndex);
        dest.writeParcelable(this.mUnixEpochTime, 0);
        dest.writeList(this.mDebugInfo);
    }

    public int getSlotIndex() {
        return this.mSlotIndex;
    }

    public UnixEpochTime getUnixEpochTime() {
        return this.mUnixEpochTime;
    }

    public List<String> getDebugInfo() {
        return this.mDebugInfo == null ? Collections.emptyList() : Collections.unmodifiableList(this.mDebugInfo);
    }

    public void addDebugInfo(String debugInfo) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList();
        }
        this.mDebugInfo.add(debugInfo);
    }

    public void addDebugInfo(List<String> debugInfo) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList(debugInfo.size());
        }
        this.mDebugInfo.addAll(debugInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelephonyTimeSuggestion that = (TelephonyTimeSuggestion)o;
        return this.mSlotIndex == that.mSlotIndex && Objects.equals(this.mUnixEpochTime, that.mUnixEpochTime);
    }

    public int hashCode() {
        return Objects.hash(this.mSlotIndex, this.mUnixEpochTime);
    }

    public String toString() {
        return "TelephonyTimeSuggestion{mSlotIndex='" + this.mSlotIndex + '\'' + ", mUnixEpochTime=" + this.mUnixEpochTime + ", mDebugInfo=" + this.mDebugInfo + '}';
    }

    public static class Builder {
        private final int mSlotIndex;
        private UnixEpochTime mUnixEpochTime;
        private List<String> mDebugInfo;

        public Builder(int slotIndex) {
            this.mSlotIndex = slotIndex;
        }

        public Builder setUnixEpochTime(UnixEpochTime unixEpochTime) {
            this.mUnixEpochTime = unixEpochTime;
            return this;
        }

        public Builder addDebugInfo(String debugInfo) {
            if (this.mDebugInfo == null) {
                this.mDebugInfo = new ArrayList<String>();
            }
            this.mDebugInfo.add(debugInfo);
            return this;
        }

        public TelephonyTimeSuggestion build() {
            return new TelephonyTimeSuggestion(this);
        }
    }
}

