/*
 * Decompiled with CFR 0.152.
 */
package android.app.timedetector;

import android.app.time.UnixEpochTime;
import android.os.Parcel;
import android.os.ShellCommand;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TimeSuggestionHelper {
    private final Class<?> mHelpedClass;
    private final UnixEpochTime mUnixEpochTime;
    private ArrayList<String> mDebugInfo;

    public TimeSuggestionHelper(Class<?> helpedClass, UnixEpochTime unixEpochTime) {
        this.mHelpedClass = Objects.requireNonNull(helpedClass);
        this.mUnixEpochTime = Objects.requireNonNull(unixEpochTime);
    }

    public UnixEpochTime getUnixEpochTime() {
        return this.mUnixEpochTime;
    }

    public List<String> getDebugInfo() {
        return this.mDebugInfo == null ? Collections.emptyList() : Collections.unmodifiableList(this.mDebugInfo);
    }

    public void addDebugInfo(String debugInfo) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList();
        }
        this.mDebugInfo.add(debugInfo);
    }

    public void addDebugInfo(String ... debugInfos) {
        this.addDebugInfo(Arrays.asList(debugInfos));
    }

    public void addDebugInfo(List<String> debugInfo) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList(debugInfo.size());
        }
        this.mDebugInfo.addAll(debugInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSuggestionHelper that = (TimeSuggestionHelper)o;
        return this.handleEquals(that);
    }

    public boolean handleEquals(TimeSuggestionHelper o) {
        return Objects.equals(this.mHelpedClass, o.mHelpedClass) && Objects.equals(this.mUnixEpochTime, o.mUnixEpochTime);
    }

    public int hashCode() {
        return Objects.hash(this.mUnixEpochTime);
    }

    public String handleToString() {
        return this.mHelpedClass.getSimpleName() + "{mUnixEpochTime=" + this.mUnixEpochTime + ", mDebugInfo=" + this.mDebugInfo + '}';
    }

    public static TimeSuggestionHelper handleCreateFromParcel(Class<?> helpedClass, Parcel in) {
        UnixEpochTime unixEpochTime = in.readParcelable(null, UnixEpochTime.class);
        TimeSuggestionHelper suggestionHelper = new TimeSuggestionHelper(helpedClass, unixEpochTime);
        suggestionHelper.mDebugInfo = in.readArrayList(null, String.class);
        return suggestionHelper;
    }

    public void handleWriteToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mUnixEpochTime, 0);
        dest.writeList(this.mDebugInfo);
    }

    public static TimeSuggestionHelper handleParseCommandLineArg(Class<?> helpedClass, ShellCommand cmd) throws IllegalArgumentException {
        String opt;
        Long elapsedRealtimeMillis = null;
        Long unixEpochTimeMillis = null;
        block9: while ((opt = cmd.getNextArg()) != null) {
            switch (opt) {
                case "--reference_time": 
                case "--elapsed_realtime": {
                    elapsedRealtimeMillis = Long.parseLong(cmd.getNextArgRequired());
                    continue block9;
                }
                case "--unix_epoch_time": {
                    unixEpochTimeMillis = Long.parseLong(cmd.getNextArgRequired());
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Unknown option: " + opt);
        }
        if (elapsedRealtimeMillis == null) {
            throw new IllegalArgumentException("No referenceTimeMillis specified.");
        }
        if (unixEpochTimeMillis == null) {
            throw new IllegalArgumentException("No unixEpochTimeMillis specified.");
        }
        UnixEpochTime timeSignal = new UnixEpochTime(elapsedRealtimeMillis, unixEpochTimeMillis);
        TimeSuggestionHelper suggestionHelper = new TimeSuggestionHelper(helpedClass, timeSignal);
        suggestionHelper.addDebugInfo("Command line injection");
        return suggestionHelper;
    }

    public static void handlePrintCommandLineOpts(PrintWriter pw, String typeName, Class<?> clazz) {
        pw.printf("%s suggestion options:\n", typeName);
        pw.println("  --elapsed_realtime <elapsed realtime millis> - the elapsed realtime millis when unix epoch time was read");
        pw.println("  --unix_epoch_time <Unix epoch time millis>");
        pw.println();
        pw.println("See " + clazz.getName() + " for more information");
    }
}

