/*
 * Decompiled with CFR 0.152.
 */
package android.app.trust;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public interface ITrustListener
extends IInterface {
    public void onEnabledTrustAgentsChanged(int var1) throws RemoteException;

    public void onTrustChanged(boolean var1, boolean var2, int var3, int var4, List<String> var5) throws RemoteException;

    public void onTrustManagedChanged(boolean var1, int var2) throws RemoteException;

    public void onTrustError(CharSequence var1) throws RemoteException;

    public void onIsActiveUnlockRunningChanged(boolean var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITrustListener {
        public static final String DESCRIPTOR = "android.app.trust.ITrustListener";
        static final int TRANSACTION_onEnabledTrustAgentsChanged = 1;
        static final int TRANSACTION_onTrustChanged = 2;
        static final int TRANSACTION_onTrustManagedChanged = 3;
        static final int TRANSACTION_onTrustError = 4;
        static final int TRANSACTION_onIsActiveUnlockRunningChanged = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITrustListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITrustListener) {
                return (ITrustListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onEnabledTrustAgentsChanged";
                }
                case 2: {
                    return "onTrustChanged";
                }
                case 3: {
                    return "onTrustManagedChanged";
                }
                case 4: {
                    return "onTrustError";
                }
                case 5: {
                    return "onIsActiveUnlockRunningChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onEnabledTrustAgentsChanged(_arg0);
                    break;
                }
                case 2: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    ArrayList<String> _arg4 = data.createStringArrayList();
                    data.enforceNoDataAvail();
                    this.onTrustChanged(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTrustManagedChanged(_arg0, _arg1);
                    break;
                }
                case 4: {
                    CharSequence _arg0 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.onTrustError(_arg0);
                    break;
                }
                case 5: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onIsActiveUnlockRunningChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements ITrustListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnabledTrustAgentsChanged(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTrustChanged(boolean enabled, boolean newlyUnlocked, int userId, int flags, List<String> trustGrantedMessages) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeBoolean(newlyUnlocked);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    _data.writeStringList(trustGrantedMessages);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTrustManagedChanged(boolean managed, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(managed);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTrustError(CharSequence message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (message != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(message, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIsActiveUnlockRunningChanged(boolean isRunning, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isRunning);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITrustListener {
        @Override
        public void onEnabledTrustAgentsChanged(int userId) throws RemoteException {
        }

        @Override
        public void onTrustChanged(boolean enabled, boolean newlyUnlocked, int userId, int flags, List<String> trustGrantedMessages) throws RemoteException {
        }

        @Override
        public void onTrustManagedChanged(boolean managed, int userId) throws RemoteException {
        }

        @Override
        public void onTrustError(CharSequence message) throws RemoteException {
        }

        @Override
        public void onIsActiveUnlockRunningChanged(boolean isRunning, int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

