/*
 * Decompiled with CFR 0.152.
 */
package android.app.trust;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.app.trust.ITrustListener;
import android.hardware.biometrics.BiometricSourceType;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;

public interface ITrustManager
extends IInterface {
    public void reportUnlockAttempt(boolean var1, int var2) throws RemoteException;

    public void reportUserRequestedUnlock(int var1, boolean var2) throws RemoteException;

    public void reportUserMayRequestUnlock(int var1) throws RemoteException;

    public void reportUnlockLockout(int var1, int var2) throws RemoteException;

    public void reportEnabledTrustAgentsChanged(int var1) throws RemoteException;

    public void registerTrustListener(ITrustListener var1) throws RemoteException;

    public void unregisterTrustListener(ITrustListener var1) throws RemoteException;

    public void reportKeyguardShowingChanged() throws RemoteException;

    public void setDeviceLockedForUser(int var1, boolean var2) throws RemoteException;

    public boolean isDeviceLocked(int var1, int var2) throws RemoteException;

    public boolean isDeviceSecure(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.TRUST_LISTENER")
    public boolean isTrustUsuallyManaged(int var1) throws RemoteException;

    public void unlockedByBiometricForUser(int var1, BiometricSourceType var2) throws RemoteException;

    public void clearAllBiometricRecognized(BiometricSourceType var1, int var2) throws RemoteException;

    public boolean isActiveUnlockRunning(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITrustManager {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.app.trust.ITrustManager";
        static final int TRANSACTION_reportUnlockAttempt = 1;
        static final int TRANSACTION_reportUserRequestedUnlock = 2;
        static final int TRANSACTION_reportUserMayRequestUnlock = 3;
        static final int TRANSACTION_reportUnlockLockout = 4;
        static final int TRANSACTION_reportEnabledTrustAgentsChanged = 5;
        static final int TRANSACTION_registerTrustListener = 6;
        static final int TRANSACTION_unregisterTrustListener = 7;
        static final int TRANSACTION_reportKeyguardShowingChanged = 8;
        static final int TRANSACTION_setDeviceLockedForUser = 9;
        static final int TRANSACTION_isDeviceLocked = 10;
        static final int TRANSACTION_isDeviceSecure = 11;
        static final int TRANSACTION_isTrustUsuallyManaged = 12;
        static final int TRANSACTION_unlockedByBiometricForUser = 13;
        static final int TRANSACTION_clearAllBiometricRecognized = 14;
        static final int TRANSACTION_isActiveUnlockRunning = 15;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static ITrustManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITrustManager) {
                return (ITrustManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "reportUnlockAttempt";
                }
                case 2: {
                    return "reportUserRequestedUnlock";
                }
                case 3: {
                    return "reportUserMayRequestUnlock";
                }
                case 4: {
                    return "reportUnlockLockout";
                }
                case 5: {
                    return "reportEnabledTrustAgentsChanged";
                }
                case 6: {
                    return "registerTrustListener";
                }
                case 7: {
                    return "unregisterTrustListener";
                }
                case 8: {
                    return "reportKeyguardShowingChanged";
                }
                case 9: {
                    return "setDeviceLockedForUser";
                }
                case 10: {
                    return "isDeviceLocked";
                }
                case 11: {
                    return "isDeviceSecure";
                }
                case 12: {
                    return "isTrustUsuallyManaged";
                }
                case 13: {
                    return "unlockedByBiometricForUser";
                }
                case 14: {
                    return "clearAllBiometricRecognized";
                }
                case 15: {
                    return "isActiveUnlockRunning";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportUnlockAttempt(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.reportUserRequestedUnlock(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportUserMayRequestUnlock(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportUnlockLockout(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportEnabledTrustAgentsChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    ITrustListener _arg0 = ITrustListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerTrustListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    ITrustListener _arg0 = ITrustListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterTrustListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    this.reportKeyguardShowingChanged();
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDeviceLockedForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isDeviceLocked(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isDeviceSecure(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isTrustUsuallyManaged(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    BiometricSourceType _arg1 = data.readTypedObject(BiometricSourceType.CREATOR);
                    data.enforceNoDataAvail();
                    this.unlockedByBiometricForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    BiometricSourceType _arg0 = data.readTypedObject(BiometricSourceType.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearAllBiometricRecognized(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isActiveUnlockRunning(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void isTrustUsuallyManaged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TRUST_LISTENER", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 14;
        }

        private static class Proxy
        implements ITrustManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportUnlockAttempt(boolean successful, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(successful);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportUserRequestedUnlock(int userId, boolean dismissKeyguard) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeBoolean(dismissKeyguard);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportUserMayRequestUnlock(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportUnlockLockout(int timeoutMs, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(timeoutMs);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportEnabledTrustAgentsChanged(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTrustListener(ITrustListener trustListener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(trustListener);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterTrustListener(ITrustListener trustListener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(trustListener);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportKeyguardShowingChanged() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceLockedForUser(int userId, boolean locked) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeBoolean(locked);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeviceLocked(int userId, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeviceSecure(int userId, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTrustUsuallyManaged(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlockedByBiometricForUser(int userId, BiometricSourceType source) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(source, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearAllBiometricRecognized(BiometricSourceType target, int unlockedUser) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(target, 0);
                    _data.writeInt(unlockedUser);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isActiveUnlockRunning(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ITrustManager {
        @Override
        public void reportUnlockAttempt(boolean successful, int userId) throws RemoteException {
        }

        @Override
        public void reportUserRequestedUnlock(int userId, boolean dismissKeyguard) throws RemoteException {
        }

        @Override
        public void reportUserMayRequestUnlock(int userId) throws RemoteException {
        }

        @Override
        public void reportUnlockLockout(int timeoutMs, int userId) throws RemoteException {
        }

        @Override
        public void reportEnabledTrustAgentsChanged(int userId) throws RemoteException {
        }

        @Override
        public void registerTrustListener(ITrustListener trustListener) throws RemoteException {
        }

        @Override
        public void unregisterTrustListener(ITrustListener trustListener) throws RemoteException {
        }

        @Override
        public void reportKeyguardShowingChanged() throws RemoteException {
        }

        @Override
        public void setDeviceLockedForUser(int userId, boolean locked) throws RemoteException {
        }

        @Override
        public boolean isDeviceLocked(int userId, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isDeviceSecure(int userId, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isTrustUsuallyManaged(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void unlockedByBiometricForUser(int userId, BiometricSourceType source) throws RemoteException {
        }

        @Override
        public void clearAllBiometricRecognized(BiometricSourceType target, int unlockedUser) throws RemoteException {
        }

        @Override
        public boolean isActiveUnlockRunning(int userId) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

