/*
 * Decompiled with CFR 0.152.
 */
package android.app.trust;

import android.annotation.RequiresPermission;
import android.app.trust.ITrustListener;
import android.app.trust.ITrustManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.hardware.biometrics.BiometricSourceType;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.ArrayMap;
import java.util.ArrayList;
import java.util.List;

public class TrustManager {
    private static final int MSG_TRUST_CHANGED = 1;
    private static final int MSG_TRUST_MANAGED_CHANGED = 2;
    private static final int MSG_TRUST_ERROR = 3;
    private static final int MSG_ENABLED_TRUST_AGENTS_CHANGED = 4;
    private static final int MSG_IS_ACTIVE_UNLOCK_RUNNING = 5;
    private static final String TAG = "TrustManager";
    private static final String DATA_FLAGS = "initiatedByUser";
    private static final String DATA_NEWLY_UNLOCKED = "newlyUnlocked";
    private static final String DATA_MESSAGE = "message";
    private static final String DATA_GRANTED_MESSAGES = "grantedMessages";
    private final ITrustManager mService;
    private final ArrayMap<TrustListener, ITrustListener> mTrustListeners;
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Bundle data = msg.peekData();
                    int flags = data != null ? data.getInt(TrustManager.DATA_FLAGS) : 0;
                    boolean enabled = msg.arg1 != 0;
                    int newlyUnlockedInt = data != null ? data.getInt(TrustManager.DATA_NEWLY_UNLOCKED) : 0;
                    boolean newlyUnlocked = newlyUnlockedInt != 0;
                    ((TrustListener)msg.obj).onTrustChanged(enabled, newlyUnlocked, msg.arg2, flags, msg.getData().getStringArrayList(TrustManager.DATA_GRANTED_MESSAGES));
                    break;
                }
                case 2: {
                    ((TrustListener)msg.obj).onTrustManagedChanged(msg.arg1 != 0, msg.arg2);
                    break;
                }
                case 3: {
                    CharSequence message = msg.peekData().getCharSequence(TrustManager.DATA_MESSAGE);
                    ((TrustListener)msg.obj).onTrustError(message);
                    break;
                }
                case 4: {
                    ((TrustListener)msg.obj).onEnabledTrustAgentsChanged(msg.arg1);
                    break;
                }
                case 5: {
                    ((TrustListener)msg.obj).onIsActiveUnlockRunningChanged(msg.arg1 != 0, msg.arg2);
                }
            }
        }
    };

    public TrustManager(IBinder b) {
        this.mService = ITrustManager.Stub.asInterface(b);
        this.mTrustListeners = new ArrayMap();
    }

    @RequiresPermission(value="android.permission.ACCESS_KEYGUARD_SECURE_STORAGE")
    public void setDeviceLockedForUser(int userId, boolean locked) {
        try {
            this.mService.setDeviceLockedForUser(userId, locked);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void reportUnlockAttempt(boolean successful, int userId) {
        try {
            this.mService.reportUnlockAttempt(successful, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportUserRequestedUnlock(int userId, boolean dismissKeyguard) {
        try {
            this.mService.reportUserRequestedUnlock(userId, dismissKeyguard);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportUserMayRequestUnlock(int userId) {
        try {
            this.mService.reportUserMayRequestUnlock(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportUnlockLockout(int timeoutMs, int userId) {
        try {
            this.mService.reportUnlockLockout(timeoutMs, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportEnabledTrustAgentsChanged(int userId) {
        try {
            this.mService.reportEnabledTrustAgentsChanged(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reportKeyguardShowingChanged() {
        try {
            this.mService.reportKeyguardShowingChanged();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isActiveUnlockRunning(int userId) {
        try {
            return this.mService.isActiveUnlockRunning(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void registerTrustListener(final TrustListener trustListener) {
        try {
            ITrustListener.Stub iTrustListener = new ITrustListener.Stub(){

                @Override
                public void onTrustChanged(boolean enabled, boolean newlyUnlocked, int userId, int flags, List<String> trustGrantedMessages) {
                    Message m = TrustManager.this.mHandler.obtainMessage(1, enabled ? 1 : 0, userId, trustListener);
                    if (flags != 0) {
                        m.getData().putInt(TrustManager.DATA_FLAGS, flags);
                    }
                    m.getData().putInt(TrustManager.DATA_NEWLY_UNLOCKED, newlyUnlocked ? 1 : 0);
                    m.getData().putCharSequenceArrayList(TrustManager.DATA_GRANTED_MESSAGES, (ArrayList)trustGrantedMessages);
                    m.sendToTarget();
                }

                @Override
                public void onEnabledTrustAgentsChanged(int userId) {
                    Message m = TrustManager.this.mHandler.obtainMessage(4, userId, 0, trustListener);
                    m.sendToTarget();
                }

                @Override
                public void onTrustManagedChanged(boolean managed, int userId) {
                    TrustManager.this.mHandler.obtainMessage(2, managed ? 1 : 0, userId, trustListener).sendToTarget();
                }

                @Override
                public void onTrustError(CharSequence message) {
                    Message m = TrustManager.this.mHandler.obtainMessage(3, trustListener);
                    m.getData().putCharSequence(TrustManager.DATA_MESSAGE, message);
                    m.sendToTarget();
                }

                @Override
                public void onIsActiveUnlockRunningChanged(boolean isRunning, int userId) {
                    TrustManager.this.mHandler.obtainMessage(5, isRunning ? 1 : 0, userId, trustListener).sendToTarget();
                }
            };
            this.mService.registerTrustListener(iTrustListener);
            this.mTrustListeners.put(trustListener, iTrustListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unregisterTrustListener(TrustListener trustListener) {
        ITrustListener iTrustListener = this.mTrustListeners.remove(trustListener);
        if (iTrustListener != null) {
            try {
                this.mService.unregisterTrustListener(iTrustListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.TRUST_LISTENER")
    public boolean isTrustUsuallyManaged(int userId) {
        try {
            return this.mService.isTrustUsuallyManaged(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_KEYGUARD_SECURE_STORAGE")
    public void unlockedByBiometricForUser(int userId, BiometricSourceType source) {
        try {
            this.mService.unlockedByBiometricForUser(userId, source);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_KEYGUARD_SECURE_STORAGE")
    public void clearAllBiometricRecognized(BiometricSourceType source, int unlockedUser) {
        try {
            this.mService.clearAllBiometricRecognized(source, unlockedUser);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static interface TrustListener {
        public void onTrustChanged(boolean var1, boolean var2, int var3, int var4, List<String> var5);

        public void onTrustManagedChanged(boolean var1, int var2);

        public void onTrustError(CharSequence var1);

        public void onEnabledTrustAgentsChanged(int var1);

        public void onIsActiveUnlockRunningChanged(boolean var1, int var2);
    }
}

