/*
 * Decompiled with CFR 0.152.
 */
package android.app.wearable;

import android.annotation.RequiresPermission;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.SharedMemory;

public interface IWearableSensingManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.wearable.IWearableSensingManager";

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void provideDataStream(ParcelFileDescriptor var1, RemoteCallback var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void provideData(PersistableBundle var1, SharedMemory var2, RemoteCallback var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWearableSensingManager {
        static final int TRANSACTION_provideDataStream = 1;
        static final int TRANSACTION_provideData = 2;

        public Stub() {
            this.attachInterface(this, IWearableSensingManager.DESCRIPTOR);
        }

        public static IWearableSensingManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWearableSensingManager.DESCRIPTOR);
            if (iin != null && iin instanceof IWearableSensingManager) {
                return (IWearableSensingManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "provideDataStream";
                }
                case 2: {
                    return "provideData";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWearableSensingManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.provideDataStream(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    SharedMemory _arg1 = data.readTypedObject(SharedMemory.CREATOR);
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.provideData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IWearableSensingManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWearableSensingManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void provideDataStream(ParcelFileDescriptor parcelFileDescriptor, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    _data.writeTypedObject(parcelFileDescriptor, 0);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void provideData(PersistableBundle data, SharedMemory sharedMemory, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWearableSensingManager.DESCRIPTOR);
                    _data.writeTypedObject(data, 0);
                    _data.writeTypedObject(sharedMemory, 0);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWearableSensingManager {
        @Override
        public void provideDataStream(ParcelFileDescriptor parcelFileDescriptor, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void provideData(PersistableBundle data, SharedMemory sharedMemory, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

