/*
 * Decompiled with CFR 0.152.
 */
package android.app.wearable;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.wearable.IWearableSensingManager;
import android.content.Context;
import android.os.Binder;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.SharedMemory;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@SystemApi
public class WearableSensingManager {
    public static final String STATUS_RESPONSE_BUNDLE_KEY = "android.app.wearable.WearableSensingStatusBundleKey";
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_SUCCESS = 1;
    public static final int STATUS_UNSUPPORTED = 2;
    public static final int STATUS_SERVICE_UNAVAILABLE = 3;
    public static final int STATUS_WEARABLE_UNAVAILABLE = 4;
    public static final int STATUS_ACCESS_DENIED = 5;
    private final Context mContext;
    private final IWearableSensingManager mService;

    public WearableSensingManager(Context context, IWearableSensingManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void provideDataStream(ParcelFileDescriptor parcelFileDescriptor, Executor executor, @StatusCode Consumer<Integer> statusConsumer) {
        try {
            RemoteCallback callback = new RemoteCallback(result -> {
                int status = result.getInt(STATUS_RESPONSE_BUNDLE_KEY);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> statusConsumer.accept(status));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            });
            this.mService.provideDataStream(parcelFileDescriptor, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void provideData(PersistableBundle data, SharedMemory sharedMemory, Executor executor, @StatusCode Consumer<Integer> statusConsumer) {
        try {
            RemoteCallback callback = new RemoteCallback(result -> {
                int status = result.getInt(STATUS_RESPONSE_BUNDLE_KEY);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> statusConsumer.accept(status));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            });
            this.mService.provideData(data, sharedMemory, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static @interface StatusCode {
    }
}

