/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothA2dpSink;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothAvrcpController;
import android.bluetooth.BluetoothCsipSetCoordinator;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothFrameworkInitializer;
import android.bluetooth.BluetoothHapClient;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHeadsetClient;
import android.bluetooth.BluetoothHearingAid;
import android.bluetooth.BluetoothHidDevice;
import android.bluetooth.BluetoothHidHost;
import android.bluetooth.BluetoothLeAudio;
import android.bluetooth.BluetoothLeBroadcast;
import android.bluetooth.BluetoothLeBroadcastAssistant;
import android.bluetooth.BluetoothLeCallControl;
import android.bluetooth.BluetoothMap;
import android.bluetooth.BluetoothMapClient;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothPbap;
import android.bluetooth.BluetoothPbapClient;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothQualityReport;
import android.bluetooth.BluetoothSap;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.BluetoothVolumeControl;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothActivityEnergyInfoListener;
import android.bluetooth.IBluetoothConnectionCallback;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.IBluetoothMetadataListener;
import android.bluetooth.IBluetoothOobDataCallback;
import android.bluetooth.IBluetoothPreferredAudioProfilesCallback;
import android.bluetooth.IBluetoothQualityReportReadyCallback;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.bluetooth.IncomingRfcommSocketInfo;
import android.bluetooth.OobData;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.DistanceMeasurementManager;
import android.bluetooth.le.PeriodicAdvertisingManager;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.Context;
import android.os.Binder;
import android.os.BluetoothServiceManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IpcDataCache;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.android.bluetooth.x.android.sysprop.BluetoothProperties;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import com.android.internal.annotations.GuardedBy;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BluetoothAdapter {
    private static final String TAG = "BluetoothAdapter";
    private static final String DESCRIPTOR = "android.bluetooth.BluetoothAdapter";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    public static final String DEFAULT_MAC_ADDRESS = "02:00:00:00:00:00";
    public static final int ERROR = Integer.MIN_VALUE;
    public static final String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";
    public static final String EXTRA_STATE = "android.bluetooth.adapter.extra.STATE";
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.adapter.extra.PREVIOUS_STATE";
    public static final int STATE_OFF = 10;
    public static final int STATE_TURNING_ON = 11;
    public static final int STATE_ON = 12;
    public static final int STATE_TURNING_OFF = 13;
    public static final int STATE_BLE_TURNING_ON = 14;
    @SystemApi
    public static final int STATE_BLE_ON = 15;
    public static final int STATE_BLE_TURNING_OFF = 16;
    public static final UUID LE_PSM_CHARACTERISTIC_UUID = UUID.fromString("2d410339-82b6-42aa-b34e-e2e01df8cc1a");
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_RFCOMM_LISTENER_ID = "android.bluetooth.adapter.extra.RFCOMM_LISTENER_ID";
    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public static final String ACTION_REQUEST_DISCOVERABLE = "android.bluetooth.adapter.action.REQUEST_DISCOVERABLE";
    public static final String EXTRA_DISCOVERABLE_DURATION = "android.bluetooth.adapter.extra.DISCOVERABLE_DURATION";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_REQUEST_ENABLE = "android.bluetooth.adapter.action.REQUEST_ENABLE";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_REQUEST_DISABLE = "android.bluetooth.adapter.action.REQUEST_DISABLE";
    @SystemApi
    public static final String ACTION_REQUEST_BLE_SCAN_ALWAYS_AVAILABLE = "android.bluetooth.adapter.action.REQUEST_BLE_SCAN_ALWAYS_AVAILABLE";
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public static final String ACTION_SCAN_MODE_CHANGED = "android.bluetooth.adapter.action.SCAN_MODE_CHANGED";
    public static final String EXTRA_SCAN_MODE = "android.bluetooth.adapter.extra.SCAN_MODE";
    public static final String EXTRA_PREVIOUS_SCAN_MODE = "android.bluetooth.adapter.extra.PREVIOUS_SCAN_MODE";
    public static final int SCAN_MODE_NONE = 20;
    public static final int SCAN_MODE_CONNECTABLE = 21;
    public static final int SCAN_MODE_CONNECTABLE_DISCOVERABLE = 23;
    @SystemApi
    public static final int BT_SNOOP_LOG_MODE_DISABLED = 0;
    @SystemApi
    public static final int BT_SNOOP_LOG_MODE_FILTERED = 1;
    @SystemApi
    public static final int BT_SNOOP_LOG_MODE_FULL = 2;
    public static final int IO_CAPABILITY_OUT = 0;
    public static final int IO_CAPABILITY_IO = 1;
    public static final int IO_CAPABILITY_IN = 2;
    public static final int IO_CAPABILITY_NONE = 3;
    public static final int IO_CAPABILITY_KBDISP = 4;
    public static final int IO_CAPABILITY_MAX = 5;
    public static final int IO_CAPABILITY_UNKNOWN = 255;
    @SystemApi
    public static final int ACTIVE_DEVICE_AUDIO = 0;
    @SystemApi
    public static final int ACTIVE_DEVICE_PHONE_CALL = 1;
    @SystemApi
    public static final int ACTIVE_DEVICE_ALL = 2;
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public static final String ACTION_DISCOVERY_STARTED = "android.bluetooth.adapter.action.DISCOVERY_STARTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public static final String ACTION_DISCOVERY_FINISHED = "android.bluetooth.adapter.action.DISCOVERY_FINISHED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_LOCAL_NAME_CHANGED = "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED";
    public static final String EXTRA_LOCAL_NAME = "android.bluetooth.adapter.extra.LOCAL_NAME";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED";
    public static final String EXTRA_CONNECTION_STATE = "android.bluetooth.adapter.extra.CONNECTION_STATE";
    public static final String EXTRA_PREVIOUS_CONNECTION_STATE = "android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE";
    @SystemApi
    public static final String ACTION_BLE_STATE_CHANGED = "android.bluetooth.adapter.action.BLE_STATE_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_BLUETOOTH_ADDRESS_CHANGED = "android.bluetooth.adapter.action.BLUETOOTH_ADDRESS_CHANGED";
    public static final String EXTRA_BLUETOOTH_ADDRESS = "android.bluetooth.adapter.extra.BLUETOOTH_ADDRESS";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_BLE_ACL_CONNECTED = "android.bluetooth.adapter.action.BLE_ACL_CONNECTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_BLE_ACL_DISCONNECTED = "android.bluetooth.adapter.action.BLE_ACL_DISCONNECTED";
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_DISCONNECTING = 3;
    @SystemApi
    public static final String AUDIO_MODE_OUTPUT_ONLY = "audio_mode_output_only";
    @SystemApi
    public static final String AUDIO_MODE_DUPLEX = "audio_mode_duplex";
    public static final String BLUETOOTH_MANAGER_SERVICE = "bluetooth_manager";
    private final IBinder mToken;
    public static final int SOCKET_CHANNEL_AUTO_STATIC_NO_SDP = -2;
    private static final int ADDRESS_LENGTH = 17;
    private static BluetoothAdapter sAdapter;
    private BluetoothLeScanner mBluetoothLeScanner;
    private BluetoothLeAdvertiser mBluetoothLeAdvertiser;
    private PeriodicAdvertisingManager mPeriodicAdvertisingManager;
    private DistanceMeasurementManager mDistanceMeasurementManager;
    private final IBluetoothManager mManagerService;
    private final AttributionSource mAttributionSource;
    @UnsupportedAppUsage
    @GuardedBy(value={"mServiceLock"})
    private IBluetooth mService;
    private final ReentrantReadWriteLock mServiceLock = new ReentrantReadWriteLock();
    @GuardedBy(value={"sServiceLock"})
    private static boolean sServiceRegistered;
    @GuardedBy(value={"sServiceLock"})
    private static IBluetooth sService;
    private static final Object sServiceLock;
    private final Object mLock = new Object();
    private final Map<LeScanCallback, ScanCallback> mLeScanClients;
    private final Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> mMetadataListeners = new HashMap<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>>();
    private final Map<BluetoothConnectionCallback, Executor> mBluetoothConnectionCallbackExecutorMap = new HashMap<BluetoothConnectionCallback, Executor>();
    private final Map<PreferredAudioProfilesChangedCallback, Executor> mAudioProfilesChangedCallbackExecutorMap = new HashMap<PreferredAudioProfilesChangedCallback, Executor>();
    private final Map<BluetoothQualityReportReadyCallback, Executor> mBluetoothQualityReportReadyCallbackExecutorMap = new HashMap<BluetoothQualityReportReadyCallback, Executor>();
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothMetadataListener mBluetoothMetadataListener = new IBluetoothMetadataListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMetadataChanged(BluetoothDevice device, int key, byte[] value) {
            Attributable.setAttributionSource(device, BluetoothAdapter.this.mAttributionSource);
            Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> map = BluetoothAdapter.this.mMetadataListeners;
            synchronized (map) {
                if (BluetoothAdapter.this.mMetadataListeners.containsKey(device)) {
                    List<Pair<OnMetadataChangedListener, Executor>> list = BluetoothAdapter.this.mMetadataListeners.get(device);
                    for (Pair<OnMetadataChangedListener, Executor> pair : list) {
                        OnMetadataChangedListener listener = (OnMetadataChangedListener)pair.first;
                        Executor executor = (Executor)pair.second;
                        executor.execute(() -> listener.onMetadataChanged(device, key, value));
                    }
                }
            }
        }
    };
    private static final IpcDataCache.QueryHandler<IBluetooth, Integer> sBluetoothGetStateQuery;
    private static final String GET_STATE_API = "BluetoothAdapter_getState";
    private static final IpcDataCache<IBluetooth, Integer> sBluetoothGetStateCache;
    private static final IpcDataCache.QueryHandler<IBluetooth, Boolean> sBluetoothFilteringQuery;
    private static final String FILTERING_API = "BluetoothAdapter_isOffloadedFilteringSupported";
    private static final IpcDataCache<IBluetooth, Boolean> sBluetoothFilteringCache;
    private static final IpcDataCache.QueryHandler<IBluetooth, Integer> sBluetoothGetAdapterConnectionStateQuery;
    private static final String GET_CONNECTION_API = "BluetoothAdapter_getConnectionState";
    private static final IpcDataCache<IBluetooth, Integer> sBluetoothGetAdapterConnectionStateCache;
    private static final IpcDataCache.QueryHandler<Pair<IBluetooth, Pair<AttributionSource, Integer>>, Integer> sBluetoothProfileQuery;
    private static final String PROFILE_API = "BluetoothAdapter_getProfileConnectionState";
    private static final IpcDataCache<Pair<IBluetooth, Pair<AttributionSource, Integer>>, Integer> sGetProfileConnectionStateCache;
    private static final IBluetoothManagerCallback sManagerCallback;
    private final IBluetoothManagerCallback mManagerCallback = new IBluetoothManagerCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothServiceUp(IBluetooth bluetoothService) {
            Objects.requireNonNull(bluetoothService, "bluetoothService cannot be null");
            BluetoothAdapter.this.mServiceLock.writeLock().lock();
            try {
                BluetoothAdapter.this.mService = bluetoothService;
            }
            finally {
                BluetoothAdapter.this.mServiceLock.readLock().lock();
                BluetoothAdapter.this.mServiceLock.writeLock().unlock();
            }
            try {
                SynchronousResultReceiver recv;
                Map<Object, Object> map = BluetoothAdapter.this.mMetadataListeners;
                synchronized (map) {
                    BluetoothAdapter.this.mMetadataListeners.forEach((device, pair) -> {
                        try {
                            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                            BluetoothAdapter.this.mService.registerMetadataListener(BluetoothAdapter.this.mBluetoothMetadataListener, (BluetoothDevice)device, BluetoothAdapter.this.mAttributionSource, recv);
                            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                        }
                        catch (RemoteException | TimeoutException e) {
                            Log.e(BluetoothAdapter.TAG, "Failed to register metadata listener", e);
                            Log.e(BluetoothAdapter.TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                        }
                    });
                }
                map = BluetoothAdapter.this.mAudioProfilesChangedCallbackExecutorMap;
                synchronized (map) {
                    if (!BluetoothAdapter.this.mAudioProfilesChangedCallbackExecutorMap.isEmpty()) {
                        try {
                            recv = SynchronousResultReceiver.get();
                            BluetoothAdapter.this.mService.registerPreferredAudioProfilesChangedCallback(BluetoothAdapter.this.mPreferredAudioProfilesChangedCallback, BluetoothAdapter.this.mAttributionSource, recv);
                            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                        }
                        catch (RemoteException | TimeoutException e) {
                            Log.e(BluetoothAdapter.TAG, "onBluetoothServiceUp: Failed to register bluetoothconnection callback", e);
                        }
                    }
                }
                map = BluetoothAdapter.this.mBluetoothQualityReportReadyCallbackExecutorMap;
                synchronized (map) {
                    if (!BluetoothAdapter.this.mBluetoothQualityReportReadyCallbackExecutorMap.isEmpty()) {
                        try {
                            recv = SynchronousResultReceiver.get();
                            BluetoothAdapter.this.mService.registerBluetoothQualityReportReadyCallback(BluetoothAdapter.this.mBluetoothQualityReportReadyCallback, BluetoothAdapter.this.mAttributionSource, recv);
                            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                        }
                        catch (RemoteException | TimeoutException e) {
                            Log.e(BluetoothAdapter.TAG, "onBluetoothServiceUp: Failed to register bluetoothquality report callback", e);
                        }
                    }
                }
                map = BluetoothAdapter.this.mBluetoothConnectionCallbackExecutorMap;
                synchronized (map) {
                    if (!BluetoothAdapter.this.mBluetoothConnectionCallbackExecutorMap.isEmpty()) {
                        try {
                            recv = SynchronousResultReceiver.get();
                            BluetoothAdapter.this.mService.registerBluetoothConnectionCallback(BluetoothAdapter.this.mConnectionCallback, BluetoothAdapter.this.mAttributionSource, recv);
                            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                        }
                        catch (RemoteException | TimeoutException e) {
                            Log.e(BluetoothAdapter.TAG, "onBluetoothServiceUp: Failed to register bluetooth connection callback", e);
                        }
                    }
                }
            }
            finally {
                BluetoothAdapter.this.mServiceLock.readLock().unlock();
            }
        }

        @Override
        public void onBluetoothServiceDown() {
            BluetoothAdapter.this.mServiceLock.writeLock().lock();
            try {
                BluetoothAdapter.this.mService = null;
                if (BluetoothAdapter.this.mLeScanClients != null) {
                    BluetoothAdapter.this.mLeScanClients.clear();
                }
                if (BluetoothAdapter.this.mBluetoothLeAdvertiser != null) {
                    BluetoothAdapter.this.mBluetoothLeAdvertiser.cleanup();
                }
                if (BluetoothAdapter.this.mBluetoothLeScanner != null) {
                    BluetoothAdapter.this.mBluetoothLeScanner.cleanup();
                }
            }
            finally {
                BluetoothAdapter.this.mServiceLock.writeLock().unlock();
            }
        }

        @Override
        public void onBrEdrDown() {
        }
    };
    @GuardedBy(value={"sServiceLock"})
    private static final WeakHashMap<IBluetoothManagerCallback, Void> sProxyServiceStateCallbacks;
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothConnectionCallback mConnectionCallback = new IBluetoothConnectionCallback.Stub(){

        @Override
        public void onDeviceConnected(BluetoothDevice device) {
            Attributable.setAttributionSource(device, BluetoothAdapter.this.mAttributionSource);
            for (Map.Entry<BluetoothConnectionCallback, Executor> callbackExecutorEntry : BluetoothAdapter.this.mBluetoothConnectionCallbackExecutorMap.entrySet()) {
                BluetoothConnectionCallback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onDeviceConnected(device));
            }
        }

        @Override
        public void onDeviceDisconnected(BluetoothDevice device, int hciReason) {
            Attributable.setAttributionSource(device, BluetoothAdapter.this.mAttributionSource);
            for (Map.Entry<BluetoothConnectionCallback, Executor> callbackExecutorEntry : BluetoothAdapter.this.mBluetoothConnectionCallbackExecutorMap.entrySet()) {
                BluetoothConnectionCallback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onDeviceDisconnected(device, hciReason));
            }
        }
    };
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothPreferredAudioProfilesCallback mPreferredAudioProfilesChangedCallback = new IBluetoothPreferredAudioProfilesCallback.Stub(){

        @Override
        public void onPreferredAudioProfilesChanged(BluetoothDevice device, Bundle preferredAudioProfiles, int status) {
            for (Map.Entry<PreferredAudioProfilesChangedCallback, Executor> callbackExecutorEntry : BluetoothAdapter.this.mAudioProfilesChangedCallbackExecutorMap.entrySet()) {
                PreferredAudioProfilesChangedCallback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onPreferredAudioProfilesChanged(device, preferredAudioProfiles, status));
            }
        }
    };
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothQualityReportReadyCallback mBluetoothQualityReportReadyCallback = new IBluetoothQualityReportReadyCallback.Stub(){

        @Override
        public void onBluetoothQualityReportReady(BluetoothDevice device, BluetoothQualityReport bluetoothQualityReport, int status) {
            for (Map.Entry<BluetoothQualityReportReadyCallback, Executor> callbackExecutorEntry : BluetoothAdapter.this.mBluetoothQualityReportReadyCallbackExecutorMap.entrySet()) {
                BluetoothQualityReportReadyCallback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onBluetoothQualityReportReady(device, bluetoothQualityReport, status));
            }
        }
    };

    @SystemApi
    @RequiresNoPermission
    public static String nameForState(int state) {
        switch (state) {
            case 10: {
                return "OFF";
            }
            case 11: {
                return "TURNING_ON";
            }
            case 12: {
                return "ON";
            }
            case 13: {
                return "TURNING_OFF";
            }
            case 14: {
                return "BLE_TURNING_ON";
            }
            case 15: {
                return "BLE_ON";
            }
            case 16: {
                return "BLE_TURNING_OFF";
            }
        }
        return "?!?!? (" + state + ")";
    }

    @Deprecated
    @RequiresNoPermission
    public static synchronized BluetoothAdapter getDefaultAdapter() {
        if (sAdapter == null) {
            sAdapter = BluetoothAdapter.createAdapter(AttributionSource.myAttributionSource());
        }
        return sAdapter;
    }

    public static BluetoothAdapter createAdapter(AttributionSource attributionSource) {
        BluetoothServiceManager manager = BluetoothFrameworkInitializer.getBluetoothServiceManager();
        if (manager == null) {
            Log.e(TAG, "BluetoothServiceManager is null");
            return null;
        }
        IBluetoothManager service = IBluetoothManager.Stub.asInterface(manager.getBluetoothManagerServiceRegisterer().get());
        if (service != null) {
            return new BluetoothAdapter(service, attributionSource);
        }
        Log.e(TAG, "Bluetooth service is null");
        return null;
    }

    BluetoothAdapter(IBluetoothManager managerService, AttributionSource attributionSource) {
        this.mManagerService = Objects.requireNonNull(managerService);
        this.mAttributionSource = Objects.requireNonNull(attributionSource);
        this.mServiceLock.writeLock().lock();
        try {
            this.mService = this.getBluetoothService(this.mManagerCallback);
        }
        finally {
            this.mServiceLock.writeLock().unlock();
        }
        this.mLeScanClients = new HashMap<LeScanCallback, ScanCallback>();
        this.mToken = new Binder(DESCRIPTOR);
    }

    @RequiresNoPermission
    public BluetoothDevice getRemoteDevice(String address) {
        BluetoothDevice res = new BluetoothDevice(address);
        res.setAttributionSource(this.mAttributionSource);
        return res;
    }

    @RequiresNoPermission
    public BluetoothDevice getRemoteLeDevice(String address, int addressType) {
        BluetoothDevice res = new BluetoothDevice(address, addressType);
        res.setAttributionSource(this.mAttributionSource);
        return res;
    }

    @RequiresNoPermission
    public BluetoothDevice getRemoteDevice(byte[] address) {
        if (address == null || address.length != 6) {
            throw new IllegalArgumentException("Bluetooth address must have 6 bytes");
        }
        BluetoothDevice res = new BluetoothDevice(String.format(Locale.US, "%02X:%02X:%02X:%02X:%02X:%02X", address[0], address[1], address[2], address[3], address[4], address[5]));
        res.setAttributionSource(this.mAttributionSource);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNoPermission
    public BluetoothLeAdvertiser getBluetoothLeAdvertiser() {
        if (!this.getLeAccess()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBluetoothLeAdvertiser == null) {
                this.mBluetoothLeAdvertiser = new BluetoothLeAdvertiser(this);
            }
            return this.mBluetoothLeAdvertiser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNoPermission
    public PeriodicAdvertisingManager getPeriodicAdvertisingManager() {
        if (!this.getLeAccess()) {
            return null;
        }
        if (!this.isLePeriodicAdvertisingSupported()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPeriodicAdvertisingManager == null) {
                this.mPeriodicAdvertisingManager = new PeriodicAdvertisingManager(this);
            }
            return this.mPeriodicAdvertisingManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNoPermission
    public BluetoothLeScanner getBluetoothLeScanner() {
        if (!this.getLeAccess()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBluetoothLeScanner == null) {
                this.mBluetoothLeScanner = new BluetoothLeScanner(this);
            }
            return this.mBluetoothLeScanner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public DistanceMeasurementManager getDistanceMeasurementManager() {
        if (!this.getLeAccess()) {
            return null;
        }
        if (this.isDistanceMeasurementSupported() != 10) {
            throw new UnsupportedOperationException("Distance measurement is unsupported");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDistanceMeasurementManager == null) {
                this.mDistanceMeasurementManager = new DistanceMeasurementManager(this);
            }
            return this.mDistanceMeasurementManager;
        }
    }

    @RequiresNoPermission
    public boolean isEnabled() {
        return this.getState() == 12;
    }

    @SystemApi
    @RequiresNoPermission
    public boolean isLeEnabled() {
        int state = this.getLeState();
        Log.d(TAG, "isLeEnabled(): " + BluetoothAdapter.nameForState(state));
        return state == 12 || state == 15 || state == 11 || state == 13;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean disableBLE() {
        if (!this.isBleScanAlwaysAvailable()) {
            return false;
        }
        try {
            return this.mManagerService.disableBle(this.mAttributionSource, this.mToken);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean enableBLE() {
        if (!this.isBleScanAlwaysAvailable()) {
            return false;
        }
        try {
            return this.mManagerService.enableBle(this.mAttributionSource, this.mToken);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    private static void invalidateCache(String api) {
        IpcDataCache.invalidateCache("bluetooth", api);
    }

    @RequiresNoPermission
    public void disableBluetoothGetStateCache() {
        sBluetoothGetStateCache.disableForCurrentProcess();
    }

    public static void invalidateBluetoothGetStateCache() {
        BluetoothAdapter.invalidateCache(GET_STATE_API);
    }

    private int getStateInternal() {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = sBluetoothGetStateCache.query(this.mService);
                return n;
            }
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof TimeoutException) && !(e.getCause() instanceof RemoteException)) {
                throw e;
            }
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 10;
    }

    @RequiresNoPermission
    public int getState() {
        int state = this.getStateInternal();
        if (state == 15 || state == 14 || state == 16) {
            state = 10;
        }
        return state;
    }

    @RequiresNoPermission
    @UnsupportedAppUsage(publicAlternatives="Use {@link #getState()} instead to determine whether you can use BLE & BT classic.")
    public int getLeState() {
        int state = this.getStateInternal();
        return state;
    }

    boolean getLeAccess() {
        if (this.getLeState() == 12) {
            return true;
        }
        return this.getLeState() == 15;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean enable() {
        if (this.isEnabled()) {
            Log.d(TAG, "enable(): BT already enabled!");
            return true;
        }
        try {
            return this.mManagerService.enable(this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean disable() {
        return this.disable(true);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean disable(boolean persist) {
        try {
            return this.mManagerService.disable(this.mAttributionSource, persist);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public String getAddress() {
        try {
            return this.mManagerService.getAddress(this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getName() {
        try {
            return this.mManagerService.getName(this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public int getNameLengthForAdvertise() {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getNameLengthForAdvertise(this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(-1);
                return n;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return -1;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean clearBluetooth() {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.factoryReset(this.mAttributionSource, recv);
                if (recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false).booleanValue() && this.mManagerService != null && this.mManagerService.onFactoryReset(this.mAttributionSource)) {
                    boolean bl = true;
                    return bl;
                }
            }
            Log.e(TAG, "factoryReset(): Setting persist.bluetooth.factoryreset to retry later");
            BluetoothProperties.factory_reset(true);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean factoryReset() {
        return this.clearBluetooth();
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public ParcelUuid[] getUuids() {
        List<ParcelUuid> parcels = this.getUuidsList();
        return parcels.toArray(new ParcelUuid[parcels.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<ParcelUuid> getUuidsList() {
        ArrayList<ParcelUuid> defaultValue = new ArrayList<ParcelUuid>();
        if (this.getState() != 12) {
            return defaultValue;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getUuids(this.mAttributionSource, recv);
                List list = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
                return list;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setName(String name) {
        if (this.getState() != 12) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.setName(name, this.mAttributionSource, recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getIoCapability() {
        if (this.getState() != 12) {
            return 255;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getIoCapability(this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(255);
                return n;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 255;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setIoCapability(int capability) {
        if (this.getState() != 12) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.setIoCapability(capability, this.mAttributionSource, recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public int getScanMode() {
        if (this.getState() != 12) {
            return 20;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getScanMode(this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(20);
                return n;
            }
        }
        catch (TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 20;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setScanMode(int mode) {
        if (this.getState() != 12) {
            return 1;
        }
        if (mode != 20 && mode != 21 && mode != 23) {
            throw new IllegalArgumentException("Invalid scan mode param value");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.setScanMode(mode, this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                return n;
            }
        }
        catch (TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public Duration getDiscoverableTimeout() {
        if (this.getState() != 12) {
            return null;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getDiscoverableTimeout(this.mAttributionSource, recv);
                long timeout = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(-1L);
                Duration duration = timeout == -1L ? null : Duration.ofSeconds(timeout);
                return duration;
            }
        }
        catch (TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setDiscoverableTimeout(Duration timeout) {
        if (this.getState() != 12) {
            return 1;
        }
        if (timeout.toSeconds() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout in seconds must be less or equal to 2147483647");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.setDiscoverableTimeout(timeout.toSeconds(), this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                return n;
            }
        }
        catch (TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public long getDiscoveryEndMillis() {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getDiscoveryEndMillis(this.mAttributionSource, recv);
                long l = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(-1L);
                return l;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return -1L;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean startDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.startDiscovery(this.mAttributionSource, recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean cancelDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.cancelDiscovery(this.mAttributionSource, recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean isDiscovering() {
        if (this.getState() != 12) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.isDiscovering(this.mAttributionSource, recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public boolean removeActiveDevice(int profiles) {
        if (profiles != 0 && profiles != 1 && profiles != 2) {
            Log.e(TAG, "Invalid profiles param value in removeActiveDevice");
            throw new IllegalArgumentException("Profiles must be one of BluetoothAdapter.ACTIVE_DEVICE_AUDIO, BluetoothAdapter.ACTIVE_DEVICE_PHONE_CALL, or BluetoothAdapter.ACTIVE_DEVICE_ALL");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                Log.d(TAG, "removeActiveDevice, profiles: " + profiles);
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.removeActiveDevice(profiles, this.mAttributionSource, recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public boolean setActiveDevice(BluetoothDevice device, int profiles) {
        if (device == null) {
            Log.e(TAG, "setActiveDevice: Null device passed as parameter");
            throw new IllegalArgumentException("device cannot be null");
        }
        if (profiles != 0 && profiles != 1 && profiles != 2) {
            Log.e(TAG, "Invalid profiles param value in setActiveDevice");
            throw new IllegalArgumentException("Profiles must be one of BluetoothAdapter.ACTIVE_DEVICE_AUDIO, BluetoothAdapter.ACTIVE_DEVICE_PHONE_CALL, or BluetoothAdapter.ACTIVE_DEVICE_ALL");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                Log.d(TAG, "setActiveDevice, device: " + device + ", profiles: " + profiles);
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.setActiveDevice(device, profiles, this.mAttributionSource, recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothDevice> getActiveDevices(int profile) {
        if (profile != 1 && profile != 2 && profile != 21 && profile != 22) {
            Log.e(TAG, "Invalid profile param value in getActiveDevices");
            throw new IllegalArgumentException("Profiles must be one of BluetoothProfile.A2DP, BluetoothProfile.HEARING_AID, orBluetoothProfile.HEARING_AIDBluetoothProfile.LE_AUDIO");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                Log.d(TAG, "getActiveDevices(profile= " + BluetoothProfile.getProfileName(profile) + ")");
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getActiveDevices(profile, this.mAttributionSource, recv);
                List list = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(new ArrayList());
                return list;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return new ArrayList<BluetoothDevice>();
    }

    @RequiresNoPermission
    public boolean isMultipleAdvertisementSupported() {
        if (this.getState() != 12) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.isMultiAdvertisementSupported(recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @SystemApi
    @RequiresNoPermission
    public boolean isBleScanAlwaysAvailable() {
        try {
            return this.mManagerService.isBleScanAlwaysAvailable();
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception when calling isBleScanAlwaysAvailable", e);
            return false;
        }
    }

    @RequiresNoPermission
    public void disableIsOffloadedFilteringSupportedCache() {
        sBluetoothFilteringCache.disableForCurrentProcess();
    }

    public static void invalidateIsOffloadedFilteringSupportedCache() {
        BluetoothAdapter.invalidateCache(FILTERING_API);
    }

    @RequiresNoPermission
    public boolean isOffloadedFilteringSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = sBluetoothFilteringCache.query(this.mService);
                return bl;
            }
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof TimeoutException) && !(e.getCause() instanceof RemoteException)) {
                throw e;
            }
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isOffloadedScanBatchingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.isOffloadedScanBatchingSupported(recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isLe2MPhySupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.isLe2MPhySupported(recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isLeCodedPhySupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.isLeCodedPhySupported(recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isLeExtendedAdvertisingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.isLeExtendedAdvertisingSupported(recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isLePeriodicAdvertisingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.isLePeriodicAdvertisingSupported(recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public int isLeAudioSupported() {
        if (!this.getLeAccess()) {
            return 1;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.isLeAudioSupported(recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                return n;
            }
            try {
                throw new IllegalStateException("LE state is on, but there is no bluetooth service.");
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    @RequiresNoPermission
    public int isLeAudioBroadcastSourceSupported() {
        if (!this.getLeAccess()) {
            return 1;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.isLeAudioBroadcastSourceSupported(recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                return n;
            }
            try {
                throw new IllegalStateException("LE state is on, but there is no bluetooth service.");
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    @RequiresNoPermission
    public int isLeAudioBroadcastAssistantSupported() {
        if (!this.getLeAccess()) {
            return 1;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.isLeAudioBroadcastAssistantSupported(recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                return n;
            }
            try {
                throw new IllegalStateException("LE state is on, but there is no bluetooth service.");
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int isDistanceMeasurementSupported() {
        if (!this.getLeAccess()) {
            return 1;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.isDistanceMeasurementSupported(this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                return n;
            }
            try {
                throw new IllegalStateException("LE state is on, but there is no bluetooth service.");
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    @RequiresNoPermission
    public int getLeMaximumAdvertisingDataLength() {
        if (!this.getLeAccess()) {
            return 0;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getLeMaximumAdvertisingDataLength(recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
                return n;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    @RequiresNoPermission
    private boolean isHearingAidProfileSupported() {
        try {
            return this.mManagerService.isHearingAidProfileSupported();
        }
        catch (RemoteException e) {
            Log.e(TAG, "remote exception when calling isHearingAidProfileSupported", e);
            return false;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getMaxConnectedAudioDevices() {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getMaxConnectedAudioDevices(this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(1);
                return n;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return -1;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isHardwareTrackingFiltersAvailable() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
            if (iGatt == null) {
                return false;
            }
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            iGatt.numHwTrackFiltersAvailable(this.mAttributionSource, recv);
            return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0) != 0;
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void requestControllerActivityEnergyInfo(Executor executor, OnBluetoothActivityEnergyInfoCallback callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        OnBluetoothActivityEnergyInfoProxy proxy = new OnBluetoothActivityEnergyInfoProxy(executor, callback);
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                this.mService.requestActivityInfo(proxy, this.mAttributionSource);
            } else {
                proxy.onError(9);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "getControllerActivityEnergyInfoCallback: " + e);
            proxy.onError(Integer.MAX_VALUE);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothDevice> getMostRecentlyConnectedDevices() {
        if (this.getState() != 12) {
            return new ArrayList<BluetoothDevice>();
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getMostRecentlyConnectedDevices(this.mAttributionSource, recv);
                List<BluetoothDevice> list = Attributable.setAttributionSource(recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(new ArrayList()), this.mAttributionSource);
                return list;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return new ArrayList<BluetoothDevice>();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public Set<BluetoothDevice> getBondedDevices() {
        if (this.getState() != 12) {
            return this.toDeviceSet(Arrays.asList(new BluetoothDevice[0]));
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getBondedDevices(this.mAttributionSource, recv);
                Set<BluetoothDevice> set = this.toDeviceSet(Attributable.setAttributionSource(recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(new ArrayList()), this.mAttributionSource));
                return set;
            }
            Set<BluetoothDevice> recv = this.toDeviceSet(Arrays.asList(new BluetoothDevice[0]));
            return recv;
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<Integer> getSupportedProfiles() {
        ArrayList<Integer> supportedProfiles = new ArrayList<Integer>();
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getSupportedProfiles(this.mAttributionSource, recv);
                long supportedProfilesBitMask = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0L);
                for (int i = 0; i <= 30; ++i) {
                    if ((supportedProfilesBitMask & (long)(1 << i)) == 0L) continue;
                    supportedProfiles.add(i);
                }
            } else if (this.isHearingAidProfileSupported()) {
                supportedProfiles.add(21);
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return supportedProfiles;
    }

    @RequiresNoPermission
    public void disableGetAdapterConnectionStateCache() {
        sBluetoothGetAdapterConnectionStateCache.disableForCurrentProcess();
    }

    public static void invalidateGetAdapterConnectionStateCache() {
        BluetoothAdapter.invalidateCache(GET_CONNECTION_API);
    }

    @SystemApi
    @RequiresNoPermission
    public int getConnectionState() {
        if (this.getState() != 12) {
            return 0;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = sBluetoothGetAdapterConnectionStateCache.query(this.mService);
                return n;
            }
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof TimeoutException) && !(e.getCause() instanceof RemoteException)) {
                throw e;
            }
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    @RequiresNoPermission
    public void disableGetProfileConnectionStateCache() {
        sGetProfileConnectionStateCache.disableForCurrentProcess();
    }

    public static void invalidateGetProfileConnectionStateCache() {
        BluetoothAdapter.invalidateCache(PROFILE_API);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getProfileConnectionState(int profile) {
        if (this.getState() != 12) {
            return 0;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = sGetProfileConnectionStateCache.query(new Pair<IBluetooth, Pair<AttributionSource, Integer>>(this.mService, new Pair<AttributionSource, Integer>(this.mAttributionSource, profile)));
                return n;
            }
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof TimeoutException) && !(e.getCause() instanceof RemoteException)) {
                throw e;
            }
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingRfcommOn(int channel) throws IOException {
        return this.listenUsingRfcommOn(channel, false, false);
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingRfcommOn(int channel, boolean mitm, boolean min16DigitPin) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, true, true, channel, mitm, min16DigitPin);
        int errno = socket.mSocket.bindListen();
        if (channel == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int startRfcommServer(String name, UUID uuid, PendingIntent pendingIntent) {
        if (!pendingIntent.isImmutable()) {
            throw new IllegalArgumentException("The provided PendingIntent is not immutable");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.startRfcommListener(name, new ParcelUuid(uuid), pendingIntent, this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(9);
                return n;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "Failed to transact RFCOMM listener start request", e);
            int n = 15;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int stopRfcommServer(UUID uuid) {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.stopRfcommListener(new ParcelUuid(uuid), this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(9);
                return n;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "Failed to transact RFCOMM listener stop request", e);
            int n = 15;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public BluetoothSocket retrieveConnectedRfcommSocket(UUID uuid) {
        IncomingRfcommSocketInfo socketInfo = null;
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.retrievePendingSocketForServiceRecord(new ParcelUuid(uuid), this.mAttributionSource, recv);
                socketInfo = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            BluetoothSocket bluetoothSocket = null;
            return bluetoothSocket;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        if (socketInfo == null) {
            return null;
        }
        switch (socketInfo.status) {
            case 0: {
                try {
                    return BluetoothSocket.createSocketFromOpenFd(socketInfo.pfd, socketInfo.bluetoothDevice, new ParcelUuid(uuid));
                }
                catch (IOException e) {
                    return null;
                }
            }
            case 2002: {
                throw new IllegalStateException(String.format("RFCOMM listener for UUID %s was not registered by this app", uuid));
            }
            case 2005: {
                return null;
            }
        }
        Log.e(TAG, String.format("Unexpected result: (%d), from the adapter service while retrieving an rfcomm socket", socketInfo.status));
        return null;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, false);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingEncryptedRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return this.createNewRfcommSocketAndRecord(name, uuid, false, true);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private BluetoothServerSocket createNewRfcommSocketAndRecord(String name, UUID uuid, boolean auth, boolean encrypt) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, auth, encrypt, new ParcelUuid(uuid));
        socket.setServiceName(name);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingInsecureRfcommOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, false, false, port);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingL2capOn(int port, boolean mitm, boolean min16DigitPin) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(3, true, true, port, mitm, min16DigitPin);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            int assignedChannel = socket.mSocket.getPort();
            Log.d(TAG, "listenUsingL2capOn: set assigned channel to " + assignedChannel);
            socket.setChannel(assignedChannel);
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingL2capOn(int port) throws IOException {
        return this.listenUsingL2capOn(port, false, false);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingInsecureL2capOn(int port) throws IOException {
        Log.d(TAG, "listenUsingInsecureL2capOn: port=" + port);
        BluetoothServerSocket socket = new BluetoothServerSocket(3, false, false, port, false, false);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            int assignedChannel = socket.mSocket.getPort();
            Log.d(TAG, "listenUsingInsecureL2capOn: set assigned channel to " + assignedChannel);
            socket.setChannel(assignedChannel);
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public Pair<byte[], byte[]> readOutOfBandData() {
        return null;
    }

    @SuppressLint(value={"AndroidFrameworkRequiresPermission", "AndroidFrameworkBluetoothPermission"})
    public boolean getProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        if (context == null || listener == null) {
            return false;
        }
        if (profile == 1) {
            BluetoothHeadset headset = new BluetoothHeadset(context, listener, this);
            return true;
        }
        if (profile == 2) {
            BluetoothA2dp a2dp = new BluetoothA2dp(context, listener, this);
            return true;
        }
        if (profile == 11) {
            BluetoothA2dpSink a2dpSink = new BluetoothA2dpSink(context, listener, this);
            return true;
        }
        if (profile == 12) {
            BluetoothAvrcpController avrcp = new BluetoothAvrcpController(context, listener, this);
            return true;
        }
        if (profile == 4) {
            BluetoothHidHost iDev = new BluetoothHidHost(context, listener, this);
            return true;
        }
        if (profile == 5) {
            BluetoothPan pan = new BluetoothPan(context, listener, this);
            return true;
        }
        if (profile == 6) {
            BluetoothPbap pbap = new BluetoothPbap(context, listener, this);
            return true;
        }
        if (profile == 3) {
            Log.e(TAG, "getProfileProxy(): BluetoothHealth is deprecated");
            return false;
        }
        if (profile == 9) {
            BluetoothMap map = new BluetoothMap(context, listener, this);
            return true;
        }
        if (profile == 16) {
            BluetoothHeadsetClient headsetClient = new BluetoothHeadsetClient(context, listener, this);
            return true;
        }
        if (profile == 10) {
            BluetoothSap sap = new BluetoothSap(context, listener, this);
            return true;
        }
        if (profile == 17) {
            BluetoothPbapClient pbapClient = new BluetoothPbapClient(context, listener, this);
            return true;
        }
        if (profile == 18) {
            BluetoothMapClient mapClient = new BluetoothMapClient(context, listener, this);
            return true;
        }
        if (profile == 19) {
            BluetoothHidDevice hidDevice = new BluetoothHidDevice(context, listener, this);
            return true;
        }
        if (profile == 28) {
            BluetoothHapClient HapClient = new BluetoothHapClient(context, listener);
            return true;
        }
        if (profile == 21) {
            if (this.isHearingAidProfileSupported()) {
                BluetoothHearingAid hearingAid = new BluetoothHearingAid(context, listener, this);
                return true;
            }
            return false;
        }
        if (profile == 22) {
            BluetoothLeAudio leAudio = new BluetoothLeAudio(context, listener, this);
            return true;
        }
        if (profile == 26) {
            BluetoothLeBroadcast leAudio = new BluetoothLeBroadcast(context, listener);
            return true;
        }
        if (profile == 23) {
            BluetoothVolumeControl vcs = new BluetoothVolumeControl(context, listener, this);
            return true;
        }
        if (profile == 25) {
            BluetoothCsipSetCoordinator csipSetCoordinator = new BluetoothCsipSetCoordinator(context, listener, this);
            return true;
        }
        if (profile == 27) {
            BluetoothLeCallControl tbs = new BluetoothLeCallControl(context, listener);
            return true;
        }
        if (profile == 29) {
            BluetoothLeBroadcastAssistant leAudioBroadcastAssistant = new BluetoothLeBroadcastAssistant(context, listener);
            return true;
        }
        return false;
    }

    @SuppressLint(value={"AndroidFrameworkRequiresPermission", "AndroidFrameworkBluetoothPermission"})
    public void closeProfileProxy(int unusedProfile, BluetoothProfile proxy) {
        if (proxy == null) {
            return;
        }
        proxy.close();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean enableNoAutoConnect() {
        if (this.isEnabled()) {
            Log.d(TAG, "enableNoAutoConnect(): BT already enabled!");
            return true;
        }
        try {
            return this.mManagerService.enableNoAutoConnect(this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void generateLocalOobData(int transport, Executor executor, OobDataCallback callback) {
        if (transport != 1 && transport != 2) {
            throw new IllegalArgumentException("Invalid transport '" + transport + "'!");
        }
        Objects.requireNonNull(callback);
        if (!this.isEnabled()) {
            Log.w(TAG, "generateLocalOobData(): Adapter isn't enabled!");
            callback.onError(1);
        } else {
            this.mServiceLock.readLock().lock();
            try {
                if (this.mService != null) {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    this.mService.generateLocalOobData(transport, new WrappedOobDataCallback(callback, executor), this.mAttributionSource, recv);
                    recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                }
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            finally {
                this.mServiceLock.readLock().unlock();
            }
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public boolean changeApplicationBluetoothState(boolean on, BluetoothStateChangeCallback callback) {
        return false;
    }

    private Set<BluetoothDevice> toDeviceSet(List<BluetoothDevice> devices) {
        HashSet<BluetoothDevice> deviceSet = new HashSet<BluetoothDevice>(devices);
        return Collections.unmodifiableSet(deviceSet);
    }

    @SuppressLint(value={"GenericException"})
    protected void finalize() throws Throwable {
        try {
            this.removeServiceStateCallback(this.mManagerCallback);
        }
        finally {
            super.finalize();
        }
    }

    public static boolean checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAddressRandomStatic(String address) {
        Objects.requireNonNull(address);
        return BluetoothAdapter.checkBluetoothAddress(address) && (Integer.parseInt(address.split(":")[0], 16) & 0xC0) == 192;
    }

    @UnsupportedAppUsage
    @RequiresNoPermission
    public IBluetoothManager getBluetoothManager() {
        return this.mManagerService;
    }

    @RequiresNoPermission
    public AttributionSource getAttributionSource() {
        return this.mAttributionSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IBluetooth getBluetoothService() {
        Object object = sServiceLock;
        synchronized (object) {
            return sService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IBluetooth getBluetoothService(IBluetoothManagerCallback cb) {
        Objects.requireNonNull(cb);
        Object object = sServiceLock;
        synchronized (object) {
            sProxyServiceStateCallbacks.put(cb, null);
            this.registerOrUnregisterAdapterLocked();
            return sService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeServiceStateCallback(IBluetoothManagerCallback cb) {
        Objects.requireNonNull(cb);
        Object object = sServiceLock;
        synchronized (object) {
            sProxyServiceStateCallbacks.remove(cb);
            this.registerOrUnregisterAdapterLocked();
        }
    }

    @GuardedBy(value={"sServiceLock"})
    private void registerOrUnregisterAdapterLocked() {
        boolean wantRegistered;
        boolean isRegistered = sServiceRegistered;
        boolean bl = wantRegistered = !sProxyServiceStateCallbacks.isEmpty();
        if (isRegistered != wantRegistered) {
            if (wantRegistered) {
                try {
                    sService = this.mManagerService.registerAdapter(sManagerCallback);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            try {
                this.mManagerService.unregisterAdapter(sManagerCallback);
                sService = null;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            sServiceRegistered = wantRegistered;
        }
    }

    @RequiresNoPermission
    public boolean registerServiceLifecycleCallback(ServiceLifecycleCallback callback) {
        return this.getBluetoothService(callback.mRemote) != null;
    }

    @RequiresNoPermission
    public void unregisterServiceLifecycleCallback(ServiceLifecycleCallback callback) {
        this.removeServiceStateCallback(callback.mRemote);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean startLeScan(LeScanCallback callback) {
        return this.startLeScan(null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean startLeScan(final UUID[] serviceUuids, final LeScanCallback callback) {
        Log.d(TAG, "startLeScan(): " + Arrays.toString(serviceUuids));
        if (callback == null) {
            Log.e(TAG, "startLeScan: null callback");
            return false;
        }
        BluetoothLeScanner scanner = this.getBluetoothLeScanner();
        if (scanner == null) {
            Log.e(TAG, "startLeScan: cannot get BluetoothLeScanner");
            return false;
        }
        Map<LeScanCallback, ScanCallback> map = this.mLeScanClients;
        synchronized (map) {
            if (this.mLeScanClients.containsKey(callback)) {
                Log.e(TAG, "LE Scan has already started");
                return false;
            }
            try {
                IBluetoothGatt iGatt = this.mManagerService.getBluetoothGatt();
                if (iGatt == null) {
                    return false;
                }
                ScanCallback scanCallback = new ScanCallback(){

                    @Override
                    public void onScanResult(int callbackType, ScanResult result) {
                        if (callbackType != 1) {
                            Log.e(BluetoothAdapter.TAG, "LE Scan has already started");
                            return;
                        }
                        ScanRecord scanRecord = result.getScanRecord();
                        if (scanRecord == null) {
                            return;
                        }
                        if (serviceUuids != null) {
                            ArrayList<ParcelUuid> uuids = new ArrayList<ParcelUuid>();
                            for (UUID uuid : serviceUuids) {
                                uuids.add(new ParcelUuid(uuid));
                            }
                            List<ParcelUuid> scanServiceUuids = scanRecord.getServiceUuids();
                            if (scanServiceUuids == null || !scanServiceUuids.containsAll(uuids)) {
                                Log.d(BluetoothAdapter.TAG, "uuids does not match");
                                return;
                            }
                        }
                        callback.onLeScan(result.getDevice(), result.getRssi(), scanRecord.getBytes());
                    }
                };
                ScanSettings settings = new ScanSettings.Builder().setCallbackType(1).setScanMode(2).build();
                ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
                if (serviceUuids != null && serviceUuids.length > 0) {
                    ScanFilter filter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(serviceUuids[0])).build();
                    filters.add(filter);
                }
                scanner.startScan(filters, settings, scanCallback);
                this.mLeScanClients.put(callback, scanCallback);
                return true;
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void stopLeScan(LeScanCallback callback) {
        Log.d(TAG, "stopLeScan()");
        BluetoothLeScanner scanner = this.getBluetoothLeScanner();
        if (scanner == null) {
            return;
        }
        Map<LeScanCallback, ScanCallback> map = this.mLeScanClients;
        synchronized (map) {
            ScanCallback scanCallback = this.mLeScanClients.remove(callback);
            if (scanCallback == null) {
                Log.d(TAG, "scan not started yet");
                return;
            }
            scanner.stopScan(scanCallback);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingL2capChannel() throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(4, true, true, -2, false, false);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        int assignedPsm = socket.mSocket.getPort();
        if (assignedPsm == 0) {
            throw new IOException("Error: Unable to assign PSM value");
        }
        Log.d(TAG, "listenUsingL2capChannel: set assigned PSM to " + assignedPsm);
        socket.setChannel(assignedPsm);
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingInsecureL2capChannel() throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(4, false, false, -2, false, false);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        int assignedPsm = socket.mSocket.getPort();
        if (assignedPsm == 0) {
            throw new IOException("Error: Unable to assign PSM value");
        }
        Log.d(TAG, "listenUsingInsecureL2capChannel: set assigned PSM to " + assignedPsm);
        socket.setChannel(assignedPsm);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean addOnMetadataChangedListener(BluetoothDevice device, Executor executor, OnMetadataChangedListener listener) {
        Log.d(TAG, "addOnMetadataChangedListener()");
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (device == null) {
            throw new NullPointerException("device is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService == null) {
                Log.e(TAG, "Bluetooth is not enabled. Cannot register metadata listener");
                boolean bl = false;
                return bl;
            }
            Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> map = this.mMetadataListeners;
            synchronized (map) {
                List<Pair<OnMetadataChangedListener, Executor>> listenerList = this.mMetadataListeners.get(device);
                if (listenerList == null) {
                    listenerList = new ArrayList<Pair<OnMetadataChangedListener, Executor>>();
                    this.mMetadataListeners.put(device, listenerList);
                } else if (listenerList.stream().anyMatch(pair -> ((OnMetadataChangedListener)pair.first).equals(listener))) {
                    throw new IllegalArgumentException("listener was already regestered for the device");
                }
                Pair<OnMetadataChangedListener, Executor> listenerPair = new Pair<OnMetadataChangedListener, Executor>(listener, executor);
                listenerList.add(listenerPair);
                boolean ret = false;
                try {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    this.mService.registerMetadataListener(this.mBluetoothMetadataListener, device, this.mAttributionSource, recv);
                    ret = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                }
                catch (RemoteException | TimeoutException e) {
                    Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                }
                finally {
                    if (!ret) {
                        listenerList.remove(listenerPair);
                        if (listenerList.isEmpty()) {
                            this.mMetadataListeners.remove(device);
                        }
                    }
                }
                boolean bl = ret;
                return bl;
            }
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean removeOnMetadataChangedListener(BluetoothDevice device, OnMetadataChangedListener listener) {
        Log.d(TAG, "removeOnMetadataChangedListener()");
        if (device == null) {
            throw new NullPointerException("device is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> map = this.mMetadataListeners;
        synchronized (map) {
            block13: {
                block14: {
                    boolean bl;
                    if (!this.mMetadataListeners.containsKey(device)) {
                        throw new IllegalArgumentException("device was not registered");
                    }
                    this.mMetadataListeners.get(device).removeIf(pair -> ((OnMetadataChangedListener)pair.first).equals(listener));
                    if (!this.mMetadataListeners.get(device).isEmpty()) break block13;
                    this.mMetadataListeners.remove(device);
                    this.mServiceLock.readLock().lock();
                    try {
                        if (this.mService == null) break block14;
                        SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                        this.mService.unregisterMetadataListener(device, this.mAttributionSource, recv);
                        bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                        this.mServiceLock.readLock().unlock();
                    }
                    catch (RemoteException | TimeoutException e) {
                        boolean bl2;
                        try {
                            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                            bl2 = false;
                            this.mServiceLock.readLock().unlock();
                        }
                        catch (Throwable throwable) {
                            this.mServiceLock.readLock().unlock();
                            throw throwable;
                        }
                        return bl2;
                    }
                    return bl;
                }
                this.mServiceLock.readLock().unlock();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean registerBluetoothConnectionCallback(Executor executor, BluetoothConnectionCallback callback) {
        Log.d(TAG, "registerBluetoothConnectionCallback()");
        if (callback == null) return false;
        if (executor == null) {
            return false;
        }
        Map<BluetoothConnectionCallback, Executor> map = this.mBluetoothConnectionCallbackExecutorMap;
        synchronized (map) {
            if (this.mBluetoothConnectionCallbackExecutorMap.isEmpty()) {
                this.mServiceLock.readLock().lock();
                try {
                    if (this.mService != null) {
                        SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                        this.mService.registerBluetoothConnectionCallback(this.mConnectionCallback, this.mAttributionSource, recv);
                        if (!recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false).booleanValue()) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                catch (RemoteException | TimeoutException e) {
                    Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                    this.mBluetoothConnectionCallbackExecutorMap.remove(callback);
                }
                finally {
                    this.mServiceLock.readLock().unlock();
                }
            }
            if (this.mBluetoothConnectionCallbackExecutorMap.containsKey(callback)) {
                throw new IllegalArgumentException("This callback has already been registered");
            }
            this.mBluetoothConnectionCallbackExecutorMap.put(callback, executor);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean unregisterBluetoothConnectionCallback(BluetoothConnectionCallback callback) {
        Log.d(TAG, "unregisterBluetoothConnectionCallback()");
        if (callback == null) {
            return false;
        }
        Map<BluetoothConnectionCallback, Executor> map = this.mBluetoothConnectionCallbackExecutorMap;
        synchronized (map) {
            if (this.mBluetoothConnectionCallbackExecutorMap.remove(callback) != null) {
                return false;
            }
        }
        if (!this.mBluetoothConnectionCallbackExecutorMap.isEmpty()) {
            return true;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.unregisterBluetoothConnectionCallback(this.mConnectionCallback, this.mAttributionSource, recv);
                boolean bl = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                return bl;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setPreferredAudioProfiles(BluetoothDevice device, Bundle modeToProfileBundle) {
        Log.d(TAG, "setPreferredAudioProfiles( " + modeToProfileBundle + ", " + device + ")");
        Objects.requireNonNull(modeToProfileBundle, "modeToProfileBundle must not be null");
        Objects.requireNonNull(device, "device must not be null");
        if (!BluetoothAdapter.checkBluetoothAddress(this.getAddress())) {
            throw new IllegalArgumentException("device cannot have an invalid address");
        }
        if (!modeToProfileBundle.containsKey(AUDIO_MODE_OUTPUT_ONLY) && !modeToProfileBundle.containsKey(AUDIO_MODE_DUPLEX)) {
            throw new IllegalArgumentException("Bundle does not contain a key AUDIO_MODE_OUTPUT_ONLY or AUDIO_MODE_DUPLEX");
        }
        if (modeToProfileBundle.containsKey(AUDIO_MODE_OUTPUT_ONLY) && modeToProfileBundle.getInt(AUDIO_MODE_OUTPUT_ONLY) != 2 && modeToProfileBundle.getInt(AUDIO_MODE_OUTPUT_ONLY) != 22) {
            throw new IllegalArgumentException("Key AUDIO_MODE_OUTPUT_ONLY has an invalid value: " + modeToProfileBundle.getInt(AUDIO_MODE_OUTPUT_ONLY));
        }
        if (modeToProfileBundle.containsKey(AUDIO_MODE_DUPLEX) && modeToProfileBundle.getInt(AUDIO_MODE_DUPLEX) != 1 && modeToProfileBundle.getInt(AUDIO_MODE_DUPLEX) != 22) {
            throw new IllegalArgumentException("Key AUDIO_MODE_DUPLEX has an invalid value: " + modeToProfileBundle.getInt(AUDIO_MODE_DUPLEX));
        }
        int defaultValue = Integer.MAX_VALUE;
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.setPreferredAudioProfiles(device, modeToProfileBundle, this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                return n;
            }
            int recv = 1;
            return recv;
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            throw e.rethrowFromSystemServer();
        }
        catch (TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public Bundle getPreferredAudioProfiles(BluetoothDevice device) {
        Log.d(TAG, "getPreferredAudioProfiles(" + device + ")");
        Objects.requireNonNull(device, "device cannot be null");
        if (!BluetoothAdapter.checkBluetoothAddress(device.getAddress())) {
            throw new IllegalArgumentException("device cannot have an invalid address");
        }
        Bundle defaultValue = Bundle.EMPTY;
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getPreferredAudioProfiles(device, this.mAttributionSource, recv);
                Bundle bundle = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
                return bundle;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            throw e.rethrowFromSystemServer();
        }
        catch (TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int notifyActiveDeviceChangeApplied(BluetoothDevice device) {
        Log.d(TAG, "notifyActiveDeviceChangeApplied(" + device + ")");
        Objects.requireNonNull(device, "device cannot be null");
        if (!BluetoothAdapter.checkBluetoothAddress(device.getAddress())) {
            throw new IllegalArgumentException("device cannot have an invalid address");
        }
        int defaultValue = Integer.MAX_VALUE;
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.notifyActiveDeviceChangeApplied(device, this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                return n;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            throw e.rethrowFromSystemServer();
        }
        catch (TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int registerPreferredAudioProfilesChangedCallback(Executor executor, PreferredAudioProfilesChangedCallback callback) {
        Log.d(TAG, "registerPreferredAudioProfilesChangedCallback()");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        int defaultValue = Integer.MAX_VALUE;
        int serviceCallStatus = Integer.MAX_VALUE;
        Map<PreferredAudioProfilesChangedCallback, Executor> map = this.mAudioProfilesChangedCallbackExecutorMap;
        synchronized (map) {
            if (this.mAudioProfilesChangedCallbackExecutorMap.isEmpty()) {
                this.mServiceLock.readLock().lock();
                try {
                    if (this.mService != null) {
                        SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                        this.mService.registerPreferredAudioProfilesChangedCallback(this.mPreferredAudioProfilesChangedCallback, this.mAttributionSource, recv);
                        serviceCallStatus = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                    }
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                catch (TimeoutException e) {
                    Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                }
                finally {
                    this.mServiceLock.readLock().unlock();
                }
                if (serviceCallStatus != 0) {
                    return serviceCallStatus;
                }
            }
            if (this.mAudioProfilesChangedCallbackExecutorMap.containsKey(callback)) {
                throw new IllegalArgumentException("This callback has already been registered");
            }
            this.mAudioProfilesChangedCallbackExecutorMap.put(callback, executor);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int unregisterPreferredAudioProfilesChangedCallback(PreferredAudioProfilesChangedCallback callback) {
        Log.d(TAG, "unregisterPreferredAudioProfilesChangedCallback()");
        Objects.requireNonNull(callback, "callback cannot be null");
        Map<PreferredAudioProfilesChangedCallback, Executor> map = this.mAudioProfilesChangedCallbackExecutorMap;
        synchronized (map) {
            if (this.mAudioProfilesChangedCallbackExecutorMap.remove(callback) == null) {
                throw new IllegalArgumentException("This callback has not been registered");
            }
        }
        if (!this.mBluetoothConnectionCallbackExecutorMap.isEmpty()) {
            return 0;
        }
        int defaultValue = Integer.MAX_VALUE;
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.unregisterPreferredAudioProfilesChangedCallback(this.mPreferredAudioProfilesChangedCallback, this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                return n;
            }
        }
        catch (TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int registerBluetoothQualityReportReadyCallback(Executor executor, BluetoothQualityReportReadyCallback callback) {
        Log.d(TAG, "registerBluetoothQualityReportReadyCallback()");
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        int defaultValue = Integer.MAX_VALUE;
        int serviceCallStatus = Integer.MAX_VALUE;
        Map<BluetoothQualityReportReadyCallback, Executor> map = this.mBluetoothQualityReportReadyCallbackExecutorMap;
        synchronized (map) {
            if (this.mBluetoothQualityReportReadyCallbackExecutorMap.isEmpty()) {
                this.mServiceLock.readLock().lock();
                try {
                    if (this.mService != null) {
                        SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                        this.mService.registerBluetoothQualityReportReadyCallback(this.mBluetoothQualityReportReadyCallback, this.mAttributionSource, recv);
                        serviceCallStatus = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                    }
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                catch (TimeoutException e) {
                    Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                }
                finally {
                    this.mServiceLock.readLock().unlock();
                }
                if (serviceCallStatus != 0) {
                    return serviceCallStatus;
                }
            }
            if (this.mBluetoothQualityReportReadyCallbackExecutorMap.containsKey(callback)) {
                throw new IllegalArgumentException("This callback has already been registered");
            }
            this.mBluetoothQualityReportReadyCallbackExecutorMap.put(callback, executor);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int unregisterBluetoothQualityReportReadyCallback(BluetoothQualityReportReadyCallback callback) {
        Log.d(TAG, "unregisterBluetoothQualityReportReadyCallback()");
        Objects.requireNonNull(callback, "callback cannot be null");
        Map<BluetoothQualityReportReadyCallback, Executor> map = this.mBluetoothQualityReportReadyCallbackExecutorMap;
        synchronized (map) {
            if (this.mBluetoothQualityReportReadyCallbackExecutorMap.remove(callback) == null) {
                throw new IllegalArgumentException("This callback has not been registered");
            }
        }
        if (!this.mBluetoothConnectionCallbackExecutorMap.isEmpty()) {
            return 0;
        }
        int defaultValue = Integer.MAX_VALUE;
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.unregisterBluetoothQualityReportReadyCallback(this.mBluetoothQualityReportReadyCallback, this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                return n;
            }
        }
        catch (TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    public static int priorityToConnectionPolicy(int priority) {
        switch (priority) {
            case 1000: {
                return 100;
            }
            case 100: {
                return 100;
            }
            case 0: {
                return 0;
            }
            case -1: {
                return -1;
            }
        }
        Log.e(TAG, "setPriority: Invalid priority: " + priority);
        return -1;
    }

    public static int connectionPolicyToPriority(int connectionPolicy) {
        switch (connectionPolicy) {
            case 100: {
                return 100;
            }
            case 0: {
                return 0;
            }
            case -1: {
                return -1;
            }
        }
        return -1;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public int setBluetoothHciSnoopLoggingMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Invalid Bluetooth HCI snoop log mode param value");
        }
        try {
            return this.mManagerService.setBtHciSnoopLogMode(mode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return Integer.MAX_VALUE;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public int getBluetoothHciSnoopLoggingMode() {
        try {
            return this.mManagerService.getBtHciSnoopLogMode();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return 0;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getOffloadedTransportDiscoveryDataScanSupported() {
        if (!this.getLeAccess()) {
            return 1;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                this.mService.getOffloadedTransportDiscoveryDataScanSupported(this.mAttributionSource, recv);
                int n = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(Integer.MAX_VALUE);
                return n;
            }
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    static {
        sServiceLock = new Object();
        sBluetoothGetStateQuery = new IpcDataCache.QueryHandler<IBluetooth, Integer>(){

            @Override
            @RequiresNoPermission
            public Integer apply(IBluetooth serviceQuery) {
                try {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    serviceQuery.getState(recv);
                    return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(10);
                }
                catch (RemoteException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        sBluetoothGetStateCache = new BluetoothCache<IBluetooth, Integer>(GET_STATE_API, sBluetoothGetStateQuery);
        sBluetoothFilteringQuery = new IpcDataCache.QueryHandler<IBluetooth, Boolean>(){

            @Override
            @RequiresNoPermission
            public Boolean apply(IBluetooth serviceQuery) {
                try {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    serviceQuery.isOffloadedFilteringSupported(recv);
                    return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
                }
                catch (RemoteException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        sBluetoothFilteringCache = new BluetoothCache<IBluetooth, Boolean>(FILTERING_API, sBluetoothFilteringQuery);
        sBluetoothGetAdapterConnectionStateQuery = new IpcDataCache.QueryHandler<IBluetooth, Integer>(){

            @Override
            @RequiresNoPermission
            public Integer apply(IBluetooth serviceQuery) {
                try {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    serviceQuery.getAdapterConnectionState(recv);
                    return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
                }
                catch (RemoteException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        sBluetoothGetAdapterConnectionStateCache = new BluetoothCache<IBluetooth, Integer>(GET_CONNECTION_API, sBluetoothGetAdapterConnectionStateQuery);
        sBluetoothProfileQuery = new IpcDataCache.QueryHandler<Pair<IBluetooth, Pair<AttributionSource, Integer>>, Integer>(){

            @Override
            @RequiresNoPermission
            public Integer apply(Pair<IBluetooth, Pair<AttributionSource, Integer>> pairQuery) {
                IBluetooth service = (IBluetooth)pairQuery.first;
                AttributionSource source = (AttributionSource)((Pair)pairQuery.second).first;
                Integer profile = (Integer)((Pair)pairQuery.second).second;
                boolean defaultValue = false;
                try {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    service.getProfileConnectionState(profile, source, recv);
                    return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
                }
                catch (RemoteException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        sGetProfileConnectionStateCache = new BluetoothCache<Pair<IBluetooth, Pair<AttributionSource, Integer>>, Integer>(PROFILE_API, sBluetoothProfileQuery);
        sManagerCallback = new IBluetoothManagerCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBluetoothServiceUp(IBluetooth bluetoothService) {
                Log.d(BluetoothAdapter.TAG, "onBluetoothServiceUp: " + bluetoothService);
                Object object = sServiceLock;
                synchronized (object) {
                    sService = bluetoothService;
                    for (IBluetoothManagerCallback cb : sProxyServiceStateCallbacks.keySet()) {
                        try {
                            if (cb != null) {
                                cb.onBluetoothServiceUp(bluetoothService);
                                continue;
                            }
                            Log.d(BluetoothAdapter.TAG, "onBluetoothServiceUp: cb is null!");
                        }
                        catch (Exception e) {
                            Log.e(BluetoothAdapter.TAG, "", e);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBluetoothServiceDown() {
                Log.d(BluetoothAdapter.TAG, "onBluetoothServiceDown");
                Object object = sServiceLock;
                synchronized (object) {
                    sService = null;
                    for (IBluetoothManagerCallback cb : sProxyServiceStateCallbacks.keySet()) {
                        try {
                            if (cb != null) {
                                cb.onBluetoothServiceDown();
                                continue;
                            }
                            Log.d(BluetoothAdapter.TAG, "onBluetoothServiceDown: cb is null!");
                        }
                        catch (Exception e) {
                            Log.e(BluetoothAdapter.TAG, "", e);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBrEdrDown() {
                Object object = sServiceLock;
                synchronized (object) {
                    for (IBluetoothManagerCallback cb : sProxyServiceStateCallbacks.keySet()) {
                        try {
                            if (cb != null) {
                                cb.onBrEdrDown();
                                continue;
                            }
                            Log.d(BluetoothAdapter.TAG, "onBrEdrDown: cb is null!");
                        }
                        catch (Exception e) {
                            Log.e(BluetoothAdapter.TAG, "", e);
                        }
                    }
                }
            }
        };
        sProxyServiceStateCallbacks = new WeakHashMap();
    }

    private static class OnBluetoothActivityEnergyInfoProxy
    extends IBluetoothActivityEnergyInfoListener.Stub {
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private Executor mExecutor;
        @GuardedBy(value={"mLock"})
        private OnBluetoothActivityEnergyInfoCallback mCallback;

        OnBluetoothActivityEnergyInfoProxy(Executor executor, OnBluetoothActivityEnergyInfoCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothActivityEnergyInfoAvailable(BluetoothActivityEnergyInfo info) {
            OnBluetoothActivityEnergyInfoCallback callback;
            Executor executor;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mExecutor == null || this.mCallback == null) {
                    return;
                }
                executor = this.mExecutor;
                callback = this.mCallback;
                this.mExecutor = null;
                this.mCallback = null;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                if (info == null) {
                    executor.execute(() -> callback.onBluetoothActivityEnergyInfoError(11));
                } else {
                    executor.execute(() -> callback.onBluetoothActivityEnergyInfoAvailable(info));
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(int errorCode) {
            OnBluetoothActivityEnergyInfoCallback callback;
            Executor executor;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mExecutor == null || this.mCallback == null) {
                    return;
                }
                executor = this.mExecutor;
                callback = this.mCallback;
                this.mExecutor = null;
                this.mCallback = null;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                executor.execute(() -> callback.onBluetoothActivityEnergyInfoError(errorCode));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    @SystemApi
    public static interface OnBluetoothActivityEnergyInfoCallback {
        public void onBluetoothActivityEnergyInfoAvailable(BluetoothActivityEnergyInfo var1);

        public void onBluetoothActivityEnergyInfoError(int var1);
    }

    @SystemApi
    public static interface OobDataCallback {
        public void onOobData(int var1, OobData var2);

        public void onError(int var1);
    }

    public class WrappedOobDataCallback
    extends IBluetoothOobDataCallback.Stub {
        private final OobDataCallback mCallback;
        private final Executor mExecutor;

        WrappedOobDataCallback(OobDataCallback callback, Executor executor) {
            Objects.requireNonNull(callback);
            Objects.requireNonNull(executor);
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        @Override
        public void onOobData(final int transport, final OobData oobData) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    WrappedOobDataCallback.this.mCallback.onOobData(transport, oobData);
                }
            });
        }

        @Override
        public void onError(final int errorCode) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    WrappedOobDataCallback.this.mCallback.onError(errorCode);
                }
            });
        }
    }

    public static abstract class ServiceLifecycleCallback {
        IBluetoothManagerCallback mRemote = new IBluetoothManagerCallback.Stub(){

            @Override
            public void onBluetoothServiceUp(IBluetooth bluetoothService) {
                this.onBluetoothServiceUp();
            }

            @Override
            public void onBluetoothServiceDown() {
                this.onBluetoothServiceDown();
            }

            @Override
            public void onBrEdrDown() {
            }
        };

        public abstract void onBluetoothServiceUp();

        public abstract void onBluetoothServiceDown();
    }

    public static interface LeScanCallback {
        public void onLeScan(BluetoothDevice var1, int var2, byte[] var3);
    }

    @SystemApi
    public static interface OnMetadataChangedListener {
        public void onMetadataChanged(BluetoothDevice var1, int var2, byte[] var3);
    }

    private static class BluetoothCache<Q, R>
    extends IpcDataCache<Q, R> {
        BluetoothCache(String api, IpcDataCache.QueryHandler query) {
            super(8, "bluetooth", api, api, query);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GetOffloadedTransportDiscoveryDataScanSupportedReturnValues {
    }

    @SystemApi
    public static interface BluetoothQualityReportReadyCallback {
        @SystemApi
        public void onBluetoothQualityReportReady(BluetoothDevice var1, BluetoothQualityReport var2, int var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UnRegisterBluetoothQualityReportReadyCallbackReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RegisterBluetoothQualityReportReadyCallbackReturnValues {
    }

    @SystemApi
    public static interface PreferredAudioProfilesChangedCallback {
        @SystemApi
        public void onPreferredAudioProfilesChanged(BluetoothDevice var1, Bundle var2, int var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UnRegisterPreferredAudioProfilesCallbackReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RegisterPreferredAudioProfilesCallbackReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NotifyActiveDeviceChangeAppliedReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetPreferredAudioProfilesReturnValues {
    }

    @SystemApi
    public static abstract class BluetoothConnectionCallback {
        public void onDeviceConnected(BluetoothDevice device) {
        }

        public void onDeviceDisconnected(BluetoothDevice device, int reason) {
        }

        public static String disconnectReasonToString(int reason) {
            switch (reason) {
                case 0x7FFFFFFF: {
                    return "Reason unknown";
                }
                case 1100: {
                    return "Local request";
                }
                case 1101: {
                    return "Remote request";
                }
                case 1102: {
                    return "Local error";
                }
                case 1103: {
                    return "Remote error";
                }
                case 1104: {
                    return "Timeout";
                }
                case 1105: {
                    return "Security";
                }
                case 1106: {
                    return "System policy";
                }
                case 1107: {
                    return "Resource constrained";
                }
                case 1108: {
                    return "Connection already exists";
                }
                case 1109: {
                    return "Bad parameters";
                }
            }
            return "Unrecognized disconnect reason: " + reason;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DisconnectReason {
        }
    }

    public class StateChangeCallbackWrapper
    extends IBluetoothStateChangeCallback.Stub {
        private BluetoothStateChangeCallback mCallback;

        StateChangeCallbackWrapper(BluetoothStateChangeCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public void onBluetoothStateChange(boolean on) {
            this.mCallback.onBluetoothStateChange(on);
        }
    }

    public static interface BluetoothStateChangeCallback {
        public void onBluetoothStateChange(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OobError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LeFeatureReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BluetoothActivityEnergyInfoCallbackError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActiveDeviceProfile {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActiveDeviceUse {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IoCapability {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetSnoopLogModeStatusCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BluetoothSnoopLogMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanModeStatusCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RfcommListenerResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdapterState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InternalAdapterState {
    }
}

