/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetoothHearingAid;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.Context;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class BluetoothHearingAid
implements BluetoothProfile {
    private static final String TAG = "BluetoothHearingAid";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.hearingaid.profile.action.CONNECTION_STATE_CHANGED";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_ACTIVE_DEVICE_CHANGED = "android.bluetooth.hearingaid.profile.action.ACTIVE_DEVICE_CHANGED";
    @SystemApi
    public static final int SIDE_UNKNOWN = -1;
    @SystemApi
    public static final int SIDE_LEFT = 0;
    @SystemApi
    public static final int SIDE_RIGHT = 1;
    @SystemApi
    public static final int MODE_UNKNOWN = -1;
    @SystemApi
    public static final int MODE_MONAURAL = 0;
    @SystemApi
    public static final int MODE_BINAURAL = 1;
    @SystemApi
    public static final long HI_SYNC_ID_INVALID = 0L;
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private final BluetoothProfileConnector<IBluetoothHearingAid> mProfileConnector = new BluetoothProfileConnector(this, 21, "BluetoothHearingAid", IBluetoothHearingAid.class.getName()){

        public IBluetoothHearingAid getServiceInterface(IBinder service) {
            return IBluetoothHearingAid.Stub.asInterface(service);
        }
    };

    BluetoothHearingAid(Context context, BluetoothProfile.ServiceListener listener, BluetoothAdapter adapter) {
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener);
    }

    @Override
    public void close() {
        this.mProfileConnector.disconnect();
    }

    private IBluetoothHearingAid getService() {
        return this.mProfileConnector.getService();
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean connect(BluetoothDevice device) {
        BluetoothHearingAid.log("connect(" + device + ")");
        IBluetoothHearingAid service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.connect(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean disconnect(BluetoothDevice device) {
        BluetoothHearingAid.log("disconnect(" + device + ")");
        IBluetoothHearingAid service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.disconnect(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getConnectedDevices() {
        IBluetoothHearingAid service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectedDevices(this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothHearingAid service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getDevicesMatchingConnectionStates(states, this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice device) {
        IBluetoothHearingAid service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionState(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean setActiveDevice(BluetoothDevice device) {
        BluetoothHearingAid.log("setActiveDevice(" + device + ")");
        IBluetoothHearingAid service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && (device == null || this.isValidDevice(device))) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setActiveDevice(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getActiveDevices() {
        IBluetoothHearingAid service = this.getService();
        ArrayList<BluetoothDevice> defaultValue = new ArrayList<BluetoothDevice>();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getActiveDevices(this.mAttributionSource, recv);
                return Attributable.setAttributionSource((List)recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue), this.mAttributionSource);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return defaultValue;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPriority(BluetoothDevice device, int priority) {
        BluetoothHearingAid.log("setPriority(" + device + ", " + priority + ")");
        return this.setConnectionPolicy(device, BluetoothAdapter.priorityToConnectionPolicy(priority));
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        BluetoothHearingAid.log("setConnectionPolicy(" + device + ", " + connectionPolicy + ")");
        this.verifyDeviceNotNull(device, "setConnectionPolicy");
        IBluetoothHearingAid service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device) && (connectionPolicy == 0 || connectionPolicy == 100)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setConnectionPolicy(device, connectionPolicy, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getPriority(BluetoothDevice device) {
        return BluetoothAdapter.connectionPolicyToPriority(this.getConnectionPolicy(device));
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionPolicy(BluetoothDevice device) {
        this.verifyDeviceNotNull(device, "getConnectionPolicy");
        IBluetoothHearingAid service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getConnectionPolicy(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
        }
        return "<unknown state " + state + ">";
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setVolume(int volume) {
        Log.d(TAG, "setVolume(" + volume + ")");
        IBluetoothHearingAid service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.setVolume(volume, this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public long getHiSyncId(BluetoothDevice device) {
        this.verifyDeviceNotNull(device, "getHiSyncId");
        IBluetoothHearingAid service = this.getService();
        long defaultValue = 0L;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getHiSyncId(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(0L);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0L;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getDeviceSide(BluetoothDevice device) {
        this.verifyDeviceNotNull(device, "getDeviceSide");
        IBluetoothHearingAid service = this.getService();
        int defaultValue = -1;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getDeviceSide(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(-1);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return -1;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getDeviceMode(BluetoothDevice device) {
        this.verifyDeviceNotNull(device, "getDeviceMode");
        IBluetoothHearingAid service = this.getService();
        int defaultValue = -1;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled() && this.isValidDevice(device)) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getDeviceMode(device, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(-1);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return -1;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public AdvertisementServiceData getAdvertisementServiceData(BluetoothDevice device) {
        BluetoothHearingAid.log("getAdvertisementServiceData()");
        IBluetoothHearingAid service = this.getService();
        AdvertisementServiceData result = null;
        if (service == null || !this.isEnabled() || !this.isValidDevice(device)) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothHearingAid.log(Log.getStackTraceString(new Throwable()));
        } else {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getAdvertisementServiceData(device, this.mAttributionSource, recv);
                result = recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
            catch (RemoteException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return result;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private int getDeviceSideInternal(BluetoothDevice device) {
        return this.getDeviceSide(device);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private int getDeviceModeInternal(BluetoothDevice device) {
        return this.getDeviceMode(device);
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private void verifyDeviceNotNull(BluetoothDevice device, String methodName) {
        if (device == null) {
            Log.e(TAG, methodName + ": device param is null");
            throw new IllegalArgumentException("Device cannot be null");
        }
    }

    private boolean isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    @SystemApi
    public static class AdvertisementServiceData
    implements Parcelable {
        private static final String TAG = "AdvertisementData";
        private final int mCapability;
        private final int mTruncatedHiSyncId;
        public static final Parcelable.Creator<AdvertisementServiceData> CREATOR = new Parcelable.Creator<AdvertisementServiceData>(){

            @Override
            public AdvertisementServiceData createFromParcel(Parcel in) {
                return new AdvertisementServiceData(in);
            }

            public AdvertisementServiceData[] newArray(int size) {
                return new AdvertisementServiceData[size];
            }
        };

        public AdvertisementServiceData(int capability, int truncatedHiSyncId) {
            Log.d(TAG, "capability:" + capability + " truncatedHiSyncId:" + truncatedHiSyncId);
            this.mCapability = capability;
            this.mTruncatedHiSyncId = truncatedHiSyncId;
        }

        @SystemApi
        @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
        public int getDeviceMode() {
            return this.mCapability >> 1 & 1;
        }

        private AdvertisementServiceData(Parcel in) {
            this.mCapability = in.readInt();
            this.mTruncatedHiSyncId = in.readInt();
        }

        @SystemApi
        @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
        public int getDeviceSide() {
            return this.mCapability & 1;
        }

        @SystemApi
        @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
        public boolean isCsipSupported() {
            return (this.mCapability >> 2 & 1) != 0;
        }

        @SystemApi
        @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
        public int getTruncatedHiSyncId() {
            return this.mTruncatedHiSyncId;
        }

        @SystemApi
        @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
        public boolean isInPairWith(AdvertisementServiceData data) {
            if (data == null) {
                return false;
            }
            boolean bothSupportCsip = this.isCsipSupported() && data.isCsipSupported();
            boolean isDifferentSide = this.getDeviceSide() != -1 && data.getDeviceSide() != -1 && this.getDeviceSide() != data.getDeviceSide();
            boolean isSameTruncatedHiSyncId = this.mTruncatedHiSyncId == data.mTruncatedHiSyncId;
            return bothSupportCsip && isDifferentSide && isSameTruncatedHiSyncId;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mCapability);
            dest.writeInt(this.mTruncatedHiSyncId);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceSide {
    }
}

