/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SystemApi;
import android.bluetooth.BluetoothUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SystemApi
public class BluetoothLeAudioCodecConfigMetadata
implements Parcelable {
    private static final int SAMPLING_FREQUENCY_TYPE = 1;
    private static final int FRAME_DURATION_TYPE = 2;
    private static final int AUDIO_CHANNEL_LOCATION_TYPE = 3;
    private static final int OCTETS_PER_FRAME_TYPE = 4;
    private final long mAudioLocation;
    private final int mSampleRate;
    private final int mFrameDuration;
    private final int mOctetsPerFrame;
    private final byte[] mRawMetadata;
    private static final int CONFIG_SAMPLING_FREQUENCY_UNKNOWN = 0;
    private static final int CONFIG_SAMPLING_FREQUENCY_8000 = 1;
    private static final int CONFIG_SAMPLING_FREQUENCY_16000 = 3;
    private static final int CONFIG_SAMPLING_FREQUENCY_24000 = 5;
    private static final int CONFIG_SAMPLING_FREQUENCY_32000 = 6;
    private static final int CONFIG_SAMPLING_FREQUENCY_44100 = 7;
    private static final int CONFIG_SAMPLING_FREQUENCY_48000 = 8;
    private static final int CONFIG_FRAME_DURATION_UNKNOWN = -1;
    private static final int CONFIG_FRAME_DURATION_7500 = 0;
    private static final int CONFIG_FRAME_DURATION_10000 = 1;
    @SystemApi
    public static final Parcelable.Creator<BluetoothLeAudioCodecConfigMetadata> CREATOR = new Parcelable.Creator<BluetoothLeAudioCodecConfigMetadata>(){

        @Override
        public BluetoothLeAudioCodecConfigMetadata createFromParcel(Parcel in) {
            byte[] rawMetadata;
            long audioLocation = in.readLong();
            int rawMetadataLen = in.readInt();
            if (rawMetadataLen != -1) {
                rawMetadata = new byte[rawMetadataLen];
                in.readByteArray(rawMetadata);
            } else {
                rawMetadata = new byte[]{};
            }
            int sampleRate = in.readInt();
            int frameDuration = in.readInt();
            int octetsPerFrame = in.readInt();
            return new BluetoothLeAudioCodecConfigMetadata(audioLocation, sampleRate, frameDuration, octetsPerFrame, rawMetadata);
        }

        public BluetoothLeAudioCodecConfigMetadata[] newArray(int size) {
            return new BluetoothLeAudioCodecConfigMetadata[size];
        }
    };

    private BluetoothLeAudioCodecConfigMetadata(long audioLocation, int sampleRate, int frameDuration, int octetsPerFrame, byte[] rawMetadata) {
        this.mAudioLocation = audioLocation;
        this.mSampleRate = sampleRate;
        this.mFrameDuration = frameDuration;
        this.mOctetsPerFrame = octetsPerFrame;
        this.mRawMetadata = rawMetadata;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof BluetoothLeAudioCodecConfigMetadata) {
            BluetoothLeAudioCodecConfigMetadata oth = (BluetoothLeAudioCodecConfigMetadata)o;
            return this.mAudioLocation == oth.getAudioLocation() && this.mSampleRate == oth.getSampleRate() && this.mFrameDuration == oth.getFrameDuration() && this.mOctetsPerFrame == oth.getOctetsPerFrame() && Arrays.equals(this.mRawMetadata, oth.getRawMetadata());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mAudioLocation, this.mSampleRate, this.mFrameDuration, this.mOctetsPerFrame, Arrays.hashCode(this.mRawMetadata));
    }

    @SystemApi
    public long getAudioLocation() {
        return this.mAudioLocation;
    }

    @SystemApi
    public int getSampleRate() {
        return this.mSampleRate;
    }

    @SystemApi
    public int getFrameDuration() {
        return this.mFrameDuration;
    }

    @SystemApi
    public int getOctetsPerFrame() {
        return this.mOctetsPerFrame;
    }

    @SystemApi
    public byte[] getRawMetadata() {
        return this.mRawMetadata;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mAudioLocation);
        if (this.mRawMetadata != null) {
            out.writeInt(this.mRawMetadata.length);
            out.writeByteArray(this.mRawMetadata);
        } else {
            out.writeInt(-1);
        }
        out.writeInt(this.mSampleRate);
        out.writeInt(this.mFrameDuration);
        out.writeInt(this.mOctetsPerFrame);
    }

    @SystemApi
    public static BluetoothLeAudioCodecConfigMetadata fromRawBytes(byte[] rawBytes) {
        if (rawBytes == null) {
            throw new IllegalArgumentException("Raw bytes cannot be null");
        }
        List<BluetoothUtils.TypeValueEntry> entries = BluetoothUtils.parseLengthTypeValueBytes(rawBytes);
        if (rawBytes.length > 0 && rawBytes[0] > 0 && entries.isEmpty()) {
            throw new IllegalArgumentException("No LTV entries are found from rawBytes of size " + rawBytes.length);
        }
        long audioLocation = 0L;
        int samplingFrequency = 0;
        int frameDuration = -1;
        int octetsPerFrame = 0;
        for (BluetoothUtils.TypeValueEntry entry : entries) {
            byte[] bytes;
            if (entry.getType() == 3) {
                bytes = entry.getValue();
                audioLocation = (long)((bytes[0] & 0xFF) << 0 | (bytes[1] & 0xFF) << 8 | (bytes[2] & 0xFF) << 16) | (long)(bytes[3] & 0xFF) << 24;
                continue;
            }
            if (entry.getType() == 1) {
                bytes = entry.getValue();
                samplingFrequency = bytes[0] & 0xFF;
                continue;
            }
            if (entry.getType() == 2) {
                bytes = entry.getValue();
                frameDuration = bytes[0] & 0xFF;
                continue;
            }
            if (entry.getType() != 4) continue;
            bytes = entry.getValue();
            octetsPerFrame = (bytes[0] & 0xFF) << 0 | (bytes[1] & 0xFF) << 8;
        }
        return new BluetoothLeAudioCodecConfigMetadata(audioLocation, BluetoothLeAudioCodecConfigMetadata.convertToSampleRateBitset(samplingFrequency), BluetoothLeAudioCodecConfigMetadata.convertToFrameDurationBitset(frameDuration), octetsPerFrame, rawBytes);
    }

    private static int convertToSampleRateBitset(int samplingFrequencyValue) {
        switch (samplingFrequencyValue) {
            case 1: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 5: {
                return 16;
            }
            case 6: {
                return 32;
            }
            case 7: {
                return 64;
            }
            case 8: {
                return 128;
            }
        }
        return 0;
    }

    private static int convertToSamplingFrequencyValue(int sampleRateBitSet) {
        switch (sampleRateBitSet) {
            case 1: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 16: {
                return 5;
            }
            case 32: {
                return 6;
            }
            case 64: {
                return 7;
            }
            case 128: {
                return 8;
            }
        }
        return 0;
    }

    private static int convertToFrameDurationBitset(int frameDurationValue) {
        switch (frameDurationValue) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    private static int convertToFrameDurationValue(int frameDurationBitset) {
        switch (frameDurationBitset) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return -1;
    }

    @SystemApi
    public static class Builder {
        private long mAudioLocation = 0L;
        private int mSampleRate = 0;
        private int mFrameDuration = 0;
        private int mOctetsPerFrame = 0;
        private byte[] mRawMetadata = null;

        @SystemApi
        public Builder() {
        }

        @SystemApi
        public Builder(BluetoothLeAudioCodecConfigMetadata original) {
            this.mAudioLocation = original.getAudioLocation();
            this.mSampleRate = original.getSampleRate();
            this.mFrameDuration = original.getFrameDuration();
            this.mOctetsPerFrame = original.getOctetsPerFrame();
            this.mRawMetadata = original.getRawMetadata();
        }

        @SystemApi
        public Builder setAudioLocation(long audioLocation) {
            this.mAudioLocation = audioLocation;
            return this;
        }

        @SystemApi
        public Builder setSampleRate(int sampleRate) {
            if (sampleRate != 0 && sampleRate != 1 && sampleRate != 4 && sampleRate != 16 && sampleRate != 32 && sampleRate != 64 && sampleRate != 128) {
                throw new IllegalArgumentException("Invalid sample rate " + sampleRate);
            }
            this.mSampleRate = sampleRate;
            return this;
        }

        @SystemApi
        public Builder setFrameDuration(int frameDuration) {
            if (frameDuration != 0 && frameDuration != 1 && frameDuration != 2) {
                throw new IllegalArgumentException("Invalid frame duration " + frameDuration);
            }
            this.mFrameDuration = frameDuration;
            return this;
        }

        @SystemApi
        public Builder setOctetsPerFrame(int octetsPerFrame) {
            if (octetsPerFrame < 0) {
                throw new IllegalArgumentException("Invalid octetsPerFrame " + octetsPerFrame);
            }
            this.mOctetsPerFrame = octetsPerFrame;
            return this;
        }

        @SystemApi
        public BluetoothLeAudioCodecConfigMetadata build() {
            byte[] rawBytes;
            List<Object> entries = new ArrayList();
            if (this.mRawMetadata != null) {
                entries = BluetoothUtils.parseLengthTypeValueBytes(this.mRawMetadata);
                if (this.mRawMetadata.length > 0 && this.mRawMetadata[0] > 0 && entries.isEmpty()) {
                    throw new IllegalArgumentException("No LTV entries are found from rawBytes of size " + this.mRawMetadata.length + " please check the original object passed to Builder's copy constructor");
                }
            }
            if (this.mSampleRate != 0) {
                int samplingFrequency = BluetoothLeAudioCodecConfigMetadata.convertToSamplingFrequencyValue(this.mSampleRate);
                entries.removeIf(entry -> entry.getType() == 1);
                entries.add(new BluetoothUtils.TypeValueEntry(1, ByteBuffer.allocate(1).put((byte)(samplingFrequency & 0xFF)).array()));
            }
            if (this.mFrameDuration != 0) {
                int frameDuration = BluetoothLeAudioCodecConfigMetadata.convertToFrameDurationValue(this.mFrameDuration);
                entries.removeIf(entry -> entry.getType() == 2);
                entries.add(new BluetoothUtils.TypeValueEntry(2, ByteBuffer.allocate(1).put((byte)(frameDuration & 0xFF)).array()));
            }
            if (this.mAudioLocation != -1L) {
                entries.removeIf(entry -> entry.getType() == 3);
                entries.add(new BluetoothUtils.TypeValueEntry(3, ByteBuffer.allocate(4).putInt((int)(this.mAudioLocation & 0xFFFFFFFFFFFFFFFFL)).array()));
            }
            if (this.mOctetsPerFrame != 0) {
                entries.removeIf(entry -> entry.getType() == 4);
                entries.add(new BluetoothUtils.TypeValueEntry(4, ByteBuffer.allocate(2).putShort((short)(this.mOctetsPerFrame & 0xFFFF)).array()));
            }
            if ((rawBytes = BluetoothUtils.serializeTypeValue(entries)) == null) {
                throw new IllegalArgumentException("Failed to serialize entries to bytes");
            }
            return new BluetoothLeAudioCodecConfigMetadata(this.mAudioLocation, this.mSampleRate, this.mFrameDuration, this.mOctetsPerFrame, rawBytes);
        }
    }
}

