/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothLeAudioContentMetadata;
import android.bluetooth.BluetoothLeBroadcastMetadata;
import android.bluetooth.BluetoothLeBroadcastSettings;
import android.bluetooth.BluetoothLeBroadcastSubgroupSettings;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetoothLeAudio;
import android.bluetooth.IBluetoothLeBroadcastCallback;
import android.content.AttributionSource;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.CloseGuard;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;

@SystemApi
public class BluetoothLeBroadcast
implements AutoCloseable,
BluetoothProfile {
    private static final String TAG = "BluetoothLeBroadcast";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private CloseGuard mCloseGuard;
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private final BluetoothProfileConnector<IBluetoothLeAudio> mProfileConnector = new BluetoothProfileConnector(this, 26, "BluetoothLeAudioBroadcast", IBluetoothLeAudio.class.getName()){

        public IBluetoothLeAudio getServiceInterface(IBinder service) {
            return IBluetoothLeAudio.Stub.asInterface(service);
        }
    };
    private final Map<Callback, Executor> mCallbackExecutorMap = new HashMap<Callback, Executor>();
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IBluetoothLeBroadcastCallback mCallback = new IBluetoothLeBroadcastCallback.Stub(){

        @Override
        public void onBroadcastStarted(int reason, int broadcastId) {
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothLeBroadcast.this.mCallbackExecutorMap.entrySet()) {
                Callback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onBroadcastStarted(reason, broadcastId));
            }
        }

        @Override
        public void onBroadcastStartFailed(int reason) {
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothLeBroadcast.this.mCallbackExecutorMap.entrySet()) {
                Callback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onBroadcastStartFailed(reason));
            }
        }

        @Override
        public void onBroadcastStopped(int reason, int broadcastId) {
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothLeBroadcast.this.mCallbackExecutorMap.entrySet()) {
                Callback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onBroadcastStopped(reason, broadcastId));
            }
        }

        @Override
        public void onBroadcastStopFailed(int reason) {
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothLeBroadcast.this.mCallbackExecutorMap.entrySet()) {
                Callback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onBroadcastStopFailed(reason));
            }
        }

        @Override
        public void onPlaybackStarted(int reason, int broadcastId) {
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothLeBroadcast.this.mCallbackExecutorMap.entrySet()) {
                Callback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onPlaybackStarted(reason, broadcastId));
            }
        }

        @Override
        public void onPlaybackStopped(int reason, int broadcastId) {
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothLeBroadcast.this.mCallbackExecutorMap.entrySet()) {
                Callback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onPlaybackStopped(reason, broadcastId));
            }
        }

        @Override
        public void onBroadcastUpdated(int reason, int broadcastId) {
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothLeBroadcast.this.mCallbackExecutorMap.entrySet()) {
                Callback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onBroadcastUpdated(reason, broadcastId));
            }
        }

        @Override
        public void onBroadcastUpdateFailed(int reason, int broadcastId) {
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothLeBroadcast.this.mCallbackExecutorMap.entrySet()) {
                Callback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onBroadcastUpdateFailed(reason, broadcastId));
            }
        }

        @Override
        public void onBroadcastMetadataChanged(int broadcastId, BluetoothLeBroadcastMetadata metadata) {
            for (Map.Entry<Callback, Executor> callbackExecutorEntry : BluetoothLeBroadcast.this.mCallbackExecutorMap.entrySet()) {
                Callback callback = callbackExecutorEntry.getKey();
                Executor executor = callbackExecutorEntry.getValue();
                executor.execute(() -> callback.onBroadcastMetadataChanged(broadcastId, metadata));
            }
        }
    };

    BluetoothLeBroadcast(Context context, BluetoothProfile.ServiceListener listener) {
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mAttributionSource = this.mAdapter.getAttributionSource();
        this.mProfileConnector.connect(context, new BluetoothLeBroadcastServiceListener(listener));
        this.mCloseGuard = new CloseGuard();
        this.mCloseGuard.open("close");
    }

    protected void finalize() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.close();
    }

    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionState(BluetoothDevice device) {
        throw new UnsupportedOperationException("LE Audio Broadcasts are not connection-oriented.");
    }

    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        throw new UnsupportedOperationException("LE Audio Broadcasts are not connection-oriented.");
    }

    @Override
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothDevice> getConnectedDevices() {
        throw new UnsupportedOperationException("LE Audio Broadcasts are not connection-oriented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void registerCallback(Executor executor, Callback callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        BluetoothLeBroadcast.log("registerCallback");
        Map<Callback, Executor> map = this.mCallbackExecutorMap;
        synchronized (map) {
            if (this.mCallbackExecutorMap.isEmpty()) {
                if (!this.mAdapter.isEnabled()) {
                    this.mCallbackExecutorMap.put(callback, executor);
                    return;
                }
                try {
                    IBluetoothLeAudio service = this.getService();
                    if (service != null) {
                        SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                        service.registerLeBroadcastCallback(this.mCallback, this.mAttributionSource, recv);
                        recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                    }
                }
                catch (TimeoutException e) {
                    Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            if (this.mCallbackExecutorMap.containsKey(callback)) {
                throw new IllegalArgumentException("This callback has already been registered");
            }
            this.mCallbackExecutorMap.put(callback, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void unregisterCallback(Callback callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        BluetoothLeBroadcast.log("unregisterCallback");
        Map<Callback, Executor> map = this.mCallbackExecutorMap;
        synchronized (map) {
            if (this.mCallbackExecutorMap.remove(callback) == null) {
                throw new IllegalArgumentException("This callback has not been registered");
            }
        }
        if (this.mCallbackExecutorMap.isEmpty()) {
            try {
                IBluetoothLeAudio service = this.getService();
                if (service != null) {
                    SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                    service.unregisterLeBroadcastCallback(this.mCallback, this.mAttributionSource, recv);
                    recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                }
            }
            catch (IllegalStateException | TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void startBroadcast(BluetoothLeAudioContentMetadata contentMetadata, byte[] broadcastCode) {
        Objects.requireNonNull(contentMetadata, "contentMetadata cannot be null");
        if (this.mCallbackExecutorMap.isEmpty()) {
            throw new IllegalStateException("No callback was ever registered");
        }
        BluetoothLeBroadcast.log("startBroadcasting");
        IBluetoothLeAudio service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcast.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.startBroadcast(this.buildBroadcastSettingsFromMetadata(contentMetadata, broadcastCode), this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            catch (SecurityException e) {
                throw e;
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void startBroadcast(BluetoothLeBroadcastSettings broadcastSettings) {
        Objects.requireNonNull(broadcastSettings, "broadcastSettings cannot be null");
        if (this.mCallbackExecutorMap.isEmpty()) {
            throw new IllegalStateException("No callback was ever registered");
        }
        BluetoothLeBroadcast.log("startBroadcasting");
        IBluetoothLeAudio service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcast.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.startBroadcast(broadcastSettings, this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            catch (SecurityException e) {
                throw e;
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void updateBroadcast(int broadcastId, BluetoothLeAudioContentMetadata contentMetadata) {
        Objects.requireNonNull(contentMetadata, "contentMetadata cannot be null");
        if (this.mCallbackExecutorMap.isEmpty()) {
            throw new IllegalStateException("No callback was ever registered");
        }
        BluetoothLeBroadcast.log("updateBroadcast");
        IBluetoothLeAudio service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcast.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.updateBroadcast(broadcastId, this.buildBroadcastSettingsFromMetadata(contentMetadata, null), this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            catch (SecurityException e) {
                throw e;
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void updateBroadcast(int broadcastId, BluetoothLeBroadcastSettings broadcastSettings) {
        Objects.requireNonNull(broadcastSettings, "broadcastSettings cannot be null");
        if (this.mCallbackExecutorMap.isEmpty()) {
            throw new IllegalStateException("No callback was ever registered");
        }
        BluetoothLeBroadcast.log("updateBroadcast");
        IBluetoothLeAudio service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcast.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.updateBroadcast(broadcastId, broadcastSettings, this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            catch (SecurityException e) {
                throw e;
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void stopBroadcast(int broadcastId) {
        if (this.mCallbackExecutorMap.isEmpty()) {
            throw new IllegalStateException("No callback was ever registered");
        }
        BluetoothLeBroadcast.log("disableBroadcastMode");
        IBluetoothLeAudio service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcast.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.stopBroadcast(broadcastId, this.mAttributionSource, recv);
                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            catch (SecurityException e) {
                throw e;
            }
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean isPlaying(int broadcastId) {
        IBluetoothLeAudio service = this.getService();
        boolean defaultValue = false;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcast.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.isPlaying(broadcastId, this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(false);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<BluetoothLeBroadcastMetadata> getAllBroadcastMetadata() {
        IBluetoothLeAudio service = this.getService();
        List<BluetoothLeBroadcastMetadata> defaultValue = Collections.emptyList();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcast.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getAllBroadcastMetadata(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(defaultValue);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return defaultValue;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public int getMaximumNumberOfBroadcasts() {
        IBluetoothLeAudio service = this.getService();
        boolean defaultValue = true;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcast.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getMaximumNumberOfBroadcasts(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(1);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 1;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public int getMaximumStreamsPerBroadcast() {
        IBluetoothLeAudio service = this.getService();
        boolean defaultValue = true;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcast.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getMaximumStreamsPerBroadcast(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(1);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 1;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public int getMaximumSubgroupsPerBroadcast() {
        IBluetoothLeAudio service = this.getService();
        boolean defaultValue = true;
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothLeBroadcast.log(Log.getStackTraceString(new Throwable()));
        } else if (this.isEnabled()) {
            try {
                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                service.getMaximumSubgroupsPerBroadcast(this.mAttributionSource, recv);
                return recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(1);
            }
            catch (TimeoutException e) {
                Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 1;
    }

    @Override
    public void close() {
        this.mProfileConnector.disconnect();
    }

    private BluetoothLeBroadcastSettings buildBroadcastSettingsFromMetadata(BluetoothLeAudioContentMetadata contentMetadata, byte[] broadcastCode) {
        BluetoothLeBroadcastSubgroupSettings.Builder subgroupBuilder = new BluetoothLeBroadcastSubgroupSettings.Builder().setContentMetadata(contentMetadata);
        BluetoothLeBroadcastSettings.Builder builder = new BluetoothLeBroadcastSettings.Builder().setPublicBroadcast(false).setBroadcastCode(broadcastCode);
        builder.addSubgroupSettings(subgroupBuilder.build());
        return builder.build();
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private IBluetoothLeAudio getService() {
        return this.mProfileConnector.getService();
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    private class BluetoothLeBroadcastServiceListener
    extends BluetoothProfile.ForwardingServiceListener {
        BluetoothLeBroadcastServiceListener(BluetoothProfile.ServiceListener listener) {
            super(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            block12: {
                try {
                    if (profile != 26) break block12;
                    Map<Callback, Executor> map = BluetoothLeBroadcast.this.mCallbackExecutorMap;
                    synchronized (map) {
                        block13: {
                            if (!BluetoothLeBroadcast.this.mCallbackExecutorMap.isEmpty()) break block13;
                            return;
                        }
                        try {
                            IBluetoothLeAudio service = BluetoothLeBroadcast.this.getService();
                            if (service != null) {
                                SynchronousResultReceiver recv = SynchronousResultReceiver.get();
                                service.registerLeBroadcastCallback(BluetoothLeBroadcast.this.mCallback, BluetoothLeBroadcast.this.mAttributionSource, recv);
                                recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
                            }
                        }
                        catch (TimeoutException e) {
                            Log.e(BluetoothLeBroadcast.TAG, "onBluetoothServiceUp: Failed to register Le Broadcaster callback", e);
                        }
                        catch (RemoteException e) {
                            throw e.rethrowFromSystemServer();
                        }
                    }
                }
                finally {
                    super.onServiceConnected(profile, proxy);
                }
            }
        }
    }

    @SystemApi
    public static interface Callback {
        @SystemApi
        public void onBroadcastStarted(int var1, int var2);

        @SystemApi
        public void onBroadcastStartFailed(int var1);

        @SystemApi
        public void onBroadcastStopped(int var1, int var2);

        @SystemApi
        public void onBroadcastStopFailed(int var1);

        @SystemApi
        public void onPlaybackStarted(int var1, int var2);

        @SystemApi
        public void onPlaybackStopped(int var1, int var2);

        @SystemApi
        public void onBroadcastUpdated(int var1, int var2);

        @SystemApi
        public void onBroadcastUpdateFailed(int var1, int var2);

        @SystemApi
        public void onBroadcastMetadataChanged(int var1, BluetoothLeBroadcastMetadata var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Reason {
        }
    }
}

