/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SystemApi;
import android.bluetooth.BluetoothLeAudioContentMetadata;
import android.bluetooth.BluetoothLeBroadcastSubgroupSettings;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SystemApi
public class BluetoothLeBroadcastSettings
implements Parcelable {
    private final boolean mIsPublicBroadcast;
    private final String mBroadcastName;
    private final byte[] mBroadcastCode;
    private final BluetoothLeAudioContentMetadata mPublicBroadcastMetadata;
    private final List<BluetoothLeBroadcastSubgroupSettings> mSubgroupSettings;
    @SystemApi
    public static final Parcelable.Creator<BluetoothLeBroadcastSettings> CREATOR = new Parcelable.Creator<BluetoothLeBroadcastSettings>(){

        @Override
        public BluetoothLeBroadcastSettings createFromParcel(Parcel in) {
            Builder builder = new Builder();
            builder.setPublicBroadcast(in.readBoolean());
            builder.setBroadcastName(in.readString());
            int codeLen = in.readInt();
            byte[] broadcastCode = null;
            if (codeLen != -1) {
                broadcastCode = new byte[codeLen];
                if (codeLen > 0) {
                    in.readByteArray(broadcastCode);
                }
            }
            builder.setBroadcastCode(broadcastCode);
            builder.setPublicBroadcastMetadata(in.readTypedObject(BluetoothLeAudioContentMetadata.CREATOR));
            ArrayList subgroupSettings = new ArrayList();
            in.readTypedList(subgroupSettings, BluetoothLeBroadcastSubgroupSettings.CREATOR);
            for (BluetoothLeBroadcastSubgroupSettings setting : subgroupSettings) {
                builder.addSubgroupSettings(setting);
            }
            return builder.build();
        }

        public BluetoothLeBroadcastSettings[] newArray(int size) {
            return new BluetoothLeBroadcastSettings[size];
        }
    };

    private BluetoothLeBroadcastSettings(boolean isPublicBroadcast, String broadcastName, byte[] broadcastCode, BluetoothLeAudioContentMetadata publicBroadcastMetadata, List<BluetoothLeBroadcastSubgroupSettings> subgroupSettings) {
        this.mIsPublicBroadcast = isPublicBroadcast;
        this.mBroadcastName = broadcastName;
        this.mBroadcastCode = broadcastCode;
        this.mPublicBroadcastMetadata = publicBroadcastMetadata;
        this.mSubgroupSettings = subgroupSettings;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BluetoothLeBroadcastSettings)) {
            return false;
        }
        BluetoothLeBroadcastSettings other = (BluetoothLeBroadcastSettings)o;
        return this.mIsPublicBroadcast == other.isPublicBroadcast() && Objects.equals(this.mBroadcastName, other.getBroadcastName()) && Arrays.equals(this.mBroadcastCode, other.getBroadcastCode()) && Objects.equals(this.mPublicBroadcastMetadata, other.getPublicBroadcastMetadata()) && this.mSubgroupSettings.equals(other.getSubgroupSettings());
    }

    public int hashCode() {
        return Objects.hash(this.mIsPublicBroadcast, this.mBroadcastName, Arrays.hashCode(this.mBroadcastCode), this.mPublicBroadcastMetadata, this.mSubgroupSettings);
    }

    @SystemApi
    public boolean isPublicBroadcast() {
        return this.mIsPublicBroadcast;
    }

    @SystemApi
    public String getBroadcastName() {
        return this.mBroadcastName;
    }

    @SystemApi
    public byte[] getBroadcastCode() {
        return this.mBroadcastCode;
    }

    @SystemApi
    public BluetoothLeAudioContentMetadata getPublicBroadcastMetadata() {
        return this.mPublicBroadcastMetadata;
    }

    @SystemApi
    public List<BluetoothLeBroadcastSubgroupSettings> getSubgroupSettings() {
        return this.mSubgroupSettings;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeBoolean(this.mIsPublicBroadcast);
        out.writeString(this.mBroadcastName);
        if (this.mBroadcastCode != null) {
            out.writeInt(this.mBroadcastCode.length);
            out.writeByteArray(this.mBroadcastCode);
        } else {
            out.writeInt(-1);
        }
        out.writeTypedObject(this.mPublicBroadcastMetadata, 0);
        out.writeTypedList(this.mSubgroupSettings);
    }

    @SystemApi
    public static class Builder {
        private boolean mIsPublicBroadcast = false;
        private String mBroadcastName = null;
        private byte[] mBroadcastCode = null;
        private BluetoothLeAudioContentMetadata mPublicBroadcastMetadata = null;
        private List<BluetoothLeBroadcastSubgroupSettings> mSubgroupSettings = new ArrayList<BluetoothLeBroadcastSubgroupSettings>();

        @SystemApi
        public Builder() {
        }

        @SystemApi
        public Builder(BluetoothLeBroadcastSettings original) {
            this.mIsPublicBroadcast = original.isPublicBroadcast();
            this.mBroadcastName = original.getBroadcastName();
            this.mBroadcastCode = original.getBroadcastCode();
            this.mPublicBroadcastMetadata = original.getPublicBroadcastMetadata();
            this.mSubgroupSettings = original.getSubgroupSettings();
        }

        @SystemApi
        public Builder setPublicBroadcast(boolean isPublicBroadcast) {
            this.mIsPublicBroadcast = isPublicBroadcast;
            return this;
        }

        @SystemApi
        public Builder setBroadcastName(String broadcastName) {
            this.mBroadcastName = broadcastName;
            return this;
        }

        @SystemApi
        public Builder setBroadcastCode(byte[] broadcastCode) {
            this.mBroadcastCode = broadcastCode;
            return this;
        }

        @SystemApi
        public Builder setPublicBroadcastMetadata(BluetoothLeAudioContentMetadata publicBroadcastMetadata) {
            this.mPublicBroadcastMetadata = publicBroadcastMetadata;
            return this;
        }

        @SystemApi
        public Builder addSubgroupSettings(BluetoothLeBroadcastSubgroupSettings subgroupSettings) {
            Objects.requireNonNull(subgroupSettings, "subgroupSettings cannot be null");
            this.mSubgroupSettings.add(subgroupSettings);
            return this;
        }

        @SystemApi
        public Builder clearSubgroupSettings() {
            this.mSubgroupSettings.clear();
            return this;
        }

        @SystemApi
        public BluetoothLeBroadcastSettings build() {
            if (this.mSubgroupSettings.isEmpty()) {
                throw new IllegalArgumentException("Must contain at least one subgroup");
            }
            return new BluetoothLeBroadcastSettings(this.mIsPublicBroadcast, this.mBroadcastName, this.mBroadcastCode, this.mPublicBroadcastMetadata, this.mSubgroupSettings);
        }
    }
}

