/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SystemApi;
import android.bluetooth.BluetoothLeAudioContentMetadata;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class BluetoothLeBroadcastSubgroupSettings
implements Parcelable {
    private final int mPreferredQuality;
    private final BluetoothLeAudioContentMetadata mContentMetadata;
    @SystemApi
    public static final int QUALITY_STANDARD = 0;
    @SystemApi
    public static final int QUALITY_HIGH = 1;
    @SystemApi
    public static final Parcelable.Creator<BluetoothLeBroadcastSubgroupSettings> CREATOR = new Parcelable.Creator<BluetoothLeBroadcastSubgroupSettings>(){

        @Override
        public BluetoothLeBroadcastSubgroupSettings createFromParcel(Parcel in) {
            Builder builder = new Builder();
            builder.setPreferredQuality(in.readInt());
            builder.setContentMetadata(in.readTypedObject(BluetoothLeAudioContentMetadata.CREATOR));
            return builder.build();
        }

        public BluetoothLeBroadcastSubgroupSettings[] newArray(int size) {
            return new BluetoothLeBroadcastSubgroupSettings[size];
        }
    };

    private BluetoothLeBroadcastSubgroupSettings(int preferredQuality, BluetoothLeAudioContentMetadata contentMetadata) {
        this.mPreferredQuality = preferredQuality;
        this.mContentMetadata = contentMetadata;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BluetoothLeBroadcastSubgroupSettings)) {
            return false;
        }
        BluetoothLeBroadcastSubgroupSettings other = (BluetoothLeBroadcastSubgroupSettings)o;
        return this.mPreferredQuality == other.getPreferredQuality() && this.mContentMetadata.equals(other.getContentMetadata());
    }

    public int hashCode() {
        return Objects.hash(this.mPreferredQuality, this.mContentMetadata);
    }

    @SystemApi
    public BluetoothLeAudioContentMetadata getContentMetadata() {
        return this.mContentMetadata;
    }

    @SystemApi
    public int getPreferredQuality() {
        return this.mPreferredQuality;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mPreferredQuality);
        out.writeTypedObject(this.mContentMetadata, 0);
    }

    @SystemApi
    public static class Builder {
        private BluetoothLeAudioContentMetadata mContentMetadata = null;
        private int mPreferredQuality = 0;

        @SystemApi
        public Builder() {
        }

        @SystemApi
        public Builder(BluetoothLeBroadcastSubgroupSettings original) {
            this.mPreferredQuality = original.getPreferredQuality();
            this.mContentMetadata = original.getContentMetadata();
        }

        @SystemApi
        public Builder setPreferredQuality(int preferredQuality) {
            this.mPreferredQuality = preferredQuality;
            return this;
        }

        @SystemApi
        public Builder setContentMetadata(BluetoothLeAudioContentMetadata contentMetadata) {
            Objects.requireNonNull(contentMetadata, "contentMetadata cannot be null");
            this.mContentMetadata = contentMetadata;
            return this;
        }

        @SystemApi
        public BluetoothLeBroadcastSubgroupSettings build() {
            Objects.requireNonNull(this.mContentMetadata, "ContentMetadata is null");
            if (this.mPreferredQuality != 0 && this.mPreferredQuality != 1) {
                throw new IllegalArgumentException("Must set audio quality to either Standard or High");
            }
            return new BluetoothLeBroadcastSubgroupSettings(this.mPreferredQuality, this.mContentMetadata);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Quality {
    }
}

