/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothLeCall;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.IBluetoothLeCallControl;
import android.bluetooth.IBluetoothLeCallControlCallback;
import android.content.AttributionSource;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;

public class BluetoothLeCallControl
implements BluetoothProfile {
    private static final String TAG = "BluetoothLeCallControl";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_ERROR_UNKNOWN_CALL_ID = 1;
    public static final int RESULT_ERROR_INVALID_URI = 2;
    public static final int RESULT_ERROR_APPLICATION = 3;
    public static final int TERMINATION_REASON_INVALID_URI = 0;
    public static final int TERMINATION_REASON_FAIL = 1;
    public static final int TERMINATION_REASON_REMOTE_HANGUP = 2;
    public static final int TERMINATION_REASON_SERVER_HANGUP = 3;
    public static final int TERMINATION_REASON_LINE_BUSY = 4;
    public static final int TERMINATION_REASON_NETWORK_CONGESTION = 5;
    public static final int TERMINATION_REASON_CLIENT_HANGUP = 6;
    public static final int TERMINATION_REASON_NO_SERVICE = 7;
    public static final int TERMINATION_REASON_NO_ANSWER = 8;
    public static final int CAPABILITY_HOLD_CALL = 1;
    public static final int CAPABILITY_JOIN_CALLS = 2;
    private static final int REG_TIMEOUT = 10000;
    private BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private int mCcid = 0;
    private String mToken;
    private Callback mCallback = null;
    private final BluetoothProfileConnector<IBluetoothLeCallControl> mProfileConnector = new BluetoothProfileConnector(this, 27, "BluetoothLeCallControl", IBluetoothLeCallControl.class.getName()){

        public IBluetoothLeCallControl getServiceInterface(IBinder service) {
            return IBluetoothLeCallControl.Stub.asInterface(service);
        }
    };

    BluetoothLeCallControl(Context context, BluetoothProfile.ServiceListener listener) {
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mAttributionSource = this.mAdapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener);
    }

    @Override
    public void close() {
        this.unregisterBearer();
        this.mProfileConnector.disconnect();
    }

    private IBluetoothLeCallControl getService() {
        return this.mProfileConnector.getService();
    }

    @Override
    public int getConnectionState(BluetoothDevice device) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        throw new UnsupportedOperationException("not supported");
    }

    @SuppressLint(value={"ExecutorRegistration"})
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public boolean registerBearer(String uci, List<String> uriSchemes, int capabilities, String provider, int technology, Executor executor, Callback callback) {
        Log.d(TAG, "registerBearer");
        if (callback == null) {
            throw new IllegalArgumentException("null parameter: " + callback);
        }
        if (this.mCcid != 0) {
            return false;
        }
        this.mToken = uci;
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return false;
        }
        if (this.mCallback != null) {
            Log.e(TAG, "Bearer can be opened only once");
            return false;
        }
        this.mCallback = callback;
        try {
            CallbackWrapper callbackWrapper = new CallbackWrapper(executor, callback);
            service.registerBearer(this.mToken, callbackWrapper, uci, uriSchemes, capabilities, provider, technology, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            this.mCallback = null;
            return false;
        }
        if (this.mCcid == 0) {
            this.mCallback = null;
            return false;
        }
        return true;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void unregisterBearer() {
        Log.d(TAG, "unregisterBearer");
        if (this.mCcid == 0) {
            return;
        }
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
        int ccid = this.mCcid;
        this.mCcid = 0;
        this.mCallback = null;
        try {
            service.unregisterBearer(this.mToken, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public int getContentControlId() {
        return this.mCcid;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onCallAdded(BluetoothLeCall call) {
        Log.d(TAG, "onCallAdded: call=" + call);
        if (this.mCcid == 0) {
            return;
        }
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
        try {
            service.callAdded(this.mCcid, call, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onCallRemoved(UUID callId, int reason) {
        Log.d(TAG, "callRemoved: callId=" + callId);
        if (this.mCcid == 0) {
            return;
        }
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
        try {
            service.callRemoved(this.mCcid, new ParcelUuid(callId), reason, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onCallStateChanged(UUID callId, int state) {
        Log.d(TAG, "callStateChanged: callId=" + callId + " state=" + state);
        if (this.mCcid == 0) {
            return;
        }
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
        try {
            service.callStateChanged(this.mCcid, new ParcelUuid(callId), state, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void currentCallsList(List<BluetoothLeCall> calls) {
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
        try {
            service.currentCallsList(this.mCcid, calls, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void networkStateChanged(String provider, int technology) {
        Log.d(TAG, "networkStateChanged: provider=" + provider + ", technology=" + technology);
        if (this.mCcid == 0) {
            return;
        }
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
        try {
            service.networkStateChanged(this.mCcid, provider, technology, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void requestResult(int requestId, int result) {
        Log.d(TAG, "requestResult: requestId=" + requestId + " result=" + result);
        if (this.mCcid == 0) {
            return;
        }
        IBluetoothLeCallControl service = this.getService();
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
        try {
            service.requestResult(this.mCcid, requestId, result, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    private static boolean isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    public static abstract class Callback {
        private static final String TAG = "BluetoothLeCallControl.Callback";

        public abstract void onAcceptCall(int var1, UUID var2);

        public abstract void onTerminateCall(int var1, UUID var2);

        public void onHoldCall(int requestId, UUID callId) {
            Log.e(TAG, "onHoldCall: unimplemented, however CAPABILITY_HOLD_CALL is set!");
        }

        public void onUnholdCall(int requestId, UUID callId) {
            Log.e(TAG, "onUnholdCall: unimplemented, however CAPABILITY_HOLD_CALL is set!");
        }

        public abstract void onPlaceCall(int var1, UUID var2, String var3);

        public void onJoinCalls(int requestId, List<UUID> callIds) {
            Log.e(TAG, "onJoinCalls: unimplemented, however CAPABILITY_JOIN_CALLS is set!");
        }
    }

    private class CallbackWrapper
    extends IBluetoothLeCallControlCallback.Stub {
        private final Executor mExecutor;
        private final Callback mCallback;

        CallbackWrapper(Executor executor, Callback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onBearerRegistered(int ccid) {
            if (this.mCallback != null) {
                BluetoothLeCallControl.this.mCcid = ccid;
            } else {
                Log.e(BluetoothLeCallControl.TAG, "onBearerRegistered: mCallback is null");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAcceptCall(int requestId, ParcelUuid uuid) {
            long identityToken = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onAcceptCall(requestId, uuid.getUuid()));
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTerminateCall(int requestId, ParcelUuid uuid) {
            long identityToken = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onTerminateCall(requestId, uuid.getUuid()));
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onHoldCall(int requestId, ParcelUuid uuid) {
            long identityToken = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onHoldCall(requestId, uuid.getUuid()));
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUnholdCall(int requestId, ParcelUuid uuid) {
            long identityToken = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onUnholdCall(requestId, uuid.getUuid()));
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPlaceCall(int requestId, ParcelUuid uuid, String uri) {
            long identityToken = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onPlaceCall(requestId, uuid.getUuid(), uri));
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onJoinCalls(int requestId, List<ParcelUuid> parcelUuids) {
            ArrayList<UUID> uuids = new ArrayList<UUID>();
            for (ParcelUuid parcelUuid : parcelUuids) {
                uuids.add(parcelUuid.getUuid());
            }
            long identityToken = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onJoinCalls(requestId, uuids));
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TerminationReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Result {
    }
}

