/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothDevice;
import android.compat.annotation.UnsupportedAppUsage;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public interface BluetoothProfile {
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_STATE = "android.bluetooth.profile.extra.STATE";
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.profile.extra.PREVIOUS_STATE";
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_DISCONNECTING = 3;
    public static final int HEADSET = 1;
    public static final int A2DP = 2;
    @Deprecated
    public static final int HEALTH = 3;
    @SystemApi
    public static final int HID_HOST = 4;
    @SystemApi
    public static final int PAN = 5;
    @SystemApi
    public static final int PBAP = 6;
    public static final int GATT = 7;
    public static final int GATT_SERVER = 8;
    @SystemApi
    public static final int MAP = 9;
    public static final int SAP = 10;
    @SystemApi
    public static final int A2DP_SINK = 11;
    @SystemApi
    public static final int AVRCP_CONTROLLER = 12;
    public static final int AVRCP = 13;
    @SystemApi
    public static final int HEADSET_CLIENT = 16;
    @SystemApi
    public static final int PBAP_CLIENT = 17;
    @SystemApi
    public static final int MAP_CLIENT = 18;
    public static final int HID_DEVICE = 19;
    @SystemApi
    public static final int OPP = 20;
    public static final int HEARING_AID = 21;
    public static final int LE_AUDIO = 22;
    @SystemApi
    public static final int VOLUME_CONTROL = 23;
    public static final int MCP_SERVER = 24;
    public static final int CSIP_SET_COORDINATOR = 25;
    @SystemApi
    public static final int LE_AUDIO_BROADCAST = 26;
    public static final int LE_CALL_CONTROL = 27;
    public static final int HAP_CLIENT = 28;
    @SystemApi
    public static final int LE_AUDIO_BROADCAST_ASSISTANT = 29;
    public static final int BATTERY = 30;
    public static final int MAX_PROFILE_ID = 30;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int PRIORITY_AUTO_CONNECT = 1000;
    @Deprecated
    @SystemApi
    public static final int PRIORITY_ON = 100;
    @Deprecated
    @SystemApi
    public static final int PRIORITY_OFF = 0;
    @UnsupportedAppUsage
    public static final int PRIORITY_UNDEFINED = -1;
    @SystemApi
    public static final int CONNECTION_POLICY_ALLOWED = 100;
    @SystemApi
    public static final int CONNECTION_POLICY_FORBIDDEN = 0;
    @SystemApi
    public static final int CONNECTION_POLICY_UNKNOWN = -1;

    public List<BluetoothDevice> getConnectedDevices();

    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] var1);

    public int getConnectionState(BluetoothDevice var1);

    public void close();

    @SystemApi
    @RequiresNoPermission
    public static String getConnectionStateName(int connectionState) {
        switch (connectionState) {
            case 0: {
                return "STATE_DISCONNECTED";
            }
            case 1: {
                return "STATE_CONNECTING";
            }
            case 2: {
                return "STATE_CONNECTED";
            }
            case 3: {
                return "STATE_DISCONNECTING";
            }
        }
        return "STATE_UNKNOWN";
    }

    @SystemApi
    @RequiresNoPermission
    public static String getProfileName(int profile) {
        switch (profile) {
            case 1: {
                return "HEADSET";
            }
            case 2: {
                return "A2DP";
            }
            case 4: {
                return "HID_HOST";
            }
            case 5: {
                return "PAN";
            }
            case 6: {
                return "PBAP";
            }
            case 7: {
                return "GATT";
            }
            case 8: {
                return "GATT_SERVER";
            }
            case 9: {
                return "MAP";
            }
            case 10: {
                return "SAP";
            }
            case 11: {
                return "A2DP_SINK";
            }
            case 12: {
                return "AVRCP_CONTROLLER";
            }
            case 13: {
                return "AVRCP";
            }
            case 16: {
                return "HEADSET_CLIENT";
            }
            case 17: {
                return "PBAP_CLIENT";
            }
            case 18: {
                return "MAP_CLIENT";
            }
            case 19: {
                return "HID_DEVICE";
            }
            case 20: {
                return "OPP";
            }
            case 21: {
                return "HEARING_AID";
            }
            case 22: {
                return "LE_AUDIO";
            }
            case 23: {
                return "VOLUME_CONTROL";
            }
            case 24: {
                return "MCP_SERVER";
            }
            case 25: {
                return "CSIP_SET_COORDINATOR";
            }
            case 26: {
                return "LE_AUDIO_BROADCAST";
            }
            case 27: {
                return "LE_CALL_CONTROL";
            }
            case 28: {
                return "HAP_CLIENT";
            }
            case 29: {
                return "LE_AUDIO_BROADCAST_ASSISTANT";
            }
            case 30: {
                return "BATTERY";
            }
        }
        return "UNKNOWN_PROFILE";
    }

    public static class ForwardingServiceListener
    implements ServiceListener {
        private final ServiceListener mListener;

        ForwardingServiceListener(ServiceListener listener) {
            this.mListener = listener;
        }

        @Override
        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (this.mListener != null) {
                this.mListener.onServiceConnected(profile, proxy);
            }
        }

        @Override
        public void onServiceDisconnected(int profile) {
            if (this.mListener != null) {
                this.mListener.onServiceDisconnected(profile);
            }
        }
    }

    public static interface ServiceListener {
        @RequiresNoPermission
        public void onServiceConnected(int var1, BluetoothProfile var2);

        @RequiresNoPermission
        public void onServiceDisconnected(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BtProfileState {
    }
}

