/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothProfileServiceConnection;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.CloseGuard;
import android.util.Log;
import java.util.List;

@SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
public abstract class BluetoothProfileConnector<T> {
    private final CloseGuard mCloseGuard = new CloseGuard();
    private final int mProfileId;
    private BluetoothProfile.ServiceListener mServiceListener;
    private final BluetoothProfile mProfileProxy;
    private Context mContext;
    private final String mProfileName;
    private final String mServiceName;
    private volatile T mService;
    private static final UserHandle USER_HANDLE_CURRENT_OR_SELF = UserHandle.of(-3);
    private static final int MESSAGE_SERVICE_CONNECTED = 100;
    private static final int MESSAGE_SERVICE_DISCONNECTED = 101;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        @Override
        public void onBluetoothStateChange(boolean up) {
            if (up) {
                BluetoothProfileConnector.this.doBind();
            } else {
                BluetoothProfileConnector.this.doUnbind();
            }
        }
    };
    private final IBluetoothProfileServiceConnection mConnection = new IBluetoothProfileServiceConnection.Stub(){

        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            BluetoothProfileConnector.this.logDebug("Proxy object connected");
            BluetoothProfileConnector.this.mService = BluetoothProfileConnector.this.getServiceInterface(service);
            BluetoothProfileConnector.this.mHandler.sendMessage(BluetoothProfileConnector.this.mHandler.obtainMessage(100));
        }

        @Override
        public void onServiceDisconnected(ComponentName className) {
            BluetoothProfileConnector.this.logDebug("Proxy object disconnected");
            BluetoothProfileConnector.this.doUnbind();
            BluetoothProfileConnector.this.mHandler.sendMessage(BluetoothProfileConnector.this.mHandler.obtainMessage(101));
        }
    };
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    if (BluetoothProfileConnector.this.mServiceListener == null) break;
                    BluetoothProfileConnector.this.mServiceListener.onServiceConnected(BluetoothProfileConnector.this.mProfileId, BluetoothProfileConnector.this.mProfileProxy);
                    break;
                }
                case 101: {
                    if (BluetoothProfileConnector.this.mServiceListener == null) break;
                    BluetoothProfileConnector.this.mServiceListener.onServiceDisconnected(BluetoothProfileConnector.this.mProfileId);
                }
            }
        }
    };

    private ComponentName resolveSystemService(Intent intent, PackageManager pm) {
        List<ResolveInfo> results = pm.queryIntentServices(intent, PackageManager.ResolveInfoFlags.of(0L));
        if (results == null) {
            return null;
        }
        ComponentName comp = null;
        for (int i = 0; i < results.size(); ++i) {
            ResolveInfo ri = results.get(i);
            if ((ri.serviceInfo.applicationInfo.flags & 1) == 0) continue;
            ComponentName foundComp = new ComponentName(ri.serviceInfo.applicationInfo.packageName, ri.serviceInfo.name);
            if (comp != null) {
                throw new IllegalStateException("Multiple system services handle " + intent + ": " + comp + ", " + foundComp);
            }
            comp = foundComp;
        }
        return comp;
    }

    BluetoothProfileConnector(BluetoothProfile profile, int profileId, String profileName, String serviceName) {
        this.mProfileId = profileId;
        this.mProfileProxy = profile;
        this.mProfileName = profileName;
        this.mServiceName = serviceName;
    }

    public void finalize() {
        this.mCloseGuard.warnIfOpen();
        this.doUnbind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doBind() {
        IBluetoothProfileServiceConnection iBluetoothProfileServiceConnection = this.mConnection;
        synchronized (iBluetoothProfileServiceConnection) {
            if (this.mService == null) {
                this.logDebug("Binding service...");
                this.mCloseGuard.open("doUnbind");
                try {
                    return BluetoothAdapter.getDefaultAdapter().getBluetoothManager().bindBluetoothProfileService(this.mProfileId, this.mServiceName, this.mConnection);
                }
                catch (RemoteException re) {
                    this.logError("Failed to bind service. " + re);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnbind() {
        IBluetoothProfileServiceConnection iBluetoothProfileServiceConnection = this.mConnection;
        synchronized (iBluetoothProfileServiceConnection) {
            if (this.mService != null) {
                this.logDebug("Unbinding service...");
                this.mCloseGuard.close();
                try {
                    BluetoothAdapter.getDefaultAdapter().getBluetoothManager().unbindBluetoothProfileService(this.mProfileId, this.mConnection);
                }
                catch (RemoteException re) {
                    this.logError("Unable to unbind service: " + re);
                }
                finally {
                    this.mService = null;
                }
            }
        }
    }

    void connect(Context context, BluetoothProfile.ServiceListener listener) {
        this.mContext = context;
        this.mServiceListener = listener;
        IBluetoothManager mgr = BluetoothAdapter.getDefaultAdapter().getBluetoothManager();
        if (context.getApplicationInfo().targetSdkVersion <= 30 && context.checkSelfPermission("android.permission.BLUETOOTH") != 0) {
            throw new SecurityException("Need BLUETOOTH permission");
        }
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException re) {
                this.logError("Failed to register state change callback. " + re);
            }
        }
        this.doBind();
    }

    void disconnect() {
        IBluetoothManager mgr;
        if (this.mServiceListener != null) {
            BluetoothProfile.ServiceListener listener = this.mServiceListener;
            this.mServiceListener = null;
            listener.onServiceDisconnected(this.mProfileId);
        }
        if ((mgr = BluetoothAdapter.getDefaultAdapter().getBluetoothManager()) != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException re) {
                this.logError("Failed to unregister state change callback" + re);
            }
        }
        this.doUnbind();
    }

    T getService() {
        return this.mService;
    }

    public abstract T getServiceInterface(IBinder var1);

    private void logDebug(String log) {
        Log.d(this.mProfileName, log);
    }

    private void logError(String log) {
        Log.e(this.mProfileName, log);
    }
}

