/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

@SystemApi
public class BluetoothQualityReport
implements Parcelable {
    private static final String TAG = "BluetoothQualityReport";
    @SystemApi
    public static final int QUALITY_REPORT_ID_MONITOR = 1;
    @SystemApi
    public static final int QUALITY_REPORT_ID_APPROACH_LSTO = 2;
    @SystemApi
    public static final int QUALITY_REPORT_ID_A2DP_CHOPPY = 3;
    @SystemApi
    public static final int QUALITY_REPORT_ID_SCO_CHOPPY = 4;
    @SystemApi
    public static final int QUALITY_REPORT_ID_CONN_FAIL = 8;
    private String mAddr;
    private int mLmpVer;
    private int mLmpSubVer;
    private int mManufacturerId;
    private String mName;
    private BluetoothClass mBluetoothClass;
    private BqrCommon mBqrCommon;
    private BqrVsLsto mBqrVsLsto;
    private BqrVsA2dpChoppy mBqrVsA2dpChoppy;
    private BqrVsScoChoppy mBqrVsScoChoppy;
    private BqrConnectFail mBqrConnectFail;
    @SystemApi
    public static final Parcelable.Creator<BluetoothQualityReport> CREATOR = new Parcelable.Creator<BluetoothQualityReport>(){

        @Override
        public BluetoothQualityReport createFromParcel(Parcel in) {
            return new BluetoothQualityReport(in);
        }

        public BluetoothQualityReport[] newArray(int size) {
            return new BluetoothQualityReport[size];
        }
    };

    private BluetoothQualityReport(String remoteAddr, int lmpVer, int lmpSubVer, int manufacturerId, String remoteName, BluetoothClass bluetoothClass, byte[] rawData) {
        this.mAddr = remoteAddr;
        this.mLmpVer = lmpVer;
        this.mLmpSubVer = lmpSubVer;
        this.mManufacturerId = manufacturerId;
        this.mName = remoteName;
        this.mBluetoothClass = bluetoothClass;
        this.mBqrCommon = new BqrCommon(rawData, 0);
        int id2 = this.mBqrCommon.getQualityReportId();
        if (id2 == 1) {
            return;
        }
        int vsPartOffset = 55;
        if (id2 == 2) {
            this.mBqrVsLsto = new BqrVsLsto(rawData, vsPartOffset);
        } else if (id2 == 3) {
            this.mBqrVsA2dpChoppy = new BqrVsA2dpChoppy(rawData, vsPartOffset);
        } else if (id2 == 4) {
            this.mBqrVsScoChoppy = new BqrVsScoChoppy(rawData, vsPartOffset);
        } else if (id2 == 8) {
            this.mBqrConnectFail = new BqrConnectFail(rawData, vsPartOffset);
        } else {
            throw new IllegalArgumentException("BluetoothQualityReport: unknown quality report id:" + id2);
        }
    }

    private BluetoothQualityReport(Parcel in) {
        this.mAddr = in.readString();
        this.mLmpVer = in.readInt();
        this.mLmpSubVer = in.readInt();
        this.mManufacturerId = in.readInt();
        this.mName = in.readString();
        this.mBluetoothClass = new BluetoothClass(in.readInt());
        this.mBqrCommon = new BqrCommon(in);
        int id2 = this.mBqrCommon.getQualityReportId();
        if (id2 == 2) {
            this.mBqrVsLsto = new BqrVsLsto(in);
        } else if (id2 == 3) {
            this.mBqrVsA2dpChoppy = new BqrVsA2dpChoppy(in);
        } else if (id2 == 4) {
            this.mBqrVsScoChoppy = new BqrVsScoChoppy(in);
        } else if (id2 == 8) {
            this.mBqrConnectFail = new BqrConnectFail(in);
        }
    }

    @SystemApi
    public int getQualityReportId() {
        return this.mBqrCommon.getQualityReportId();
    }

    @SystemApi
    public static String qualityReportIdToString(int id2) {
        return BqrCommon.qualityReportIdToString(id2);
    }

    @SystemApi
    public String getRemoteAddress() {
        return this.mAddr;
    }

    @SystemApi
    public int getLmpVersion() {
        return this.mLmpVer;
    }

    @SystemApi
    public int getLmpSubVersion() {
        return this.mLmpSubVer;
    }

    @SystemApi
    public int getManufacturerId() {
        return this.mManufacturerId;
    }

    @SystemApi
    public String getRemoteName() {
        return this.mName;
    }

    @SystemApi
    public BluetoothClass getBluetoothClass() {
        return this.mBluetoothClass;
    }

    @SystemApi
    public BqrCommon getBqrCommon() {
        return this.mBqrCommon;
    }

    @SystemApi
    public Parcelable getBqrEvent() {
        if (this.mBqrCommon == null) {
            return null;
        }
        switch (this.mBqrCommon.getQualityReportId()) {
            case 1: {
                return this.mBqrCommon;
            }
            case 2: {
                return this.mBqrVsLsto;
            }
            case 3: {
                return this.mBqrVsA2dpChoppy;
            }
            case 4: {
                return this.mBqrVsScoChoppy;
            }
            case 8: {
                return this.mBqrConnectFail;
            }
        }
        return null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    @SystemApi
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mAddr);
        out.writeInt(this.mLmpVer);
        out.writeInt(this.mLmpSubVer);
        out.writeInt(this.mManufacturerId);
        out.writeString(this.mName);
        out.writeInt(this.mBluetoothClass.getClassOfDevice());
        this.mBqrCommon.writeToParcel(out, flags);
        int id2 = this.mBqrCommon.getQualityReportId();
        if (id2 == 2) {
            this.mBqrVsLsto.writeToParcel(out, flags);
        } else if (id2 == 3) {
            this.mBqrVsA2dpChoppy.writeToParcel(out, flags);
        } else if (id2 == 4) {
            this.mBqrVsScoChoppy.writeToParcel(out, flags);
        } else if (id2 == 8) {
            this.mBqrConnectFail.writeToParcel(out, flags);
        }
    }

    public String toString() {
        String str = "BQR: {\n  mAddr: " + this.mAddr + ", mLmpVer: " + String.format("0x%02X", this.mLmpVer) + ", mLmpSubVer: " + String.format("0x%04X", this.mLmpSubVer) + ", mManufacturerId: " + String.format("0x%04X", this.mManufacturerId) + ", mName: " + this.mName + ", mBluetoothClass: " + this.mBluetoothClass.toString() + ",\n" + this.mBqrCommon + "\n";
        int id2 = this.mBqrCommon.getQualityReportId();
        if (id2 == 2) {
            str = str + this.mBqrVsLsto + "\n}";
        } else if (id2 == 3) {
            str = str + this.mBqrVsA2dpChoppy + "\n}";
        } else if (id2 == 4) {
            str = str + this.mBqrVsScoChoppy + "\n}";
        } else if (id2 == 8) {
            str = str + this.mBqrConnectFail + "\n}";
        } else if (id2 == 1) {
            str = str + "}";
        }
        return str;
    }

    @SystemApi
    public static class BqrCommon
    implements Parcelable {
        private static final String TAG = "BluetoothQualityReport.BqrCommon";
        static final int BQR_COMMON_LEN = 55;
        private int mQualityReportId;
        private int mPacketType;
        private int mConnectionHandle;
        private int mConnectionRole;
        private int mTxPowerLevel;
        private int mRssi;
        private int mSnr;
        private int mUnusedAfhChannelCount;
        private int mAfhSelectUnidealChannelCount;
        private int mLsto;
        private long mPiconetClock;
        private long mRetransmissionCount;
        private long mNoRxCount;
        private long mNakCount;
        private long mLastTxAckTimestamp;
        private long mFlowOffCount;
        private long mLastFlowOnTimestamp;
        private long mOverflowCount;
        private long mUnderflowCount;
        private String mAddr;
        private int mCalFailedItemCount;
        @SystemApi
        public static final int CONNECTION_ROLE_CENTRAL = 0;
        @SystemApi
        public static final int CONNECTION_ROLE_PERIPHERAL = 1;
        @SystemApi
        public static final Parcelable.Creator<BqrCommon> CREATOR = new Parcelable.Creator<BqrCommon>(){

            @Override
            public BqrCommon createFromParcel(Parcel in) {
                return new BqrCommon(in);
            }

            public BqrCommon[] newArray(int size) {
                return new BqrCommon[size];
            }
        };

        private BqrCommon(byte[] rawData, int offset) {
            if (rawData == null || rawData.length < offset + 55) {
                throw new IllegalArgumentException("BluetoothQualityReport.BqrCommon: BQR raw data length is abnormal.");
            }
            ByteBuffer bqrBuf = ByteBuffer.wrap(rawData, offset, rawData.length - offset).asReadOnlyBuffer();
            bqrBuf.order(ByteOrder.LITTLE_ENDIAN);
            this.mQualityReportId = bqrBuf.get() & 0xFF;
            this.mPacketType = bqrBuf.get() & 0xFF;
            this.mConnectionHandle = bqrBuf.getShort() & 0xFFFF;
            this.mConnectionRole = bqrBuf.get() & 0xFF;
            this.mTxPowerLevel = bqrBuf.get() & 0xFF;
            this.mRssi = bqrBuf.get();
            this.mSnr = bqrBuf.get();
            this.mUnusedAfhChannelCount = bqrBuf.get() & 0xFF;
            this.mAfhSelectUnidealChannelCount = bqrBuf.get() & 0xFF;
            this.mLsto = bqrBuf.getShort() & 0xFFFF;
            this.mPiconetClock = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mRetransmissionCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mNoRxCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mNakCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mLastTxAckTimestamp = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mFlowOffCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mLastFlowOnTimestamp = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mOverflowCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mUnderflowCount = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            int currentOffset = bqrBuf.position();
            this.mAddr = String.format("%02X:%02X:%02X:%02X:%02X:%02X", bqrBuf.get(currentOffset + 5), bqrBuf.get(currentOffset + 4), bqrBuf.get(currentOffset + 3), bqrBuf.get(currentOffset + 2), bqrBuf.get(currentOffset + 1), bqrBuf.get(currentOffset + 0));
            bqrBuf.position(currentOffset + 6);
            this.mCalFailedItemCount = bqrBuf.get() & 0xFF;
        }

        private BqrCommon(Parcel in) {
            this.mQualityReportId = in.readInt();
            this.mPacketType = in.readInt();
            this.mConnectionHandle = in.readInt();
            this.mConnectionRole = in.readInt();
            this.mTxPowerLevel = in.readInt();
            this.mRssi = in.readInt();
            this.mSnr = in.readInt();
            this.mUnusedAfhChannelCount = in.readInt();
            this.mAfhSelectUnidealChannelCount = in.readInt();
            this.mLsto = in.readInt();
            this.mPiconetClock = in.readLong();
            this.mRetransmissionCount = in.readLong();
            this.mNoRxCount = in.readLong();
            this.mNakCount = in.readLong();
            this.mLastTxAckTimestamp = in.readLong();
            this.mFlowOffCount = in.readLong();
            this.mLastFlowOnTimestamp = in.readLong();
            this.mOverflowCount = in.readLong();
            this.mUnderflowCount = in.readLong();
            this.mAddr = in.readString();
            this.mCalFailedItemCount = in.readInt();
        }

        int getQualityReportId() {
            return this.mQualityReportId;
        }

        static String qualityReportIdToString(int id2) {
            switch (id2) {
                case 1: {
                    return "Quality monitor";
                }
                case 2: {
                    return "Approaching LSTO";
                }
                case 3: {
                    return "A2DP choppy";
                }
                case 4: {
                    return "SCO choppy";
                }
                case 8: {
                    return "Connect fail";
                }
            }
            return "INVALID";
        }

        @SystemApi
        public int getPacketType() {
            return this.mPacketType;
        }

        @SystemApi
        public static String packetTypeToString(int packetType) {
            PacketType type = PacketType.fromOrdinal(packetType);
            return type.toString();
        }

        @SystemApi
        public int getConnectionHandle() {
            return this.mConnectionHandle;
        }

        @SystemApi
        public int getConnectionRole() {
            return this.mConnectionRole;
        }

        @SystemApi
        public static String connectionRoleToString(int connectionRole) {
            if (connectionRole == 0) {
                return "Central";
            }
            if (connectionRole == 1) {
                return "Peripheral";
            }
            return "INVALID:" + connectionRole;
        }

        @SystemApi
        public int getTxPowerLevel() {
            return this.mTxPowerLevel;
        }

        @SystemApi
        public int getRssi() {
            return this.mRssi;
        }

        @SystemApi
        public int getSnr() {
            return this.mSnr;
        }

        @SystemApi
        public int getUnusedAfhChannelCount() {
            return this.mUnusedAfhChannelCount;
        }

        @SystemApi
        public int getAfhSelectUnidealChannelCount() {
            return this.mAfhSelectUnidealChannelCount;
        }

        @SystemApi
        public int getLsto() {
            return this.mLsto;
        }

        @SystemApi
        public long getPiconetClock() {
            return this.mPiconetClock;
        }

        @SystemApi
        public long getRetransmissionCount() {
            return this.mRetransmissionCount;
        }

        @SystemApi
        public long getNoRxCount() {
            return this.mNoRxCount;
        }

        @SystemApi
        public long getNakCount() {
            return this.mNakCount;
        }

        @SystemApi
        public long getLastTxAckTimestamp() {
            return this.mLastTxAckTimestamp;
        }

        @SystemApi
        public long getFlowOffCount() {
            return this.mFlowOffCount;
        }

        @SystemApi
        public long getLastFlowOnTimestamp() {
            return this.mLastFlowOnTimestamp;
        }

        @SystemApi
        public long getOverflowCount() {
            return this.mOverflowCount;
        }

        @SystemApi
        public long getUnderflowCount() {
            return this.mUnderflowCount;
        }

        @SystemApi
        public int getCalFailedItemCount() {
            return this.mCalFailedItemCount;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        @SystemApi
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mQualityReportId);
            dest.writeInt(this.mPacketType);
            dest.writeInt(this.mConnectionHandle);
            dest.writeInt(this.mConnectionRole);
            dest.writeInt(this.mTxPowerLevel);
            dest.writeInt(this.mRssi);
            dest.writeInt(this.mSnr);
            dest.writeInt(this.mUnusedAfhChannelCount);
            dest.writeInt(this.mAfhSelectUnidealChannelCount);
            dest.writeInt(this.mLsto);
            dest.writeLong(this.mPiconetClock);
            dest.writeLong(this.mRetransmissionCount);
            dest.writeLong(this.mNoRxCount);
            dest.writeLong(this.mNakCount);
            dest.writeLong(this.mLastTxAckTimestamp);
            dest.writeLong(this.mFlowOffCount);
            dest.writeLong(this.mLastFlowOnTimestamp);
            dest.writeLong(this.mOverflowCount);
            dest.writeLong(this.mUnderflowCount);
            dest.writeString(this.mAddr);
            dest.writeInt(this.mCalFailedItemCount);
        }

        public String toString() {
            String str = "  BqrCommon: {\n    mQualityReportId: " + BqrCommon.qualityReportIdToString(this.getQualityReportId()) + "(" + String.format("0x%02X", this.mQualityReportId) + "), mPacketType: " + BqrCommon.packetTypeToString(this.mPacketType) + "(" + String.format("0x%02X", this.mPacketType) + "), mConnectionHandle: " + String.format("0x%04X", this.mConnectionHandle) + ", mConnectionRole: " + this.getConnectionRole() + "(" + this.mConnectionRole + "), mTxPowerLevel: " + this.mTxPowerLevel + ", mRssi: " + this.mRssi + ", mSnr: " + this.mSnr + ", mUnusedAfhChannelCount: " + this.mUnusedAfhChannelCount + ",\n    mAfhSelectUnidealChannelCount: " + this.mAfhSelectUnidealChannelCount + ", mLsto: " + this.mLsto + ", mPiconetClock: " + String.format("0x%08X", this.mPiconetClock) + ", mRetransmissionCount: " + this.mRetransmissionCount + ", mNoRxCount: " + this.mNoRxCount + ", mNakCount: " + this.mNakCount + ", mLastTxAckTimestamp: " + String.format("0x%08X", this.mLastTxAckTimestamp) + ", mFlowOffCount: " + this.mFlowOffCount + ",\n    mLastFlowOnTimestamp: " + String.format("0x%08X", this.mLastFlowOnTimestamp) + ", mOverflowCount: " + this.mOverflowCount + ", mUnderflowCount: " + this.mUnderflowCount + ", mAddr: " + this.mAddr + ", mCalFailedItemCount: " + this.mCalFailedItemCount + "\n  }";
            return str;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ConnectionRole {
        }
    }

    @SystemApi
    public static class BqrVsLsto
    implements Parcelable {
        private static final String TAG = "BluetoothQualityReport.BqrVsLsto";
        private int mConnState;
        private long mBasebandStats;
        private long mSlotsUsed;
        private int mCxmDenials;
        private int mTxSkipped;
        private int mRfLoss;
        private long mNativeClock;
        private long mLastTxAckTimestamp;
        @SystemApi
        public static final Parcelable.Creator<BqrVsLsto> CREATOR = new Parcelable.Creator<BqrVsLsto>(){

            @Override
            public BqrVsLsto createFromParcel(Parcel in) {
                return new BqrVsLsto(in);
            }

            public BqrVsLsto[] newArray(int size) {
                return new BqrVsLsto[size];
            }
        };

        private BqrVsLsto(byte[] rawData, int offset) {
            if (rawData == null || rawData.length <= offset) {
                throw new IllegalArgumentException("BluetoothQualityReport.BqrVsLsto: BQR raw data length is abnormal.");
            }
            ByteBuffer bqrBuf = ByteBuffer.wrap(rawData, offset, rawData.length - offset).asReadOnlyBuffer();
            bqrBuf.order(ByteOrder.LITTLE_ENDIAN);
            this.mConnState = bqrBuf.get() & 0xFF;
            this.mBasebandStats = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mSlotsUsed = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mCxmDenials = bqrBuf.getShort() & 0xFFFF;
            this.mTxSkipped = bqrBuf.getShort() & 0xFFFF;
            this.mRfLoss = bqrBuf.getShort() & 0xFFFF;
            this.mNativeClock = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mLastTxAckTimestamp = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
        }

        private BqrVsLsto(Parcel in) {
            this.mConnState = in.readInt();
            this.mBasebandStats = in.readLong();
            this.mSlotsUsed = in.readLong();
            this.mCxmDenials = in.readInt();
            this.mTxSkipped = in.readInt();
            this.mRfLoss = in.readInt();
            this.mNativeClock = in.readLong();
            this.mLastTxAckTimestamp = in.readLong();
        }

        @SystemApi
        public int getConnState() {
            return this.mConnState;
        }

        @SystemApi
        public static String connStateToString(int connectionState) {
            return ConnState.toString(connectionState);
        }

        @SystemApi
        public long getBasebandStats() {
            return this.mBasebandStats;
        }

        @SystemApi
        public long getSlotsUsed() {
            return this.mSlotsUsed;
        }

        @SystemApi
        public int getCxmDenials() {
            return this.mCxmDenials;
        }

        @SystemApi
        public int getTxSkipped() {
            return this.mTxSkipped;
        }

        @SystemApi
        public int getRfLoss() {
            return this.mRfLoss;
        }

        @SystemApi
        public long getNativeClock() {
            return this.mNativeClock;
        }

        @SystemApi
        public long getLastTxAckTimestamp() {
            return this.mLastTxAckTimestamp;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        @SystemApi
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mConnState);
            dest.writeLong(this.mBasebandStats);
            dest.writeLong(this.mSlotsUsed);
            dest.writeInt(this.mCxmDenials);
            dest.writeInt(this.mTxSkipped);
            dest.writeInt(this.mRfLoss);
            dest.writeLong(this.mNativeClock);
            dest.writeLong(this.mLastTxAckTimestamp);
        }

        public String toString() {
            String str = "  BqrVsLsto: {\n    mConnState: " + BqrVsLsto.connStateToString(this.getConnState()) + "(" + String.format("0x%02X", this.mConnState) + "), mBasebandStats: " + String.format("0x%08X", this.mBasebandStats) + ", mSlotsUsed: " + this.mSlotsUsed + ", mCxmDenials: " + this.mCxmDenials + ", mTxSkipped: " + this.mTxSkipped + ", mRfLoss: " + this.mRfLoss + ", mNativeClock: " + String.format("0x%08X", this.mNativeClock) + ", mLastTxAckTimestamp: " + String.format("0x%08X", this.mLastTxAckTimestamp) + "\n  }";
            return str;
        }
    }

    @SystemApi
    public static class BqrVsA2dpChoppy
    implements Parcelable {
        private static final String TAG = "BluetoothQualityReport.BqrVsA2dpChoppy";
        private long mArrivalTime;
        private long mScheduleTime;
        private int mGlitchCount;
        private int mTxCxmDenials;
        private int mRxCxmDenials;
        private int mAclTxQueueLength;
        private int mLinkQuality;
        @SystemApi
        public static final Parcelable.Creator<BqrVsA2dpChoppy> CREATOR = new Parcelable.Creator<BqrVsA2dpChoppy>(){

            @Override
            public BqrVsA2dpChoppy createFromParcel(Parcel in) {
                return new BqrVsA2dpChoppy(in);
            }

            public BqrVsA2dpChoppy[] newArray(int size) {
                return new BqrVsA2dpChoppy[size];
            }
        };

        private BqrVsA2dpChoppy(byte[] rawData, int offset) {
            if (rawData == null || rawData.length <= offset) {
                throw new IllegalArgumentException("BluetoothQualityReport.BqrVsA2dpChoppy: BQR raw data length is abnormal.");
            }
            ByteBuffer bqrBuf = ByteBuffer.wrap(rawData, offset, rawData.length - offset).asReadOnlyBuffer();
            bqrBuf.order(ByteOrder.LITTLE_ENDIAN);
            this.mArrivalTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mScheduleTime = (long)bqrBuf.getInt() & 0xFFFFFFFFL;
            this.mGlitchCount = bqrBuf.getShort() & 0xFFFF;
            this.mTxCxmDenials = bqrBuf.getShort() & 0xFFFF;
            this.mRxCxmDenials = bqrBuf.getShort() & 0xFFFF;
            this.mAclTxQueueLength = bqrBuf.get() & 0xFF;
            this.mLinkQuality = bqrBuf.get() & 0xFF;
        }

        private BqrVsA2dpChoppy(Parcel in) {
            this.mArrivalTime = in.readLong();
            this.mScheduleTime = in.readLong();
            this.mGlitchCount = in.readInt();
            this.mTxCxmDenials = in.readInt();
            this.mRxCxmDenials = in.readInt();
            this.mAclTxQueueLength = in.readInt();
            this.mLinkQuality = in.readInt();
        }

        @SystemApi
        public long getArrivalTime() {
            return this.mArrivalTime;
        }

        @SystemApi
        public long getScheduleTime() {
            return this.mScheduleTime;
        }

        @SystemApi
        public int getGlitchCount() {
            return this.mGlitchCount;
        }

        @SystemApi
        public int getTxCxmDenials() {
            return this.mTxCxmDenials;
        }

        @SystemApi
        public int getRxCxmDenials() {
            return this.mRxCxmDenials;
        }

        @SystemApi
        public int getAclTxQueueLength() {
            return this.mAclTxQueueLength;
        }

        @SystemApi
        public int getLinkQuality() {
            return this.mLinkQuality;
        }

        @SystemApi
        public static String linkQualityToString(int linkQuality) {
            LinkQuality q = LinkQuality.fromOrdinal(linkQuality);
            return q.toString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        @SystemApi
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.mArrivalTime);
            dest.writeLong(this.mScheduleTime);
            dest.writeInt(this.mGlitchCount);
            dest.writeInt(this.mTxCxmDenials);
            dest.writeInt(this.mRxCxmDenials);
            dest.writeInt(this.mAclTxQueueLength);
            dest.writeInt(this.mLinkQuality);
        }

        public String toString() {
            String str = "  BqrVsA2dpChoppy: {\n    mArrivalTime: " + String.format("0x%08X", this.mArrivalTime) + ", mScheduleTime: " + String.format("0x%08X", this.mScheduleTime) + ", mGlitchCount: " + this.mGlitchCount + ", mTxCxmDenials: " + this.mTxCxmDenials + ", mRxCxmDenials: " + this.mRxCxmDenials + ", mAclTxQueueLength: " + this.mAclTxQueueLength + ", mLinkQuality: " + BqrVsA2dpChoppy.linkQualityToString(this.mLinkQuality) + "(" + String.format("0x%02X", this.mLinkQuality) + ")\n  }";
            return str;
        }
    }

    @SystemApi
    public static class BqrVsScoChoppy
    implements Parcelable {
        private static final String TAG = "BluetoothQualityReport.BqrVsScoChoppy";
        private int mGlitchCount;
        private int mIntervalEsco;
        private int mWindowEsco;
        private int mAirFormat;
        private int mInstanceCount;
        private int mTxCxmDenials;
        private int mRxCxmDenials;
        private int mTxAbortCount;
        private int mLateDispatch;
        private int mMicIntrMiss;
        private int mLpaIntrMiss;
        private int mSprIntrMiss;
        private int mPlcFillCount;
        private int mPlcDiscardCount;
        private int mMissedInstanceCount;
        private int mTxRetransmitSlotCount;
        private int mRxRetransmitSlotCount;
        private int mGoodRxFrameCount;
        @SystemApi
        public static final Parcelable.Creator<BqrVsScoChoppy> CREATOR = new Parcelable.Creator<BqrVsScoChoppy>(){

            @Override
            public BqrVsScoChoppy createFromParcel(Parcel in) {
                return new BqrVsScoChoppy(in);
            }

            public BqrVsScoChoppy[] newArray(int size) {
                return new BqrVsScoChoppy[size];
            }
        };

        private BqrVsScoChoppy(byte[] rawData, int offset) {
            if (rawData == null || rawData.length <= offset) {
                throw new IllegalArgumentException("BluetoothQualityReport.BqrVsScoChoppy: BQR raw data length is abnormal.");
            }
            ByteBuffer bqrBuf = ByteBuffer.wrap(rawData, offset, rawData.length - offset).asReadOnlyBuffer();
            bqrBuf.order(ByteOrder.LITTLE_ENDIAN);
            this.mGlitchCount = bqrBuf.getShort() & 0xFFFF;
            this.mIntervalEsco = bqrBuf.get() & 0xFF;
            this.mWindowEsco = bqrBuf.get() & 0xFF;
            this.mAirFormat = bqrBuf.get() & 0xFF;
            this.mInstanceCount = bqrBuf.getShort() & 0xFFFF;
            this.mTxCxmDenials = bqrBuf.getShort() & 0xFFFF;
            this.mRxCxmDenials = bqrBuf.getShort() & 0xFFFF;
            this.mTxAbortCount = bqrBuf.getShort() & 0xFFFF;
            this.mLateDispatch = bqrBuf.getShort() & 0xFFFF;
            this.mMicIntrMiss = bqrBuf.getShort() & 0xFFFF;
            this.mLpaIntrMiss = bqrBuf.getShort() & 0xFFFF;
            this.mSprIntrMiss = bqrBuf.getShort() & 0xFFFF;
            this.mPlcFillCount = bqrBuf.getShort() & 0xFFFF;
            this.mPlcDiscardCount = bqrBuf.getShort() & 0xFFFF;
            this.mMissedInstanceCount = bqrBuf.getShort() & 0xFFFF;
            this.mTxRetransmitSlotCount = bqrBuf.getShort() & 0xFFFF;
            this.mRxRetransmitSlotCount = bqrBuf.getShort() & 0xFFFF;
            this.mGoodRxFrameCount = bqrBuf.getShort() & 0xFFFF;
        }

        private BqrVsScoChoppy(Parcel in) {
            this.mGlitchCount = in.readInt();
            this.mIntervalEsco = in.readInt();
            this.mWindowEsco = in.readInt();
            this.mAirFormat = in.readInt();
            this.mInstanceCount = in.readInt();
            this.mTxCxmDenials = in.readInt();
            this.mRxCxmDenials = in.readInt();
            this.mTxAbortCount = in.readInt();
            this.mLateDispatch = in.readInt();
            this.mMicIntrMiss = in.readInt();
            this.mLpaIntrMiss = in.readInt();
            this.mSprIntrMiss = in.readInt();
            this.mPlcFillCount = in.readInt();
            this.mPlcDiscardCount = in.readInt();
            this.mMissedInstanceCount = in.readInt();
            this.mTxRetransmitSlotCount = in.readInt();
            this.mRxRetransmitSlotCount = in.readInt();
            this.mGoodRxFrameCount = in.readInt();
        }

        @SystemApi
        public int getGlitchCount() {
            return this.mGlitchCount;
        }

        @SystemApi
        public int getIntervalEsco() {
            return this.mIntervalEsco;
        }

        @SystemApi
        public int getWindowEsco() {
            return this.mWindowEsco;
        }

        @SystemApi
        public int getAirFormat() {
            return this.mAirFormat;
        }

        @SystemApi
        public static String airFormatToString(int airFormat) {
            AirMode m = AirMode.fromOrdinal(airFormat);
            return m.toString();
        }

        @SystemApi
        public int getInstanceCount() {
            return this.mInstanceCount;
        }

        @SystemApi
        public int getTxCxmDenials() {
            return this.mTxCxmDenials;
        }

        @SystemApi
        public int getRxCxmDenials() {
            return this.mRxCxmDenials;
        }

        @SystemApi
        public int getTxAbortCount() {
            return this.mTxAbortCount;
        }

        @SystemApi
        public int getLateDispatch() {
            return this.mLateDispatch;
        }

        @SystemApi
        public int getMicIntrMiss() {
            return this.mMicIntrMiss;
        }

        @SystemApi
        public int getLpaIntrMiss() {
            return this.mLpaIntrMiss;
        }

        @SystemApi
        public int getSprIntrMiss() {
            return this.mSprIntrMiss;
        }

        @SystemApi
        public int getPlcFillCount() {
            return this.mPlcFillCount;
        }

        @SystemApi
        public int getPlcDiscardCount() {
            return this.mPlcDiscardCount;
        }

        @SystemApi
        public int getMissedInstanceCount() {
            return this.mMissedInstanceCount;
        }

        @SystemApi
        public int getTxRetransmitSlotCount() {
            return this.mTxRetransmitSlotCount;
        }

        @SystemApi
        public int getRxRetransmitSlotCount() {
            return this.mRxRetransmitSlotCount;
        }

        @SystemApi
        public int getGoodRxFrameCount() {
            return this.mGoodRxFrameCount;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        @SystemApi
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mGlitchCount);
            dest.writeInt(this.mIntervalEsco);
            dest.writeInt(this.mWindowEsco);
            dest.writeInt(this.mAirFormat);
            dest.writeInt(this.mInstanceCount);
            dest.writeInt(this.mTxCxmDenials);
            dest.writeInt(this.mRxCxmDenials);
            dest.writeInt(this.mTxAbortCount);
            dest.writeInt(this.mLateDispatch);
            dest.writeInt(this.mMicIntrMiss);
            dest.writeInt(this.mLpaIntrMiss);
            dest.writeInt(this.mSprIntrMiss);
            dest.writeInt(this.mPlcFillCount);
            dest.writeInt(this.mPlcDiscardCount);
            dest.writeInt(this.mMissedInstanceCount);
            dest.writeInt(this.mTxRetransmitSlotCount);
            dest.writeInt(this.mRxRetransmitSlotCount);
            dest.writeInt(this.mGoodRxFrameCount);
        }

        public String toString() {
            String str = "  BqrVsScoChoppy: {\n    mGlitchCount: " + this.mGlitchCount + ", mIntervalEsco: " + this.mIntervalEsco + ", mWindowEsco: " + this.mWindowEsco + ", mAirFormat: " + BqrVsScoChoppy.airFormatToString(this.mAirFormat) + "(" + String.format("0x%02X", this.mAirFormat) + "), mInstanceCount: " + this.mInstanceCount + ", mTxCxmDenials: " + this.mTxCxmDenials + ", mRxCxmDenials: " + this.mRxCxmDenials + ", mTxAbortCount: " + this.mTxAbortCount + ",\n    mLateDispatch: " + this.mLateDispatch + ", mMicIntrMiss: " + this.mMicIntrMiss + ", mLpaIntrMiss: " + this.mLpaIntrMiss + ", mSprIntrMiss: " + this.mSprIntrMiss + ", mPlcFillCount: " + this.mPlcFillCount + ", mPlcDiscardCount: " + this.mPlcDiscardCount + ", mMissedInstanceCount: " + this.mMissedInstanceCount + ", mTxRetransmitSlotCount: " + this.mTxRetransmitSlotCount + ",\n    mRxRetransmitSlotCount: " + this.mRxRetransmitSlotCount + ", mGoodRxFrameCount: " + this.mGoodRxFrameCount + "\n  }";
            return str;
        }
    }

    @SystemApi
    public static class BqrConnectFail
    implements Parcelable {
        private static final String TAG = "BluetoothQualityReport.BqrConnectFail";
        @SystemApi
        public static final int CONNECT_FAIL_ID_NO_ERROR = 0;
        @SystemApi
        public static final int CONNECT_FAIL_ID_PAGE_TIMEOUT = 4;
        @SystemApi
        public static final int CONNECT_FAIL_ID_CONNECTION_TIMEOUT = 8;
        @SystemApi
        public static final int CONNECT_FAIL_ID_ACL_ALREADY_EXIST = 11;
        @SystemApi
        public static final int CONNECT_FAIL_ID_CONTROLLER_BUSY = 58;
        private int mFailReason;
        @SystemApi
        public static final Parcelable.Creator<BqrConnectFail> CREATOR = new Parcelable.Creator<BqrConnectFail>(){

            @Override
            public BqrConnectFail createFromParcel(Parcel in) {
                return new BqrConnectFail(in);
            }

            public BqrConnectFail[] newArray(int size) {
                return new BqrConnectFail[size];
            }
        };

        private BqrConnectFail(byte[] rawData, int offset) {
            if (rawData == null || rawData.length <= offset) {
                throw new IllegalArgumentException("BluetoothQualityReport.BqrConnectFail: BQR raw data length is abnormal.");
            }
            ByteBuffer bqrBuf = ByteBuffer.wrap(rawData, offset, rawData.length - offset).asReadOnlyBuffer();
            bqrBuf.order(ByteOrder.LITTLE_ENDIAN);
            this.mFailReason = bqrBuf.get() & 0xFF;
        }

        private BqrConnectFail(Parcel in) {
            this.mFailReason = in.readInt();
        }

        @SystemApi
        public int getFailReason() {
            return this.mFailReason;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        @SystemApi
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mFailReason);
        }

        @SystemApi
        public static String connectFailIdToString(int id2) {
            switch (id2) {
                case 0: {
                    return "No error";
                }
                case 4: {
                    return "Page Timeout";
                }
                case 8: {
                    return "Connection Timeout";
                }
                case 11: {
                    return "ACL already exists";
                }
                case 58: {
                    return "Controller busy";
                }
            }
            return "INVALID";
        }

        public String toString() {
            String str = "  BqrConnectFail: {\n    mFailReason: " + BqrConnectFail.connectFailIdToString(this.mFailReason) + " (" + String.format("0x%02X", this.mFailReason) + ")\n  }";
            return str;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ConnectFailId {
        }
    }

    @SystemApi
    public static class Builder {
        private String remoteAddr;
        private int lmpVer;
        private int lmpSubVer;
        private int manufacturerId;
        private String remoteName;
        private BluetoothClass bluetoothClass;
        private byte[] rawData;

        @SystemApi
        public Builder(byte[] rawData) {
            this.rawData = Objects.requireNonNull(rawData);
        }

        @SystemApi
        public Builder setRemoteAddress(String remoteAddr) {
            this.remoteAddr = remoteAddr;
            return this;
        }

        @SystemApi
        public Builder setLmpVersion(int lmpVer) {
            this.lmpVer = lmpVer;
            return this;
        }

        @SystemApi
        public Builder setLmpSubVersion(int lmpSubVer) {
            this.lmpSubVer = lmpSubVer;
            return this;
        }

        @SystemApi
        public Builder setManufacturerId(int manufacturerId) {
            this.manufacturerId = manufacturerId;
            return this;
        }

        @SystemApi
        public Builder setRemoteName(String remoteName) {
            this.remoteName = remoteName;
            return this;
        }

        @SystemApi
        public Builder setBluetoothClass(BluetoothClass bluetoothClass) {
            this.bluetoothClass = bluetoothClass;
            return this;
        }

        @SystemApi
        public BluetoothQualityReport build() {
            this.validateBluetoothQualityReport();
            return new BluetoothQualityReport(this.remoteAddr, this.lmpVer, this.lmpSubVer, this.manufacturerId, this.remoteName, this.bluetoothClass, this.rawData);
        }

        private void validateBluetoothQualityReport() {
            if (!BluetoothAdapter.checkBluetoothAddress(this.remoteAddr)) {
                Log.d(BluetoothQualityReport.TAG, "remote addr is invalid");
                this.remoteAddr = "00:00:00:00:00:00";
            }
            if (this.remoteName == null) {
                Log.d(BluetoothQualityReport.TAG, "remote name is null");
                this.remoteName = "";
            }
        }
    }

    static enum AirMode {
        uLaw,
        aLaw,
        CVSD,
        transparent_msbc,
        INVALID;

        private static AirMode[] sAllValues;

        static AirMode fromOrdinal(int n) {
            if (n < sAllValues.length - 1) {
                return sAllValues[n];
            }
            return INVALID;
        }

        static {
            sAllValues = AirMode.values();
        }
    }

    static enum LinkQuality {
        ULTRA_HIGH,
        HIGH,
        STANDARD,
        MEDIUM,
        LOW,
        INVALID;

        private static LinkQuality[] sAllValues;

        static LinkQuality fromOrdinal(int n) {
            if (n < sAllValues.length - 1) {
                return sAllValues[n];
            }
            return INVALID;
        }

        static {
            sAllValues = LinkQuality.values();
        }
    }

    static enum ConnState {
        CONN_IDLE(0),
        CONN_ACTIVE(129),
        CONN_HOLD(2),
        CONN_SNIFF_IDLE(3),
        CONN_SNIFF_ACTIVE(132),
        CONN_SNIFF_MASTER_TRANSITION(133),
        CONN_PARK(6),
        CONN_PARK_PEND(71),
        CONN_UNPARK_PEND(8),
        CONN_UNPARK_ACTIVE(137),
        CONN_DISCONNECT_PENDING(74),
        CONN_PAGING(11),
        CONN_PAGE_SCAN(12),
        CONN_LOCAL_LOOPBACK(13),
        CONN_LE_ACTIVE(14),
        CONN_ANT_ACTIVE(15),
        CONN_TRIGGER_SCAN(16),
        CONN_RECONNECTING(17),
        CONN_SEMI_CONN(18);

        private final int mValue;
        private static ConnState[] sAllStates;

        private ConnState(int val) {
            this.mValue = val;
        }

        public static String toString(int val) {
            for (ConnState state : sAllStates) {
                if (state.mValue != val) continue;
                return state.toString();
            }
            return "INVALID";
        }

        static {
            sAllStates = ConnState.values();
        }
    }

    static enum PacketType {
        INVALID,
        TYPE_ID,
        TYPE_NULL,
        TYPE_POLL,
        TYPE_FHS,
        TYPE_HV1,
        TYPE_HV2,
        TYPE_HV3,
        TYPE_DV,
        TYPE_EV3,
        TYPE_EV4,
        TYPE_EV5,
        TYPE_2EV3,
        TYPE_2EV5,
        TYPE_3EV3,
        TYPE_3EV5,
        TYPE_DM1,
        TYPE_DH1,
        TYPE_DM3,
        TYPE_DH3,
        TYPE_DM5,
        TYPE_DH5,
        TYPE_AUX1,
        TYPE_2DH1,
        TYPE_2DH3,
        TYPE_2DH5,
        TYPE_3DH1,
        TYPE_3DH3,
        TYPE_3DH5;

        private static PacketType[] sAllValues;

        static PacketType fromOrdinal(int n) {
            if (n < sAllValues.length) {
                return sAllValues[n];
            }
            return INVALID;
        }

        static {
            sAllValues = PacketType.values();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QualityReportId {
    }
}

