/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetooth;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Handler;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import com.android.internal.lang.System_Delegate;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

@SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
public class BluetoothServerSocket
implements Closeable {
    private static final String TAG = "BluetoothServerSocket";
    private static final boolean DBG = Log.isLoggable("BluetoothServerSocket", 3);
    @UnsupportedAppUsage(publicAlternatives="Use public {@link BluetoothServerSocket} API instead.")
    final BluetoothSocket mSocket;
    private Handler mHandler;
    private int mMessage;
    private int mChannel;
    private long mSocketCreationTimeMillis = System_Delegate.currentTimeMillis();
    private long mSocketCreationLatencyMillis = 0L;
    private int mType;

    BluetoothServerSocket(int type, boolean auth, boolean encrypt, int port) throws IOException {
        this.mType = type;
        this.mChannel = port;
        this.mSocket = new BluetoothSocket(type, -1, auth, encrypt, null, port, null);
        if (port == -2) {
            this.mSocket.setExcludeSdp(true);
        }
        this.mSocketCreationLatencyMillis = System_Delegate.currentTimeMillis() - this.mSocketCreationTimeMillis;
    }

    BluetoothServerSocket(int type, boolean auth, boolean encrypt, int port, boolean mitm, boolean min16DigitPin) throws IOException {
        this.mType = type;
        this.mChannel = port;
        this.mSocket = new BluetoothSocket(type, -1, auth, encrypt, null, port, null, mitm, min16DigitPin);
        if (port == -2) {
            this.mSocket.setExcludeSdp(true);
        }
        this.mSocketCreationLatencyMillis = System_Delegate.currentTimeMillis() - this.mSocketCreationTimeMillis;
    }

    BluetoothServerSocket(int type, boolean auth, boolean encrypt, ParcelUuid uuid) throws IOException {
        this.mType = type;
        this.mSocket = new BluetoothSocket(type, -1, auth, encrypt, null, -1, uuid);
        this.mChannel = this.mSocket.getPort();
        this.mSocketCreationLatencyMillis = System_Delegate.currentTimeMillis() - this.mSocketCreationTimeMillis;
    }

    public BluetoothSocket accept() throws IOException {
        return this.accept(-1);
    }

    public BluetoothSocket accept(int timeout) throws IOException {
        long socketConnectionTime = System_Delegate.currentTimeMillis();
        BluetoothSocket acceptedSocket = null;
        try {
            acceptedSocket = this.mSocket.accept(timeout);
            this.logL2capcocServerConnection(acceptedSocket, timeout, 1, socketConnectionTime);
            return acceptedSocket;
        }
        catch (IOException e) {
            this.logL2capcocServerConnection(acceptedSocket, timeout, 2000, socketConnectionTime);
            throw e;
        }
    }

    private void logL2capcocServerConnection(BluetoothSocket acceptedSocket, int timeout, int result, long socketConnectionTimeMillis) {
        if (this.mType != 4) {
            return;
        }
        IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
        if (bluetoothProxy == null) {
            Log.w(TAG, "bluetoothProxy is null while trying to log l2cap soc server connection");
            return;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            bluetoothProxy.logL2capcocServerConnection(acceptedSocket == null ? null : acceptedSocket.getRemoteDevice(), this.getPsm(), this.mSocket.isAuth(), result, this.mSocketCreationTimeMillis, this.mSocketCreationLatencyMillis, socketConnectionTimeMillis, timeout, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.w(TAG, "logL2capcocServerConnection failed due to remote exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (DBG) {
            Log.d(TAG, "BluetoothServerSocket:close() called. mChannel=" + this.mChannel);
        }
        BluetoothServerSocket bluetoothServerSocket = this;
        synchronized (bluetoothServerSocket) {
            if (this.mHandler != null) {
                this.mHandler.obtainMessage(this.mMessage).sendToTarget();
            }
        }
        this.mSocket.close();
    }

    synchronized void setCloseHandler(Handler handler, int message) {
        this.mHandler = handler;
        this.mMessage = message;
    }

    void setServiceName(String serviceName) {
        this.mSocket.setServiceName(serviceName);
    }

    public int getChannel() {
        return this.mChannel;
    }

    public int getPsm() {
        return this.mChannel;
    }

    void setChannel(int newChannel) {
        if (this.mSocket != null && this.mSocket.getPort() != newChannel) {
            Log.w(TAG, "The port set is different that the underlying port. mSocket.getPort(): " + this.mSocket.getPort() + " requested newChannel: " + newChannel);
        }
        this.mChannel = newChannel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ServerSocket: Type: ");
        switch (this.mSocket.getConnectionType()) {
            case 1: {
                sb.append("TYPE_RFCOMM");
                break;
            }
            case 3: {
                sb.append("TYPE_L2CAP");
                break;
            }
            case 4: {
                sb.append("TYPE_L2CAP_LE");
                break;
            }
            case 2: {
                sb.append("TYPE_SCO");
            }
        }
        sb.append(" Channel: ").append(this.mChannel);
        return sb.toString();
    }
}

