/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothInputStream;
import android.bluetooth.BluetoothOutputStream;
import android.bluetooth.BluetoothSocketException;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothSocketManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.LocalSocket;
import android.os.ParcelFileDescriptor;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import com.android.internal.lang.System_Delegate;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeoutException;

public class BluetoothSocket
implements Closeable {
    private static final String TAG = "BluetoothSocket";
    private static final boolean DBG = Log.isLoggable("BluetoothSocket", 3);
    private static final boolean VDBG = Log.isLoggable("BluetoothSocket", 2);
    public static final int MAX_RFCOMM_CHANNEL = 30;
    static final int MAX_L2CAP_PACKAGE_SIZE = 65535;
    public static final int TYPE_RFCOMM = 1;
    public static final int TYPE_SCO = 2;
    public static final int TYPE_L2CAP = 3;
    public static final int TYPE_L2CAP_BREDR = 3;
    public static final int TYPE_L2CAP_LE = 4;
    static final int EBADFD = 77;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    static final int EADDRINUSE = 98;
    static final int SEC_FLAG_ENCRYPT = 1;
    static final int SEC_FLAG_AUTH = 2;
    static final int BTSOCK_FLAG_NO_SDP = 4;
    static final int SEC_FLAG_AUTH_MITM = 8;
    static final int SEC_FLAG_AUTH_16_DIGIT = 16;
    private static final int RESULT_L2CAP_CONN_UNKNOWN = 0;
    static final int RESULT_L2CAP_CONN_SUCCESS = 1;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_SOCKET_CONNECTION_FAILED = 1000;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_SOCKET_CONNECTION_CLOSED = 1001;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_UNABLE_TO_SEND_RPC = 1002;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_NULL_BLUETOOTH_DEVICE = 1003;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_GET_SOCKET_MANAGER_FAILED = 1004;
    private static final int RESULT_L2CAP_CONN_BLUETOOTH_NULL_FILE_DESCRIPTOR = 1005;
    static final int RESULT_L2CAP_CONN_SERVER_FAILURE = 2000;
    private final int mType;
    private BluetoothDevice mDevice;
    private String mAddress;
    private final boolean mAuth;
    private final boolean mEncrypt;
    private final BluetoothInputStream mInputStream;
    private final BluetoothOutputStream mOutputStream;
    private final ParcelUuid mUuid;
    private boolean mExcludeSdp = false;
    private boolean mAuthMitm = false;
    private boolean mMin16DigitPin = false;
    @UnsupportedAppUsage(publicAlternatives="Use {@link BluetoothSocket} public API instead.")
    private ParcelFileDescriptor mPfd;
    @UnsupportedAppUsage
    private LocalSocket mSocket;
    private InputStream mSocketIS;
    private OutputStream mSocketOS;
    @UnsupportedAppUsage
    private int mPort;
    private int mFd;
    private String mServiceName;
    private static final int PROXY_CONNECTION_TIMEOUT = 5000;
    private static final int SOCK_SIGNAL_SIZE = 20;
    private ByteBuffer mL2capBuffer = null;
    private int mMaxTxPacketSize = 0;
    private int mMaxRxPacketSize = 0;
    private long mSocketCreationTimeMillis = 0L;
    private long mSocketCreationLatencyMillis = 0L;
    private volatile SocketState mSocketState;

    BluetoothSocket(int type, int fd, boolean auth, boolean encrypt, BluetoothDevice device, int port, ParcelUuid uuid) throws IOException {
        this(type, fd, auth, encrypt, device, port, uuid, false, false);
    }

    BluetoothSocket(int type, int fd, boolean auth, boolean encrypt, BluetoothDevice device, int port, ParcelUuid uuid, boolean mitm, boolean min16DigitPin) throws IOException {
        if (VDBG) {
            Log.d(TAG, "Creating new BluetoothSocket of type: " + type);
        }
        this.mSocketCreationTimeMillis = System_Delegate.currentTimeMillis();
        if (type == 1 && uuid == null && fd == -1 && port != -2 && (port < 1 || port > 30)) {
            throw new IOException("Invalid RFCOMM channel: " + port);
        }
        this.mUuid = uuid != null ? uuid : new ParcelUuid(new UUID(0L, 0L));
        this.mType = type;
        this.mAuth = auth;
        this.mAuthMitm = mitm;
        this.mMin16DigitPin = min16DigitPin;
        this.mEncrypt = encrypt;
        this.mDevice = device;
        this.mPort = port;
        this.mFd = fd;
        this.mSocketState = SocketState.INIT;
        this.mAddress = device == null ? BluetoothAdapter.getDefaultAdapter().getAddress() : device.getAddress();
        this.mInputStream = new BluetoothInputStream(this);
        this.mOutputStream = new BluetoothOutputStream(this);
        this.mSocketCreationLatencyMillis = System_Delegate.currentTimeMillis() - this.mSocketCreationTimeMillis;
    }

    static BluetoothSocket createSocketFromOpenFd(ParcelFileDescriptor pfd, BluetoothDevice device, ParcelUuid uuid) throws IOException {
        BluetoothSocket bluetoothSocket = new BluetoothSocket(1, pfd.getFd(), true, true, device, -1, uuid);
        bluetoothSocket.mPfd = pfd;
        bluetoothSocket.mSocket = new LocalSocket(pfd.getFileDescriptor());
        bluetoothSocket.mSocketIS = bluetoothSocket.mSocket.getInputStream();
        bluetoothSocket.mSocketOS = bluetoothSocket.mSocket.getOutputStream();
        bluetoothSocket.mSocketState = SocketState.CONNECTED;
        return bluetoothSocket;
    }

    private BluetoothSocket(BluetoothSocket s) {
        if (VDBG) {
            Log.d(TAG, "Creating new Private BluetoothSocket of type: " + s.mType);
        }
        this.mUuid = s.mUuid;
        this.mType = s.mType;
        this.mAuth = s.mAuth;
        this.mEncrypt = s.mEncrypt;
        this.mPort = s.mPort;
        this.mInputStream = new BluetoothInputStream(this);
        this.mOutputStream = new BluetoothOutputStream(this);
        this.mMaxRxPacketSize = s.mMaxRxPacketSize;
        this.mMaxTxPacketSize = s.mMaxTxPacketSize;
        this.mServiceName = s.mServiceName;
        this.mExcludeSdp = s.mExcludeSdp;
        this.mAuthMitm = s.mAuthMitm;
        this.mMin16DigitPin = s.mMin16DigitPin;
        this.mSocketCreationTimeMillis = s.mSocketCreationTimeMillis;
        this.mSocketCreationLatencyMillis = s.mSocketCreationLatencyMillis;
    }

    private BluetoothSocket acceptSocket(String remoteAddr) throws IOException {
        BluetoothSocket as = new BluetoothSocket(this);
        as.mSocketState = SocketState.CONNECTED;
        Object[] fds = this.mSocket.getAncillaryFileDescriptors();
        if (DBG) {
            Log.d(TAG, "acceptSocket: socket fd passed by stack fds:" + Arrays.toString(fds));
        }
        if (fds == null || fds.length != 1) {
            Log.e(TAG, "socket fd passed from stack failed, fds: " + Arrays.toString(fds));
            as.close();
            throw new IOException("bt socket acept failed");
        }
        as.mPfd = ParcelFileDescriptor.dup((FileDescriptor)fds[0]);
        as.mSocket = new LocalSocket((FileDescriptor)fds[0]);
        as.mSocketIS = as.mSocket.getInputStream();
        as.mSocketOS = as.mSocket.getOutputStream();
        as.mAddress = remoteAddr;
        as.mDevice = BluetoothAdapter.getDefaultAdapter().getRemoteDevice(remoteAddr);
        return as;
    }

    private BluetoothSocket(int type, int fd, boolean auth, boolean encrypt, String address, int port) throws IOException {
        this(type, fd, auth, encrypt, new BluetoothDevice(address), port, null, false, false);
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private int getSecurityFlags() {
        int flags = 0;
        if (this.mAuth) {
            flags |= 2;
        }
        if (this.mEncrypt) {
            flags |= 1;
        }
        if (this.mExcludeSdp) {
            flags |= 4;
        }
        if (this.mAuthMitm) {
            flags |= 8;
        }
        if (this.mMin16DigitPin) {
            flags |= 0x10;
        }
        return flags;
    }

    @RequiresNoPermission
    public BluetoothDevice getRemoteDevice() {
        return this.mDevice;
    }

    @RequiresNoPermission
    public InputStream getInputStream() throws IOException {
        return this.mInputStream;
    }

    @RequiresNoPermission
    public OutputStream getOutputStream() throws IOException {
        return this.mOutputStream;
    }

    @RequiresNoPermission
    public boolean isConnected() {
        return this.mSocketState == SocketState.CONNECTED;
    }

    void setServiceName(String name) {
        this.mServiceName = name;
    }

    boolean isAuth() {
        return this.mAuth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void connect() throws IOException {
        IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
        long socketConnectionTimeMillis = System_Delegate.currentTimeMillis();
        if (bluetoothProxy == null) {
            throw new BluetoothSocketException(15);
        }
        if (this.mDevice == null) {
            this.logL2capcocClientConnection(bluetoothProxy, 1003, socketConnectionTimeMillis);
            throw new BluetoothSocketException(19);
        }
        try {
            if (this.mSocketState == SocketState.CLOSED) {
                this.logL2capcocClientConnection(bluetoothProxy, 1001, socketConnectionTimeMillis);
                throw new BluetoothSocketException(17);
            }
            IBluetoothSocketManager socketManager = bluetoothProxy.getSocketManager();
            if (socketManager == null) {
                this.logL2capcocClientConnection(bluetoothProxy, 1004, socketConnectionTimeMillis);
                throw new BluetoothSocketException(16);
            }
            this.mPfd = socketManager.connectSocket(this.mDevice, this.mType, this.mUuid, this.mPort, this.getSecurityFlags());
            BluetoothSocket bluetoothSocket = this;
            synchronized (bluetoothSocket) {
                if (DBG) {
                    Log.d(TAG, "connect(), SocketState: " + (Object)((Object)this.mSocketState) + ", mPfd: " + this.mPfd);
                }
                if (this.mSocketState == SocketState.CLOSED) {
                    this.logL2capcocClientConnection(bluetoothProxy, 1001, socketConnectionTimeMillis);
                    throw new BluetoothSocketException(18);
                }
                if (this.mPfd == null) {
                    this.logL2capcocClientConnection(bluetoothProxy, 1005, socketConnectionTimeMillis);
                    throw new BluetoothSocketException(18);
                }
                FileDescriptor fd = this.mPfd.getFileDescriptor();
                this.mSocket = new LocalSocket(fd);
                this.mSocketIS = this.mSocket.getInputStream();
                this.mSocketOS = this.mSocket.getOutputStream();
            }
            int channel = this.readInt(this.mSocketIS);
            if (channel == 0) {
                int errCode = this.mSocketIS.read();
                this.logL2capcocClientConnection(bluetoothProxy, errCode, socketConnectionTimeMillis);
                throw new BluetoothSocketException(errCode);
            }
            if (channel < 0) {
                this.logL2capcocClientConnection(bluetoothProxy, 1000, socketConnectionTimeMillis);
                throw new BluetoothSocketException(18);
            }
            this.mPort = channel;
            this.waitSocketSignal(this.mSocketIS);
            BluetoothSocket bluetoothSocket2 = this;
            synchronized (bluetoothSocket2) {
                if (this.mSocketState == SocketState.CLOSED) {
                    this.logL2capcocClientConnection(bluetoothProxy, 1001, socketConnectionTimeMillis);
                    throw new BluetoothSocketException(17);
                }
                this.mSocketState = SocketState.CONNECTED;
                if (DBG) {
                    Log.d(TAG, "connect(), socket connected");
                }
            }
            this.logL2capcocClientConnection(bluetoothProxy, 1, socketConnectionTimeMillis);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            this.logL2capcocClientConnection(bluetoothProxy, 1002, socketConnectionTimeMillis);
            throw new BluetoothSocketException(20, "unable to send RPC: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    int bindListen() {
        int ret;
        if (this.mSocketState == SocketState.CLOSED) {
            return 77;
        }
        IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
        if (bluetoothProxy == null) {
            Log.e(TAG, "bindListen fail, reason: bluetooth is off");
            return -1;
        }
        try {
            IBluetoothSocketManager socketManager;
            if (DBG) {
                Log.d(TAG, "bindListen(): mPort=" + this.mPort + ", mType=" + this.mType);
            }
            if ((socketManager = bluetoothProxy.getSocketManager()) == null) {
                Log.e(TAG, "bindListen() bt get socket manager failed");
                return -1;
            }
            this.mPfd = socketManager.createSocketChannel(this.mType, this.mServiceName, this.mUuid, this.mPort, this.getSecurityFlags());
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            return -1;
        }
        try {
            Object fd;
            BluetoothSocket e = this;
            synchronized (e) {
                if (DBG) {
                    Log.d(TAG, "bindListen(), SocketState: " + (Object)((Object)this.mSocketState) + ", mPfd: " + this.mPfd);
                }
                if (this.mSocketState != SocketState.INIT) {
                    return 77;
                }
                if (this.mPfd == null) {
                    return -1;
                }
                fd = this.mPfd.getFileDescriptor();
                if (fd == null) {
                    Log.e(TAG, "bindListen(), null file descriptor");
                    return -1;
                }
                if (DBG) {
                    Log.d(TAG, "bindListen(), Create LocalSocket");
                }
                this.mSocket = new LocalSocket((FileDescriptor)fd);
                if (DBG) {
                    Log.d(TAG, "bindListen(), new LocalSocket.getInputStream()");
                }
                this.mSocketIS = this.mSocket.getInputStream();
                this.mSocketOS = this.mSocket.getOutputStream();
            }
            if (DBG) {
                Log.d(TAG, "bindListen(), readInt mSocketIS: " + this.mSocketIS);
            }
            int channel = this.readInt(this.mSocketIS);
            fd = this;
            synchronized (fd) {
                if (this.mSocketState == SocketState.INIT) {
                    this.mSocketState = SocketState.LISTENING;
                }
            }
            if (DBG) {
                Log.d(TAG, "bindListen(): channel=" + channel + ", mPort=" + this.mPort);
            }
            if (this.mPort <= -1) {
                this.mPort = channel;
            }
            ret = 0;
        }
        catch (IOException e) {
            if (this.mPfd != null) {
                try {
                    this.mPfd.close();
                }
                catch (IOException e1) {
                    Log.e(TAG, "bindListen, close mPfd: " + e1);
                }
                this.mPfd = null;
            }
            Log.e(TAG, "bindListen, fail to get port number, exception: " + e);
            return -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BluetoothSocket accept(int timeout) throws IOException {
        BluetoothSocket acceptedSocket;
        if (this.mSocketState != SocketState.LISTENING) {
            throw new IOException("bt socket is not in listen state");
        }
        Log.d(TAG, "accept(), timeout (ms):" + timeout);
        if (timeout > 0) {
            this.mSocket.setSoTimeout(timeout);
        }
        String RemoteAddr = this.waitSocketSignal(this.mSocketIS);
        if (timeout > 0) {
            this.mSocket.setSoTimeout(0);
        }
        BluetoothSocket bluetoothSocket = this;
        synchronized (bluetoothSocket) {
            if (this.mSocketState != SocketState.LISTENING) {
                throw new IOException("bt socket is not in listen state");
            }
            acceptedSocket = this.acceptSocket(RemoteAddr);
        }
        return acceptedSocket;
    }

    int available() throws IOException {
        if (VDBG) {
            Log.d(TAG, "available: " + this.mSocketIS);
        }
        return this.mSocketIS.available();
    }

    int read(byte[] b, int offset, int length) throws IOException {
        int ret = 0;
        if (VDBG) {
            Log.d(TAG, "read in:  " + this.mSocketIS + " len: " + length);
        }
        if (this.mType == 3 || this.mType == 4) {
            int bytesToRead = length;
            if (VDBG) {
                Log.v(TAG, "l2cap: read(): offset: " + offset + " length:" + length + "mL2capBuffer= " + this.mL2capBuffer);
            }
            if (this.mL2capBuffer == null) {
                this.createL2capRxBuffer();
            }
            if (this.mL2capBuffer.remaining() == 0) {
                if (VDBG) {
                    Log.v(TAG, "l2cap buffer empty, refilling...");
                }
                if (this.fillL2capRxBuffer() == -1) {
                    return -1;
                }
            }
            if (bytesToRead > this.mL2capBuffer.remaining()) {
                bytesToRead = this.mL2capBuffer.remaining();
            }
            if (VDBG) {
                Log.v(TAG, "get(): offset: " + offset + " bytesToRead: " + bytesToRead);
            }
            this.mL2capBuffer.get(b, offset, bytesToRead);
            ret = bytesToRead;
        } else {
            if (VDBG) {
                Log.v(TAG, "default: read(): offset: " + offset + " length:" + length);
            }
            ret = this.mSocketIS.read(b, offset, length);
        }
        if (ret < 0) {
            throw new IOException("bt socket closed, read return: " + ret);
        }
        if (VDBG) {
            Log.d(TAG, "read out:  " + this.mSocketIS + " ret: " + ret);
        }
        return ret;
    }

    int write(byte[] b, int offset, int length) throws IOException {
        if (VDBG) {
            Log.d(TAG, "write: " + this.mSocketOS + " length: " + length);
        }
        if (this.mType == 3 || this.mType == 4) {
            if (length <= this.mMaxTxPacketSize) {
                this.mSocketOS.write(b, offset, length);
            } else {
                int tmpLength;
                if (DBG) {
                    Log.w(TAG, "WARNING: Write buffer larger than L2CAP packet size!\nPacket will be divided into SDU packets of size " + this.mMaxTxPacketSize);
                }
                int tmpOffset = offset;
                for (int bytesToWrite = length; bytesToWrite > 0; bytesToWrite -= tmpLength) {
                    tmpLength = bytesToWrite > this.mMaxTxPacketSize ? this.mMaxTxPacketSize : bytesToWrite;
                    this.mSocketOS.write(b, tmpOffset, tmpLength);
                    tmpOffset += tmpLength;
                }
            }
        } else {
            this.mSocketOS.write(b, offset, length);
        }
        if (VDBG) {
            Log.d(TAG, "write out: " + this.mSocketOS + " length: " + length);
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Log.d(TAG, "close() this: " + this + ", channel: " + this.mPort + ", mSocketIS: " + this.mSocketIS + ", mSocketOS: " + this.mSocketOS + ", mSocket: " + this.mSocket + ", mSocketState: " + (Object)((Object)this.mSocketState));
        if (this.mSocketState == SocketState.CLOSED) {
            return;
        }
        BluetoothSocket bluetoothSocket = this;
        synchronized (bluetoothSocket) {
            if (this.mSocketState == SocketState.CLOSED) {
                return;
            }
            this.mSocketState = SocketState.CLOSED;
            if (this.mSocket != null) {
                if (DBG) {
                    Log.d(TAG, "Closing mSocket: " + this.mSocket);
                }
                this.mSocket.shutdownInput();
                this.mSocket.shutdownOutput();
                this.mSocket.close();
                this.mSocket = null;
            }
            if (this.mPfd != null) {
                this.mPfd.close();
                this.mPfd = null;
            }
        }
    }

    private void logL2capcocClientConnection(IBluetooth bluetoothProxy, int errCode, long socketConnectionTimeMillis) {
        if (this.mType != 4) {
            return;
        }
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            bluetoothProxy.logL2capcocClientConnection(this.mDevice, this.mPort, this.mAuth, errCode, this.mSocketCreationTimeMillis, this.mSocketCreationLatencyMillis, socketConnectionTimeMillis, recv);
            recv.awaitResultNoInterrupt(BluetoothUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.w(TAG, "logL2capcocClientConnection failed due to remote exception");
        }
    }

    void removeChannel() {
    }

    int getPort() {
        return this.mPort;
    }

    long getSocketCreationTime() {
        return this.mSocketCreationTimeMillis;
    }

    @RequiresNoPermission
    public int getMaxTransmitPacketSize() {
        return this.mMaxTxPacketSize;
    }

    @RequiresNoPermission
    public int getMaxReceivePacketSize() {
        return this.mMaxRxPacketSize;
    }

    @RequiresNoPermission
    public int getConnectionType() {
        if (this.mType == 4) {
            return 3;
        }
        return this.mType;
    }

    @RequiresNoPermission
    public void setExcludeSdp(boolean excludeSdp) {
        this.mExcludeSdp = excludeSdp;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void requestMaximumTxDataLength() throws IOException {
        if (this.mDevice == null) {
            throw new IOException("requestMaximumTxDataLength is called on null device");
        }
        try {
            IBluetoothSocketManager socketManager;
            if (this.mSocketState == SocketState.CLOSED) {
                throw new IOException("socket closed");
            }
            IBluetooth bluetoothProxy = BluetoothAdapter.getDefaultAdapter().getBluetoothService();
            if (bluetoothProxy == null) {
                throw new IOException("Bluetooth is off");
            }
            if (DBG) {
                Log.d(TAG, "requestMaximumTxDataLength");
            }
            if ((socketManager = bluetoothProxy.getSocketManager()) == null) {
                throw new IOException("bt get socket manager failed");
            }
            socketManager.requestMaximumTxDataLength(this.mDevice);
        }
        catch (RemoteException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            throw new IOException("unable to send RPC: " + e.getMessage());
        }
    }

    public ParcelFileDescriptor getParcelFileDescriptor() {
        return this.mPfd;
    }

    private String convertAddr(byte[] addr) {
        return String.format(Locale.US, "%02X:%02X:%02X:%02X:%02X:%02X", addr[0], addr[1], addr[2], addr[3], addr[4], addr[5]);
    }

    private String waitSocketSignal(InputStream is) throws IOException {
        byte[] sig = new byte[20];
        int ret = this.readAll(is, sig);
        if (VDBG) {
            Log.d(TAG, "waitSocketSignal read 20 bytes signal ret: " + ret);
        }
        ByteBuffer bb = ByteBuffer.wrap(sig);
        bb.order(ByteOrder.nativeOrder());
        short size = bb.getShort();
        if (size != 20) {
            throw new IOException("Connection failure, wrong signal size: " + size);
        }
        byte[] addr = new byte[6];
        bb.get(addr);
        int channel = bb.getInt();
        int status = bb.getInt();
        this.mMaxTxPacketSize = bb.getShort() & 0xFFFF;
        this.mMaxRxPacketSize = bb.getShort() & 0xFFFF;
        String RemoteAddr = this.convertAddr(addr);
        if (VDBG) {
            Log.d(TAG, "waitSocketSignal: sig size: " + size + ", remote addr: " + RemoteAddr + ", channel: " + channel + ", status: " + status + " MaxRxPktSize: " + this.mMaxRxPacketSize + " MaxTxPktSize: " + this.mMaxTxPacketSize);
        }
        if (status != 0) {
            throw new IOException("Connection failure, status: " + status);
        }
        return RemoteAddr;
    }

    private void createL2capRxBuffer() {
        if (this.mType == 3 || this.mType == 4) {
            if (VDBG) {
                Log.v(TAG, "  Creating mL2capBuffer: mMaxPacketSize: " + this.mMaxRxPacketSize);
            }
            this.mL2capBuffer = ByteBuffer.wrap(new byte[this.mMaxRxPacketSize]);
            if (VDBG) {
                Log.v(TAG, "mL2capBuffer.remaining()" + this.mL2capBuffer.remaining());
            }
            this.mL2capBuffer.limit(0);
            if (VDBG) {
                Log.v(TAG, "mL2capBuffer.remaining() after limit(0):" + this.mL2capBuffer.remaining());
            }
        }
    }

    private int readAll(InputStream is, byte[] b) throws IOException {
        int left = b.length;
        while (left > 0) {
            int ret = is.read(b, b.length - left, left);
            if (ret <= 0) {
                throw new IOException("read failed, socket might closed or timeout, read ret: " + ret);
            }
            if ((left -= ret) == 0) continue;
            Log.w(TAG, "readAll() looping, read partial size: " + (b.length - left) + ", expect size: " + b.length);
        }
        return b.length;
    }

    private int readInt(InputStream is) throws IOException {
        byte[] ibytes = new byte[4];
        int ret = this.readAll(is, ibytes);
        if (VDBG) {
            Log.d(TAG, "inputStream.read ret: " + ret);
        }
        ByteBuffer bb = ByteBuffer.wrap(ibytes);
        bb.order(ByteOrder.nativeOrder());
        return bb.getInt();
    }

    private int fillL2capRxBuffer() throws IOException {
        this.mL2capBuffer.rewind();
        int ret = this.mSocketIS.read(this.mL2capBuffer.array());
        if (ret == -1) {
            this.mL2capBuffer.limit(0);
            return -1;
        }
        this.mL2capBuffer.limit(ret);
        return ret;
    }

    public String toString() {
        return BluetoothUtils.toAnonymizedAddress(this.mAddress);
    }

    private static enum SocketState {
        INIT,
        CONNECTED,
        LISTENING,
        CLOSED;

    }
}

