/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothCodecConfig;
import android.bluetooth.BluetoothDevice;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;

public interface IBluetoothA2dp
extends IInterface {
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void connect(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void disconnect(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getConnectedDevices(AttributionSource var1, SynchronousResultReceiver var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getDevicesMatchingConnectionStates(int[] var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getConnectionState(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void setActiveDevice(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getActiveDevice(AttributionSource var1, SynchronousResultReceiver var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setConnectionPolicy(BluetoothDevice var1, int var2, AttributionSource var3, SynchronousResultReceiver var4) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void getConnectionPolicy(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresNoPermission
    public void isAvrcpAbsoluteVolumeSupported(SynchronousResultReceiver var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setAvrcpAbsoluteVolume(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void isA2dpPlaying(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void getCodecStatus(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setCodecConfigPreference(BluetoothDevice var1, BluetoothCodecConfig var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void enableOptionalCodecs(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void disableOptionalCodecs(BluetoothDevice var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void isOptionalCodecsSupported(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void isOptionalCodecsEnabled(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setOptionalCodecsEnabled(BluetoothDevice var1, int var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void getDynamicBufferSupport(AttributionSource var1, SynchronousResultReceiver var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void getBufferConstraints(AttributionSource var1, SynchronousResultReceiver var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void setBufferLengthMillis(int var1, int var2, AttributionSource var3, SynchronousResultReceiver var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothA2dp {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetoothA2dp";
        static final int TRANSACTION_connect = 1;
        static final int TRANSACTION_disconnect = 2;
        static final int TRANSACTION_getConnectedDevices = 3;
        static final int TRANSACTION_getDevicesMatchingConnectionStates = 4;
        static final int TRANSACTION_getConnectionState = 5;
        static final int TRANSACTION_setActiveDevice = 6;
        static final int TRANSACTION_getActiveDevice = 7;
        static final int TRANSACTION_setConnectionPolicy = 8;
        static final int TRANSACTION_getConnectionPolicy = 9;
        static final int TRANSACTION_isAvrcpAbsoluteVolumeSupported = 10;
        static final int TRANSACTION_setAvrcpAbsoluteVolume = 11;
        static final int TRANSACTION_isA2dpPlaying = 12;
        static final int TRANSACTION_getCodecStatus = 13;
        static final int TRANSACTION_setCodecConfigPreference = 14;
        static final int TRANSACTION_enableOptionalCodecs = 15;
        static final int TRANSACTION_disableOptionalCodecs = 16;
        static final int TRANSACTION_isOptionalCodecsSupported = 17;
        static final int TRANSACTION_isOptionalCodecsEnabled = 18;
        static final int TRANSACTION_setOptionalCodecsEnabled = 19;
        static final int TRANSACTION_getDynamicBufferSupport = 20;
        static final int TRANSACTION_getBufferConstraints = 21;
        static final int TRANSACTION_setBufferLengthMillis = 22;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothA2dp asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothA2dp) {
                return (IBluetoothA2dp)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "connect";
                }
                case 2: {
                    return "disconnect";
                }
                case 3: {
                    return "getConnectedDevices";
                }
                case 4: {
                    return "getDevicesMatchingConnectionStates";
                }
                case 5: {
                    return "getConnectionState";
                }
                case 6: {
                    return "setActiveDevice";
                }
                case 7: {
                    return "getActiveDevice";
                }
                case 8: {
                    return "setConnectionPolicy";
                }
                case 9: {
                    return "getConnectionPolicy";
                }
                case 10: {
                    return "isAvrcpAbsoluteVolumeSupported";
                }
                case 11: {
                    return "setAvrcpAbsoluteVolume";
                }
                case 12: {
                    return "isA2dpPlaying";
                }
                case 13: {
                    return "getCodecStatus";
                }
                case 14: {
                    return "setCodecConfigPreference";
                }
                case 15: {
                    return "enableOptionalCodecs";
                }
                case 16: {
                    return "disableOptionalCodecs";
                }
                case 17: {
                    return "isOptionalCodecsSupported";
                }
                case 18: {
                    return "isOptionalCodecsEnabled";
                }
                case 19: {
                    return "setOptionalCodecsEnabled";
                }
                case 20: {
                    return "getDynamicBufferSupport";
                }
                case 21: {
                    return "getBufferConstraints";
                }
                case 22: {
                    return "setBufferLengthMillis";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.connect(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.disconnect(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg1 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectedDevices(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int[] _arg0 = data.createIntArray();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getDevicesMatchingConnectionStates(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectionState(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.setActiveDevice(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg1 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getActiveDevice(_arg0, _arg1);
                    break;
                }
                case 8: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg3 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.setConnectionPolicy(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 9: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectionPolicy(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    SynchronousResultReceiver<?> _arg0 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.isAvrcpAbsoluteVolumeSupported(_arg0);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.setAvrcpAbsoluteVolume(_arg0, _arg1);
                    break;
                }
                case 12: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.isA2dpPlaying(_arg0, _arg1, _arg2);
                    break;
                }
                case 13: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getCodecStatus(_arg0, _arg1, _arg2);
                    break;
                }
                case 14: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    BluetoothCodecConfig _arg1 = data.readTypedObject(BluetoothCodecConfig.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.setCodecConfigPreference(_arg0, _arg1, _arg2);
                    break;
                }
                case 15: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.enableOptionalCodecs(_arg0, _arg1);
                    break;
                }
                case 16: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.disableOptionalCodecs(_arg0, _arg1);
                    break;
                }
                case 17: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.isOptionalCodecsSupported(_arg0, _arg1, _arg2);
                    break;
                }
                case 18: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.isOptionalCodecsEnabled(_arg0, _arg1, _arg2);
                    break;
                }
                case 19: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.setOptionalCodecsEnabled(_arg0, _arg1, _arg2);
                    break;
                }
                case 20: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg1 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getDynamicBufferSupport(_arg0, _arg1);
                    break;
                }
                case 21: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg1 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getBufferConstraints(_arg0, _arg1);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg3 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.setBufferLengthMillis(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 21;
        }

        private static class Proxy
        implements IBluetoothA2dp {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnect(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectedDevices(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(states);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectionState(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setActiveDevice(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getActiveDevice(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConnectionPolicy(BluetoothDevice device, int connectionPolicy, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(connectionPolicy);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectionPolicy(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isAvrcpAbsoluteVolumeSupported(SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAvrcpAbsoluteVolume(int volume, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(volume);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isA2dpPlaying(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getCodecStatus(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCodecConfigPreference(BluetoothDevice device, BluetoothCodecConfig codecConfig, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(codecConfig, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableOptionalCodecs(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableOptionalCodecs(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isOptionalCodecsSupported(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isOptionalCodecsEnabled(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOptionalCodecsEnabled(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(value);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDynamicBufferSupport(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getBufferConstraints(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBufferLengthMillis(int codec, int size, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(codec);
                    _data.writeInt(size);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothA2dp {
        @Override
        public void connect(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void disconnect(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getConnectedDevices(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getConnectionState(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void setActiveDevice(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getActiveDevice(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void setConnectionPolicy(BluetoothDevice device, int connectionPolicy, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getConnectionPolicy(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void isAvrcpAbsoluteVolumeSupported(SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void setAvrcpAbsoluteVolume(int volume, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void isA2dpPlaying(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getCodecStatus(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void setCodecConfigPreference(BluetoothDevice device, BluetoothCodecConfig codecConfig, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void enableOptionalCodecs(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void disableOptionalCodecs(BluetoothDevice device, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void isOptionalCodecsSupported(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void isOptionalCodecsEnabled(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void setOptionalCodecsEnabled(BluetoothDevice device, int value, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void getDynamicBufferSupport(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getBufferConstraints(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void setBufferLengthMillis(int codec, int size, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

