/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothCsipSetCoordinatorLockCallback;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.RemoteException;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;

public interface IBluetoothCsipSetCoordinator
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothCsipSetCoordinator";
    public static final int CSIS_GROUP_ID_INVALID = -1;
    public static final int CSIS_GROUP_SIZE_UNKNOWN = 1;
    public static final int CSIS_GROUP_LOCK_SUCCESS = 0;
    public static final int CSIS_GROUP_LOCK_FAILED_INVALID_GROUP = 1;
    public static final int CSIS_GROUP_LOCK_FAILED_GROUP_EMPTY = 2;
    public static final int CSIS_GROUP_LOCK_FAILED_GROUP_NOT_CONNECTED = 3;
    public static final int CSIS_GROUP_LOCK_FAILED_LOCKED_BY_OTHER = 4;
    public static final int CSIS_GROUP_LOCK_FAILED_OTHER_REASON = 5;
    public static final int CSIS_LOCKED_GROUP_MEMBER_LOST = 6;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void connect(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void disconnect(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getConnectedDevices(AttributionSource var1, SynchronousResultReceiver var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getDevicesMatchingConnectionStates(int[] var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getConnectionState(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void setConnectionPolicy(BluetoothDevice var1, int var2, AttributionSource var3, SynchronousResultReceiver var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void getConnectionPolicy(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getAllGroupIds(ParcelUuid var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getGroupUuidMapByDevice(BluetoothDevice var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void getDesiredGroupSize(int var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void lockGroup(int var1, IBluetoothCsipSetCoordinatorLockCallback var2, AttributionSource var3, SynchronousResultReceiver var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void unlockGroup(ParcelUuid var1, AttributionSource var2, SynchronousResultReceiver var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothCsipSetCoordinator {
        static final int TRANSACTION_connect = 1;
        static final int TRANSACTION_disconnect = 2;
        static final int TRANSACTION_getConnectedDevices = 3;
        static final int TRANSACTION_getDevicesMatchingConnectionStates = 4;
        static final int TRANSACTION_getConnectionState = 5;
        static final int TRANSACTION_setConnectionPolicy = 6;
        static final int TRANSACTION_getConnectionPolicy = 7;
        static final int TRANSACTION_getAllGroupIds = 8;
        static final int TRANSACTION_getGroupUuidMapByDevice = 9;
        static final int TRANSACTION_getDesiredGroupSize = 10;
        static final int TRANSACTION_lockGroup = 11;
        static final int TRANSACTION_unlockGroup = 12;

        public Stub() {
            this.attachInterface(this, IBluetoothCsipSetCoordinator.DESCRIPTOR);
        }

        public static IBluetoothCsipSetCoordinator asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothCsipSetCoordinator.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothCsipSetCoordinator) {
                return (IBluetoothCsipSetCoordinator)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "connect";
                }
                case 2: {
                    return "disconnect";
                }
                case 3: {
                    return "getConnectedDevices";
                }
                case 4: {
                    return "getDevicesMatchingConnectionStates";
                }
                case 5: {
                    return "getConnectionState";
                }
                case 6: {
                    return "setConnectionPolicy";
                }
                case 7: {
                    return "getConnectionPolicy";
                }
                case 8: {
                    return "getAllGroupIds";
                }
                case 9: {
                    return "getGroupUuidMapByDevice";
                }
                case 10: {
                    return "getDesiredGroupSize";
                }
                case 11: {
                    return "lockGroup";
                }
                case 12: {
                    return "unlockGroup";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothCsipSetCoordinator.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.connect(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.disconnect(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg1 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectedDevices(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int[] _arg0 = data.createIntArray();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getDevicesMatchingConnectionStates(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectionState(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg3 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.setConnectionPolicy(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 7: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getConnectionPolicy(_arg0, _arg1, _arg2);
                    break;
                }
                case 8: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getAllGroupIds(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getGroupUuidMapByDevice(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.getDesiredGroupSize(_arg0, _arg1, _arg2);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    IBluetoothCsipSetCoordinatorLockCallback _arg1 = IBluetoothCsipSetCoordinatorLockCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg3 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.lockGroup(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 12: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    SynchronousResultReceiver<?> _arg2 = data.readTypedObject(SynchronousResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.unlockGroup(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements IBluetoothCsipSetCoordinator {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothCsipSetCoordinator.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothCsipSetCoordinator.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnect(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothCsipSetCoordinator.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectedDevices(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothCsipSetCoordinator.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothCsipSetCoordinator.DESCRIPTOR);
                    _data.writeIntArray(states);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectionState(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothCsipSetCoordinator.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConnectionPolicy(BluetoothDevice device, int connectionPolicy, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothCsipSetCoordinator.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(connectionPolicy);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getConnectionPolicy(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothCsipSetCoordinator.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAllGroupIds(ParcelUuid uuid, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothCsipSetCoordinator.DESCRIPTOR);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getGroupUuidMapByDevice(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothCsipSetCoordinator.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDesiredGroupSize(int group_id, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothCsipSetCoordinator.DESCRIPTOR);
                    _data.writeInt(group_id);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lockGroup(int groupId, IBluetoothCsipSetCoordinatorLockCallback callback, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothCsipSetCoordinator.DESCRIPTOR);
                    _data.writeInt(groupId);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlockGroup(ParcelUuid lockUuid, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothCsipSetCoordinator.DESCRIPTOR);
                    _data.writeTypedObject(lockUuid, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(receiver, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothCsipSetCoordinator {
        @Override
        public void connect(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void disconnect(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getConnectedDevices(AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getDevicesMatchingConnectionStates(int[] states, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getConnectionState(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void setConnectionPolicy(BluetoothDevice device, int connectionPolicy, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getConnectionPolicy(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getAllGroupIds(ParcelUuid uuid, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getGroupUuidMapByDevice(BluetoothDevice device, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void getDesiredGroupSize(int group_id, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void lockGroup(int groupId, IBluetoothCsipSetCoordinatorLockCallback callback, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void unlockGroup(ParcelUuid lockUuid, AttributionSource attributionSource, SynchronousResultReceiver receiver) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

