/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothHidDeviceCallback
extends IInterface {
    public void onAppStatusChanged(BluetoothDevice var1, boolean var2) throws RemoteException;

    public void onConnectionStateChanged(BluetoothDevice var1, int var2) throws RemoteException;

    public void onGetReport(BluetoothDevice var1, byte var2, byte var3, int var4) throws RemoteException;

    public void onSetReport(BluetoothDevice var1, byte var2, byte var3, byte[] var4) throws RemoteException;

    public void onSetProtocol(BluetoothDevice var1, byte var2) throws RemoteException;

    public void onInterruptData(BluetoothDevice var1, byte var2, byte[] var3) throws RemoteException;

    public void onVirtualCableUnplug(BluetoothDevice var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothHidDeviceCallback {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetoothHidDeviceCallback";
        static final int TRANSACTION_onAppStatusChanged = 1;
        static final int TRANSACTION_onConnectionStateChanged = 2;
        static final int TRANSACTION_onGetReport = 3;
        static final int TRANSACTION_onSetReport = 4;
        static final int TRANSACTION_onSetProtocol = 5;
        static final int TRANSACTION_onInterruptData = 6;
        static final int TRANSACTION_onVirtualCableUnplug = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothHidDeviceCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothHidDeviceCallback) {
                return (IBluetoothHidDeviceCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onAppStatusChanged";
                }
                case 2: {
                    return "onConnectionStateChanged";
                }
                case 3: {
                    return "onGetReport";
                }
                case 4: {
                    return "onSetReport";
                }
                case 5: {
                    return "onSetProtocol";
                }
                case 6: {
                    return "onInterruptData";
                }
                case 7: {
                    return "onVirtualCableUnplug";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onAppStatusChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onConnectionStateChanged(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    byte _arg1 = data.readByte();
                    byte _arg2 = data.readByte();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onGetReport(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    byte _arg1 = data.readByte();
                    byte _arg2 = data.readByte();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onSetReport(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    byte _arg1 = data.readByte();
                    data.enforceNoDataAvail();
                    this.onSetProtocol(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    byte _arg1 = data.readByte();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onInterruptData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    data.enforceNoDataAvail();
                    this.onVirtualCableUnplug(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IBluetoothHidDeviceCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAppStatusChanged(BluetoothDevice device, boolean registered) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeBoolean(registered);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectionStateChanged(BluetoothDevice device, int state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(state);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGetReport(BluetoothDevice device, byte type, byte id2, int bufferSize) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeByte(type);
                    _data.writeByte(id2);
                    _data.writeInt(bufferSize);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetReport(BluetoothDevice device, byte type, byte id2, byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeByte(type);
                    _data.writeByte(id2);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetProtocol(BluetoothDevice device, byte protocol) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeByte(protocol);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInterruptData(BluetoothDevice device, byte reportId, byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeByte(reportId);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVirtualCableUnplug(BluetoothDevice device) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothHidDeviceCallback {
        @Override
        public void onAppStatusChanged(BluetoothDevice device, boolean registered) throws RemoteException {
        }

        @Override
        public void onConnectionStateChanged(BluetoothDevice device, int state) throws RemoteException {
        }

        @Override
        public void onGetReport(BluetoothDevice device, byte type, byte id2, int bufferSize) throws RemoteException {
        }

        @Override
        public void onSetReport(BluetoothDevice device, byte type, byte id2, byte[] data) throws RemoteException {
        }

        @Override
        public void onSetProtocol(BluetoothDevice device, byte protocol) throws RemoteException {
        }

        @Override
        public void onInterruptData(BluetoothDevice device, byte reportId, byte[] data) throws RemoteException {
        }

        @Override
        public void onVirtualCableUnplug(BluetoothDevice device) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

