/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IBluetoothLeCallControlCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothLeCallControlCallback";

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onBearerRegistered(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onAcceptCall(int var1, ParcelUuid var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onTerminateCall(int var1, ParcelUuid var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onHoldCall(int var1, ParcelUuid var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onUnholdCall(int var1, ParcelUuid var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onPlaceCall(int var1, ParcelUuid var2, String var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void onJoinCalls(int var1, List<ParcelUuid> var2) throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N = value.size();
                parcel.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements IBluetoothLeCallControlCallback {
        static final int TRANSACTION_onBearerRegistered = 1;
        static final int TRANSACTION_onAcceptCall = 2;
        static final int TRANSACTION_onTerminateCall = 3;
        static final int TRANSACTION_onHoldCall = 4;
        static final int TRANSACTION_onUnholdCall = 5;
        static final int TRANSACTION_onPlaceCall = 6;
        static final int TRANSACTION_onJoinCalls = 7;

        public Stub() {
            this.attachInterface(this, IBluetoothLeCallControlCallback.DESCRIPTOR);
        }

        public static IBluetoothLeCallControlCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothLeCallControlCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothLeCallControlCallback) {
                return (IBluetoothLeCallControlCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onBearerRegistered";
                }
                case 2: {
                    return "onAcceptCall";
                }
                case 3: {
                    return "onTerminateCall";
                }
                case 4: {
                    return "onHoldCall";
                }
                case 5: {
                    return "onUnholdCall";
                }
                case 6: {
                    return "onPlaceCall";
                }
                case 7: {
                    return "onJoinCalls";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothLeCallControlCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBearerRegistered(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    ParcelUuid _arg1 = data.readTypedObject(ParcelUuid.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAcceptCall(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    ParcelUuid _arg1 = data.readTypedObject(ParcelUuid.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTerminateCall(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    ParcelUuid _arg1 = data.readTypedObject(ParcelUuid.CREATOR);
                    data.enforceNoDataAvail();
                    this.onHoldCall(_arg0, _arg1);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    ParcelUuid _arg1 = data.readTypedObject(ParcelUuid.CREATOR);
                    data.enforceNoDataAvail();
                    this.onUnholdCall(_arg0, _arg1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    ParcelUuid _arg1 = data.readTypedObject(ParcelUuid.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.onPlaceCall(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    ArrayList<ParcelUuid> _arg1 = data.createTypedArrayList(ParcelUuid.CREATOR);
                    data.enforceNoDataAvail();
                    this.onJoinCalls(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IBluetoothLeCallControlCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothLeCallControlCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBearerRegistered(int ccid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControlCallback.DESCRIPTOR);
                    _data.writeInt(ccid);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAcceptCall(int requestId, ParcelUuid uuid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControlCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(uuid, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTerminateCall(int requestId, ParcelUuid uuid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControlCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(uuid, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHoldCall(int requestId, ParcelUuid uuid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControlCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(uuid, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUnholdCall(int requestId, ParcelUuid uuid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControlCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(uuid, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPlaceCall(int requestId, ParcelUuid uuid, String uri) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControlCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeString(uri);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onJoinCalls(int requestId, List<ParcelUuid> uuids) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothLeCallControlCallback.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _Parcel.writeTypedList(_data, uuids, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothLeCallControlCallback {
        @Override
        public void onBearerRegistered(int ccid) throws RemoteException {
        }

        @Override
        public void onAcceptCall(int requestId, ParcelUuid uuid) throws RemoteException {
        }

        @Override
        public void onTerminateCall(int requestId, ParcelUuid uuid) throws RemoteException {
        }

        @Override
        public void onHoldCall(int requestId, ParcelUuid uuid) throws RemoteException {
        }

        @Override
        public void onUnholdCall(int requestId, ParcelUuid uuid) throws RemoteException {
        }

        @Override
        public void onPlaceCall(int requestId, ParcelUuid uuid, String uri) throws RemoteException {
        }

        @Override
        public void onJoinCalls(int requestId, List<ParcelUuid> uuids) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

