/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothPanCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothPanCallback";

    public void onAvailable(String var1) throws RemoteException;

    public void onUnavailable() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothPanCallback {
        static final int TRANSACTION_onAvailable = 1;
        static final int TRANSACTION_onUnavailable = 2;

        public Stub() {
            this.attachInterface(this, IBluetoothPanCallback.DESCRIPTOR);
        }

        public static IBluetoothPanCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothPanCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothPanCallback) {
                return (IBluetoothPanCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onAvailable";
                }
                case 2: {
                    return "onUnavailable";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothPanCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onAvailable(_arg0);
                    break;
                }
                case 2: {
                    this.onUnavailable();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IBluetoothPanCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothPanCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAvailable(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothPanCallback.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onUnavailable() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothPanCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothPanCallback {
        @Override
        public void onAvailable(String iface) throws RemoteException {
        }

        @Override
        public void onUnavailable() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

