/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.BluetoothLeUtils;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import android.content.AttributionSource;
import android.os.RemoteException;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.util.concurrent.TimeoutException;

public class AdvertisingSet {
    private static final String TAG = "AdvertisingSet";
    private final IBluetoothGatt mGatt;
    private int mAdvertiserId;
    private AttributionSource mAttributionSource;

    AdvertisingSet(int advertiserId, IBluetoothManager bluetoothManager, AttributionSource attributionSource) {
        this.mAdvertiserId = advertiserId;
        this.mAttributionSource = attributionSource;
        try {
            this.mGatt = bluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get Bluetooth gatt - ", e);
            throw new IllegalStateException("Failed to get Bluetooth");
        }
    }

    void setAdvertiserId(int advertiserId) {
        this.mAdvertiserId = advertiserId;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void enableAdvertising(boolean enable, int duration, int maxExtendedAdvertisingEvents) {
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mGatt.enableAdvertisingSet(this.mAdvertiserId, enable, duration, maxExtendedAdvertisingEvents, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setAdvertisingData(AdvertiseData advertiseData) {
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mGatt.setAdvertisingData(this.mAdvertiserId, advertiseData, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setScanResponseData(AdvertiseData scanResponse) {
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mGatt.setScanResponseData(this.mAdvertiserId, scanResponse, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setAdvertisingParameters(AdvertisingSetParameters parameters) {
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mGatt.setAdvertisingParameters(this.mAdvertiserId, parameters, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingParameters(PeriodicAdvertisingParameters parameters) {
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mGatt.setPeriodicAdvertisingParameters(this.mAdvertiserId, parameters, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingData(AdvertiseData periodicData) {
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mGatt.setPeriodicAdvertisingData(this.mAdvertiserId, periodicData, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingEnabled(boolean enable) {
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mGatt.setPeriodicAdvertisingEnable(this.mAdvertiserId, enable, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void getOwnAddress() {
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mGatt.getOwnAddress(this.mAdvertiserId, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "remote exception - ", e);
        }
    }

    @SystemApi
    @RequiresNoPermission
    public int getAdvertiserId() {
        return this.mAdvertiserId;
    }
}

