/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothAdapter;
import android.util.SparseArray;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class BluetoothLeUtils {
    private static final Duration SYNC_CALLS_TIMEOUT = Duration.ofSeconds(5L);

    static Duration getSyncTimeout() {
        return SYNC_CALLS_TIMEOUT;
    }

    static <T> String toString(byte[] data) {
        if (data == null) {
            return "null";
        }
        if (data.length == 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (int i = 0; i < data.length; ++i) {
            buffer.append(data[i]);
            if (i + 1 >= data.length) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        return buffer.toString();
    }

    static String toString(SparseArray<byte[]> array2) {
        if (array2 == null) {
            return "null";
        }
        if (array2.size() == 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (int i = 0; i < array2.size(); ++i) {
            buffer.append(array2.keyAt(i)).append("=").append(Arrays.toString(array2.valueAt(i)));
        }
        buffer.append('}');
        return buffer.toString();
    }

    static <T> String toString(Map<T, byte[]> map) {
        if (map == null) {
            return "null";
        }
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        Iterator<Map.Entry<T, byte[]>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<T, byte[]> entry = it.next();
            T key = entry.getKey();
            buffer.append(key).append("=").append(Arrays.toString(map.get(key)));
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        return buffer.toString();
    }

    static boolean equals(SparseArray<byte[]> array2, SparseArray<byte[]> otherArray) {
        if (array2 == otherArray) {
            return true;
        }
        if (array2 == null || otherArray == null) {
            return false;
        }
        if (array2.size() != otherArray.size()) {
            return false;
        }
        for (int i = 0; i < array2.size(); ++i) {
            if (array2.keyAt(i) == otherArray.keyAt(i) && Arrays.equals(array2.valueAt(i), otherArray.valueAt(i))) continue;
            return false;
        }
        return true;
    }

    static <T> boolean equals(Map<T, byte[]> map, Map<T, byte[]> otherMap) {
        if (map == otherMap) {
            return true;
        }
        if (map == null || otherMap == null) {
            return false;
        }
        if (map.size() != otherMap.size()) {
            return false;
        }
        Set<T> keys = map.keySet();
        if (!keys.equals(otherMap.keySet())) {
            return false;
        }
        for (T key : keys) {
            if (Objects.deepEquals(map.get(key), otherMap.get(key))) continue;
            return false;
        }
        return true;
    }

    static void checkAdapterStateOn(BluetoothAdapter adapter) {
        if (adapter == null || !adapter.isLeEnabled()) {
            throw new IllegalStateException("BT Adapter is not turned ON");
        }
    }

    static boolean maskedEquals(UUID data, UUID uuid, UUID mask) {
        if (mask == null) {
            return Objects.equals(data, uuid);
        }
        return (data.getLeastSignificantBits() & mask.getLeastSignificantBits()) == (uuid.getLeastSignificantBits() & mask.getLeastSignificantBits()) && (data.getMostSignificantBits() & mask.getMostSignificantBits()) == (uuid.getMostSignificantBits() & mask.getMostSignificantBits());
    }
}

