/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.BluetoothLeUtils;
import android.bluetooth.le.DistanceMeasurementMethod;
import android.bluetooth.le.DistanceMeasurementParams;
import android.bluetooth.le.DistanceMeasurementResult;
import android.bluetooth.le.DistanceMeasurementSession;
import android.bluetooth.le.IDistanceMeasurementCallback;
import android.content.AttributionSource;
import android.os.CancellationSignal;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;

@SystemApi
public class DistanceMeasurementManager {
    private static final String TAG = "DistanceMeasurementManager";
    private final ConcurrentHashMap<BluetoothDevice, DistanceMeasurementSession> mSessionMap = new ConcurrentHashMap();
    private final BluetoothAdapter mBluetoothAdapter;
    private final IBluetoothManager mBluetoothManager;
    private final AttributionSource mAttributionSource;
    private final ParcelUuid mUuid;
    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private final IDistanceMeasurementCallback mCallbackWrapper = new IDistanceMeasurementCallback.Stub(){

        @Override
        public void onStarted(BluetoothDevice device) {
            DistanceMeasurementSession session = DistanceMeasurementManager.this.mSessionMap.get(device);
            session.onStarted();
        }

        @Override
        public void onStartFail(BluetoothDevice device, int reason) {
            DistanceMeasurementSession session = DistanceMeasurementManager.this.mSessionMap.get(device);
            session.onStartFail(reason);
            DistanceMeasurementManager.this.mSessionMap.remove(device);
        }

        @Override
        public void onStopped(BluetoothDevice device, int reason) {
            DistanceMeasurementSession session = DistanceMeasurementManager.this.mSessionMap.get(device);
            session.onStopped(reason);
            DistanceMeasurementManager.this.mSessionMap.remove(device);
        }

        @Override
        public void onResult(BluetoothDevice device, DistanceMeasurementResult result) {
            DistanceMeasurementSession session = DistanceMeasurementManager.this.mSessionMap.get(device);
            session.onResult(device, result);
        }
    };

    public DistanceMeasurementManager(BluetoothAdapter bluetoothAdapter) {
        this.mBluetoothAdapter = Objects.requireNonNull(bluetoothAdapter);
        this.mBluetoothManager = this.mBluetoothAdapter.getBluetoothManager();
        this.mAttributionSource = this.mBluetoothAdapter.getAttributionSource();
        this.mUuid = new ParcelUuid(UUID.randomUUID());
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public List<DistanceMeasurementMethod> getSupportedMethods() {
        ArrayList<DistanceMeasurementMethod> supportedMethods = new ArrayList<DistanceMeasurementMethod>();
        try {
            IBluetoothGatt gatt = this.mBluetoothManager.getBluetoothGatt();
            if (gatt == null) {
                Log.e(TAG, "Bluetooth GATT is null");
                return supportedMethods;
            }
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            gatt.getSupportedDistanceMeasurementMethods(this.mAttributionSource, recv);
            return recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(new ArrayList());
        }
        catch (RemoteException | TimeoutException e) {
            Log.e(TAG, "Failed to get supported methods - ", e);
            return supportedMethods;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public CancellationSignal startMeasurementSession(DistanceMeasurementParams params, Executor executor, DistanceMeasurementSession.Callback callback) {
        Objects.requireNonNull(params, "params is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(callback, "callback is null");
        try {
            IBluetoothGatt gatt = this.mBluetoothManager.getBluetoothGatt();
            if (gatt == null) {
                Log.e(TAG, "Bluetooth GATT is null");
                return null;
            }
            DistanceMeasurementSession session = new DistanceMeasurementSession(gatt, this.mUuid, params, executor, this.mAttributionSource, callback);
            CancellationSignal cancellationSignal = new CancellationSignal();
            cancellationSignal.setOnCancelListener(() -> session.stopSession());
            if (this.mSessionMap.containsKey(params.getDevice())) {
                throw new IllegalStateException(params.getDevice().getAnonymizedAddress() + " already registered");
            }
            this.mSessionMap.put(params.getDevice(), session);
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            gatt.startDistanceMeasurement(this.mUuid, params, this.mCallbackWrapper, this.mAttributionSource, recv);
            recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(null);
            return cancellationSignal;
        }
        catch (TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
            return null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

