/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class DistanceMeasurementMethod
implements Parcelable {
    private final int mId;
    private final boolean mIsAzimuthAngleSupported;
    private final boolean mIsAltitudeAngleSupported;
    @SystemApi
    public static final int DISTANCE_MEASUREMENT_METHOD_AUTO = 0;
    @SystemApi
    public static final int DISTANCE_MEASUREMENT_METHOD_RSSI = 1;
    public static final Parcelable.Creator<DistanceMeasurementMethod> CREATOR = new Parcelable.Creator<DistanceMeasurementMethod>(){

        @Override
        public DistanceMeasurementMethod createFromParcel(Parcel in) {
            return new Builder(in.readInt()).setAzimuthAngleSupported(in.readBoolean()).setAltitudeAngleSupported(in.readBoolean()).build();
        }

        public DistanceMeasurementMethod[] newArray(int size) {
            return new DistanceMeasurementMethod[size];
        }
    };

    private DistanceMeasurementMethod(int id2, boolean isAzimuthAngleSupported, boolean isAltitudeAngleSupported) {
        this.mId = id2;
        this.mIsAzimuthAngleSupported = isAzimuthAngleSupported;
        this.mIsAltitudeAngleSupported = isAltitudeAngleSupported;
    }

    @SystemApi
    public double getId() {
        return this.mId;
    }

    @SystemApi
    public boolean isAzimuthAngleSupported() {
        return this.mIsAzimuthAngleSupported;
    }

    @SystemApi
    public boolean isAltitudeAngleSupported() {
        return this.mIsAltitudeAngleSupported;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mId);
        out.writeBoolean(this.mIsAzimuthAngleSupported);
        out.writeBoolean(this.mIsAltitudeAngleSupported);
    }

    public String toString() {
        return "DistanceMeasurementMethod[id: " + this.mId + ", isAzimuthAngleSupported: " + this.mIsAzimuthAngleSupported + ", isAltitudeAngleSupported: " + this.mIsAltitudeAngleSupported + "]";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DistanceMeasurementMethod)) {
            return false;
        }
        DistanceMeasurementMethod u = (DistanceMeasurementMethod)o;
        return (double)this.mId == u.getId();
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    @SystemApi
    public static class Builder {
        private int mId;
        private boolean mIsAzimuthAngleSupported = false;
        private boolean mIsAltitudeAngleSupported = false;

        public Builder(int id2) {
            switch (id2) {
                case 0: 
                case 1: {
                    this.mId = id2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown method id " + id2);
                }
            }
        }

        @SystemApi
        public Builder setAzimuthAngleSupported(boolean supported) {
            this.mIsAzimuthAngleSupported = supported;
            return this;
        }

        @SystemApi
        public Builder setAltitudeAngleSupported(boolean supported) {
            this.mIsAltitudeAngleSupported = supported;
            return this;
        }

        @SystemApi
        public DistanceMeasurementMethod build() {
            return new DistanceMeasurementMethod(this.mId, this.mIsAzimuthAngleSupported, this.mIsAltitudeAngleSupported);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface DistanceMeasurementMethodId {
    }
}

