/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.SystemApi;
import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class DistanceMeasurementParams
implements Parcelable {
    @SystemApi
    public static final int REPORT_FREQUENCY_LOW = 0;
    @SystemApi
    public static final int REPORT_FREQUENCY_MEDIUM = 1;
    @SystemApi
    public static final int REPORT_FREQUENCY_HIGH = 2;
    private static final int REPORT_DURATION_DEFAULT = 60;
    private static final int REPORT_DURATION_MAX = 3600;
    private BluetoothDevice mDevice = null;
    private int mDuration;
    private int mFrequency;
    private int mMethodId;
    public static final Parcelable.Creator<DistanceMeasurementParams> CREATOR = new Parcelable.Creator<DistanceMeasurementParams>(){

        @Override
        public DistanceMeasurementParams createFromParcel(Parcel in) {
            Builder builder = new Builder((BluetoothDevice)in.readParcelable(null));
            builder.setDurationSeconds(in.readInt());
            builder.setFrequency(in.readInt());
            builder.setMethodId(in.readInt());
            return builder.build();
        }

        public DistanceMeasurementParams[] newArray(int size) {
            return new DistanceMeasurementParams[size];
        }
    };

    public DistanceMeasurementParams(BluetoothDevice device, int duration, int frequency, int methodId) {
        this.mDevice = Objects.requireNonNull(device);
        this.mDuration = duration;
        this.mFrequency = frequency;
        this.mMethodId = methodId;
    }

    @SystemApi
    public BluetoothDevice getDevice() {
        return this.mDevice;
    }

    @SystemApi
    public int getDurationSeconds() {
        return this.mDuration;
    }

    @SystemApi
    public int getFrequency() {
        return this.mFrequency;
    }

    @SystemApi
    public int getMethodId() {
        return this.mMethodId;
    }

    @SystemApi
    public static int getDefaultDurationSeconds() {
        return 60;
    }

    @SystemApi
    public static int getMaxDurationSeconds() {
        return 3600;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mDevice, 0);
        out.writeInt(this.mDuration);
        out.writeInt(this.mFrequency);
        out.writeInt(this.mMethodId);
    }

    @SystemApi
    public static class Builder {
        private BluetoothDevice mDevice = null;
        private int mDuration = 60;
        private int mFrequency = 0;
        private int mMethodId = 1;

        public Builder(BluetoothDevice device) {
            this.mDevice = Objects.requireNonNull(device);
        }

        @SystemApi
        public Builder setDurationSeconds(int duration) {
            if (duration < 0 || duration > DistanceMeasurementParams.getMaxDurationSeconds()) {
                throw new IllegalArgumentException("illegal duration " + duration);
            }
            this.mDuration = duration;
            return this;
        }

        @SystemApi
        public Builder setFrequency(int frequency) {
            switch (frequency) {
                case 0: 
                case 1: 
                case 2: {
                    this.mFrequency = frequency;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown frequency " + frequency);
                }
            }
            return this;
        }

        @SystemApi
        public Builder setMethodId(int methodId) {
            switch (methodId) {
                case 0: 
                case 1: {
                    this.mMethodId = methodId;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown method id " + methodId);
                }
            }
            return this;
        }

        @SystemApi
        public DistanceMeasurementParams build() {
            return new DistanceMeasurementParams(this.mDevice, this.mDuration, this.mFrequency, this.mMethodId);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ReportFrequency {
    }
}

