/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
public class DistanceMeasurementResult
implements Parcelable {
    private final double mMeters;
    private final double mErrorMeters;
    private final double mAzimuthAngle;
    private final double mErrorAzimuthAngle;
    private final double mAltitudeAngle;
    private final double mErrorAltitudeAngle;
    public static final Parcelable.Creator<DistanceMeasurementResult> CREATOR = new Parcelable.Creator<DistanceMeasurementResult>(){

        @Override
        public DistanceMeasurementResult createFromParcel(Parcel in) {
            return new Builder(in.readDouble(), in.readDouble()).setAzimuthAngle(in.readDouble()).setErrorAzimuthAngle(in.readDouble()).setAltitudeAngle(in.readDouble()).setErrorAltitudeAngle(in.readDouble()).build();
        }

        public DistanceMeasurementResult[] newArray(int size) {
            return new DistanceMeasurementResult[size];
        }
    };

    private DistanceMeasurementResult(double meters, double errorMeters, double azimuthAngle, double errorAzimuthAngle, double altitudeAngle, double errorAltitudeAngle) {
        this.mMeters = meters;
        this.mErrorMeters = errorMeters;
        this.mAzimuthAngle = azimuthAngle;
        this.mErrorAzimuthAngle = errorAzimuthAngle;
        this.mAltitudeAngle = altitudeAngle;
        this.mErrorAltitudeAngle = errorAltitudeAngle;
    }

    @SystemApi
    public double getResultMeters() {
        return this.mMeters;
    }

    @SystemApi
    public double getErrorMeters() {
        return this.mErrorMeters;
    }

    @SystemApi
    public double getAzimuthAngle() {
        return this.mAzimuthAngle;
    }

    @SystemApi
    public double getErrorAzimuthAngle() {
        return this.mErrorAzimuthAngle;
    }

    @SystemApi
    public double getAltitudeAngle() {
        return this.mAltitudeAngle;
    }

    @SystemApi
    public double getErrorAltitudeAngle() {
        return this.mErrorAltitudeAngle;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeDouble(this.mMeters);
        out.writeDouble(this.mErrorMeters);
        out.writeDouble(this.mAzimuthAngle);
        out.writeDouble(this.mErrorAzimuthAngle);
        out.writeDouble(this.mAltitudeAngle);
        out.writeDouble(this.mErrorAltitudeAngle);
    }

    public String toString() {
        return "DistanceMeasurement[meters: " + this.mMeters + ", errorMeters: " + this.mErrorMeters + ", azimuthAngle: " + this.mAzimuthAngle + ", errorAzimuthAngle: " + this.mErrorAzimuthAngle + ", altitudeAngle: " + this.mAltitudeAngle + ", errorAltitudeAngle: " + this.mErrorAltitudeAngle + "]";
    }

    @SystemApi
    public static class Builder {
        private double mMeters = Double.NaN;
        private double mErrorMeters = Double.NaN;
        private double mAzimuthAngle = Double.NaN;
        private double mErrorAzimuthAngle = Double.NaN;
        private double mAltitudeAngle = Double.NaN;
        private double mErrorAltitudeAngle = Double.NaN;

        public Builder(double meters, double errorMeters) {
            if (Double.isNaN(meters) || meters < 0.0) {
                throw new IllegalArgumentException("meters must be >= 0.0 and not NaN: " + meters);
            }
            if (Double.isNaN(errorMeters) || errorMeters < 0.0) {
                throw new IllegalArgumentException("errorMeters must be >= 0.0 and not NaN: " + errorMeters);
            }
            this.mMeters = meters;
            this.mErrorMeters = errorMeters;
        }

        @SystemApi
        public Builder setAzimuthAngle(double angle) {
            if (angle > 360.0 || angle < 0.0) {
                throw new IllegalArgumentException("angle must be in the range from 0.0 to 360.0 : " + angle);
            }
            this.mAzimuthAngle = angle;
            return this;
        }

        @SystemApi
        public Builder setErrorAzimuthAngle(double angle) {
            if (angle > 360.0 || angle < 0.0) {
                throw new IllegalArgumentException("error angle must be in the range from 0.0 to 360.0 : " + angle);
            }
            this.mErrorAzimuthAngle = angle;
            return this;
        }

        @SystemApi
        public Builder setAltitudeAngle(double angle) {
            if (angle > 90.0 || angle < -90.0) {
                throw new IllegalArgumentException("angle must be in the range from -90.0 to 90.0 : " + angle);
            }
            this.mAltitudeAngle = angle;
            return this;
        }

        @SystemApi
        public Builder setErrorAltitudeAngle(double angle) {
            if (angle > 180.0 || angle < 0.0) {
                throw new IllegalArgumentException("error angle must be in the range from 0.0 to 180.0 : " + angle);
            }
            this.mErrorAltitudeAngle = angle;
            return this;
        }

        @SystemApi
        public DistanceMeasurementResult build() {
            return new DistanceMeasurementResult(this.mMeters, this.mErrorMeters, this.mAzimuthAngle, this.mErrorAzimuthAngle, this.mAltitudeAngle, this.mErrorAltitudeAngle);
        }
    }
}

