/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.le.BluetoothLeUtils;
import android.bluetooth.le.DistanceMeasurementParams;
import android.bluetooth.le.DistanceMeasurementResult;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.SynchronousResultReceiver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;

@SystemApi
public class DistanceMeasurementSession {
    private static final String TAG = "DistanceMeasurementSession";
    private final IBluetoothGatt mGatt;
    private final ParcelUuid mUuid;
    private final DistanceMeasurementParams mDistanceMeasurementParams;
    private final Executor mExecutor;
    private final Callback mCallback;
    private final AttributionSource mAttributionSource;

    public DistanceMeasurementSession(IBluetoothGatt gatt, ParcelUuid uuid, DistanceMeasurementParams params, Executor executor, AttributionSource attributionSource, Callback callback) {
        Objects.requireNonNull(gatt, "gatt is null");
        Objects.requireNonNull(params, "params is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(callback, "callback is null");
        this.mGatt = gatt;
        this.mUuid = uuid;
        this.mDistanceMeasurementParams = params;
        this.mExecutor = executor;
        this.mAttributionSource = attributionSource;
        this.mCallback = callback;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int stopSession() {
        int defaultValue = 15;
        try {
            SynchronousResultReceiver recv = SynchronousResultReceiver.get();
            this.mGatt.stopDistanceMeasurement(this.mUuid, this.mDistanceMeasurementParams.getDevice(), this.mDistanceMeasurementParams.getMethodId(), this.mAttributionSource, recv);
            return recv.awaitResultNoInterrupt(BluetoothLeUtils.getSyncTimeout()).getValue(15);
        }
        catch (TimeoutException e) {
            Log.e(TAG, e.toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return 15;
    }

    void onStarted() {
        this.executeCallback(() -> this.mCallback.onStarted(this));
    }

    void onStartFail(int reason) {
        this.executeCallback(() -> this.mCallback.onStartFail(reason));
    }

    void onStopped(int reason) {
        this.executeCallback(() -> this.mCallback.onStopped(this, reason));
    }

    void onResult(BluetoothDevice device, DistanceMeasurementResult result) {
        this.executeCallback(() -> this.mCallback.onResult(device, result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCallback(Runnable runnable) {
        long identity = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(runnable);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @SystemApi
    public static interface Callback {
        @SystemApi
        public void onStarted(DistanceMeasurementSession var1);

        @SystemApi
        public void onStartFail(int var1);

        @SystemApi
        public void onStopped(DistanceMeasurementSession var1, int var2);

        @SystemApi
        public void onResult(BluetoothDevice var1, DistanceMeasurementResult var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Reason {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StopSessionReturnValues {
    }
}

