/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.DistanceMeasurementResult;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IDistanceMeasurementCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.le.IDistanceMeasurementCallback";

    public void onStarted(BluetoothDevice var1) throws RemoteException;

    public void onStartFail(BluetoothDevice var1, int var2) throws RemoteException;

    public void onStopped(BluetoothDevice var1, int var2) throws RemoteException;

    public void onResult(BluetoothDevice var1, DistanceMeasurementResult var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDistanceMeasurementCallback {
        static final int TRANSACTION_onStarted = 1;
        static final int TRANSACTION_onStartFail = 2;
        static final int TRANSACTION_onStopped = 3;
        static final int TRANSACTION_onResult = 4;

        public Stub() {
            this.attachInterface(this, IDistanceMeasurementCallback.DESCRIPTOR);
        }

        public static IDistanceMeasurementCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDistanceMeasurementCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IDistanceMeasurementCallback) {
                return (IDistanceMeasurementCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onStarted";
                }
                case 2: {
                    return "onStartFail";
                }
                case 3: {
                    return "onStopped";
                }
                case 4: {
                    return "onResult";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDistanceMeasurementCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    data.enforceNoDataAvail();
                    this.onStarted(_arg0);
                    break;
                }
                case 2: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStartFail(_arg0, _arg1);
                    break;
                }
                case 3: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStopped(_arg0, _arg1);
                    break;
                }
                case 4: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    DistanceMeasurementResult _arg1 = data.readTypedObject(DistanceMeasurementResult.CREATOR);
                    data.enforceNoDataAvail();
                    this.onResult(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IDistanceMeasurementCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDistanceMeasurementCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStarted(BluetoothDevice device) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDistanceMeasurementCallback.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStartFail(BluetoothDevice device, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDistanceMeasurementCallback.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStopped(BluetoothDevice device, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDistanceMeasurementCallback.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(BluetoothDevice device, DistanceMeasurementResult result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDistanceMeasurementCallback.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeTypedObject(result, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDistanceMeasurementCallback {
        @Override
        public void onStarted(BluetoothDevice device) throws RemoteException {
        }

        @Override
        public void onStartFail(BluetoothDevice device, int reason) throws RemoteException {
        }

        @Override
        public void onStopped(BluetoothDevice device, int reason) throws RemoteException {
        }

        @Override
        public void onResult(BluetoothDevice device, DistanceMeasurementResult result) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

