/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.PeriodicAdvertisingReport;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IPeriodicAdvertisingCallback
extends IInterface {
    public void onSyncEstablished(int var1, BluetoothDevice var2, int var3, int var4, int var5, int var6) throws RemoteException;

    public void onPeriodicAdvertisingReport(PeriodicAdvertisingReport var1) throws RemoteException;

    public void onSyncLost(int var1) throws RemoteException;

    public void onSyncTransferred(BluetoothDevice var1, int var2) throws RemoteException;

    public void onBigInfoAdvertisingReport(int var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPeriodicAdvertisingCallback {
        public static final String DESCRIPTOR = "android.bluetooth.le.IPeriodicAdvertisingCallback";
        static final int TRANSACTION_onSyncEstablished = 1;
        static final int TRANSACTION_onPeriodicAdvertisingReport = 2;
        static final int TRANSACTION_onSyncLost = 3;
        static final int TRANSACTION_onSyncTransferred = 4;
        static final int TRANSACTION_onBigInfoAdvertisingReport = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPeriodicAdvertisingCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPeriodicAdvertisingCallback) {
                return (IPeriodicAdvertisingCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSyncEstablished";
                }
                case 2: {
                    return "onPeriodicAdvertisingReport";
                }
                case 3: {
                    return "onSyncLost";
                }
                case 4: {
                    return "onSyncTransferred";
                }
                case 5: {
                    return "onBigInfoAdvertisingReport";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    BluetoothDevice _arg1 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSyncEstablished(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 2: {
                    PeriodicAdvertisingReport _arg0 = data.readTypedObject(PeriodicAdvertisingReport.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPeriodicAdvertisingReport(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSyncLost(_arg0);
                    break;
                }
                case 4: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSyncTransferred(_arg0, _arg1);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onBigInfoAdvertisingReport(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IPeriodicAdvertisingCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSyncEstablished(int syncHandle, BluetoothDevice device, int advertisingSid, int skip, int timeout, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(syncHandle);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(advertisingSid);
                    _data.writeInt(skip);
                    _data.writeInt(timeout);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPeriodicAdvertisingReport(PeriodicAdvertisingReport report) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(report, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSyncLost(int syncHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(syncHandle);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSyncTransferred(BluetoothDevice device, int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBigInfoAdvertisingReport(int syncHandle, boolean encrypted) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(syncHandle);
                    _data.writeBoolean(encrypted);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPeriodicAdvertisingCallback {
        @Override
        public void onSyncEstablished(int syncHandle, BluetoothDevice device, int advertisingSid, int skip, int timeout, int status) throws RemoteException {
        }

        @Override
        public void onPeriodicAdvertisingReport(PeriodicAdvertisingReport report) throws RemoteException {
        }

        @Override
        public void onSyncLost(int syncHandle) throws RemoteException {
        }

        @Override
        public void onSyncTransferred(BluetoothDevice device, int status) throws RemoteException {
        }

        @Override
        public void onBigInfoAdvertisingReport(int syncHandle, boolean encrypted) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

