/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.SystemApi;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.TransportBlock;
import android.bluetooth.le.TransportDiscoveryData;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class TransportBlockFilter
implements Parcelable {
    private final int mOrgId;
    private final int mTdsFlags;
    private final int mTdsFlagsMask;
    private final byte[] mTransportData;
    private final byte[] mTransportDataMask;
    private final byte[] mWifiNanHash;
    @SystemApi
    public static final int WIFI_NAN_HASH_LENGTH_BYTES = 8;
    @SystemApi
    public static final Parcelable.Creator<TransportBlockFilter> CREATOR = new Parcelable.Creator<TransportBlockFilter>(){

        @Override
        public TransportBlockFilter createFromParcel(Parcel source) {
            int orgId = source.readInt();
            Builder builder = new Builder(orgId);
            builder.setTdsFlags(source.readInt(), source.readInt());
            if (source.readInt() == 1) {
                int transportDataLength = source.readInt();
                byte[] transportData = new byte[transportDataLength];
                source.readByteArray(transportData);
                byte[] transportDataMask = null;
                if (source.readInt() == 1) {
                    int transportDataMaskLength = source.readInt();
                    transportDataMask = new byte[transportDataMaskLength];
                    source.readByteArray(transportDataMask);
                }
                builder.setTransportData(transportData, transportDataMask);
            }
            if (source.readInt() == 1) {
                int wifiNanHashLength = source.readInt();
                byte[] wifiNanHash = new byte[wifiNanHashLength];
                source.readByteArray(wifiNanHash);
                builder.setWifiNanHash(wifiNanHash);
            }
            return builder.build();
        }

        public TransportBlockFilter[] newArray(int size) {
            return new TransportBlockFilter[0];
        }
    };

    private TransportBlockFilter(int orgId, int tdsFlags, int tdsFlagsMask, byte[] transportData, byte[] transportDataMask, byte[] wifiNanHash) {
        if (orgId < 1) {
            throw new IllegalArgumentException("invalid organization id " + orgId);
        }
        if (tdsFlags == -1) {
            throw new IllegalArgumentException("tdsFlag is invalid");
        }
        if (tdsFlagsMask == -1) {
            throw new IllegalArgumentException("tdsFlagsMask is invalid");
        }
        if (orgId == 2) {
            if (transportData != null || transportDataMask != null) {
                throw new IllegalArgumentException("wifiNanHash should be used instead of transportData and/or transportDataMask when orgId is WIFI_ALLIANCE_NEIGHBOR_AWARENESS_NETWORKING");
            }
            if (wifiNanHash != null && wifiNanHash.length != 8) {
                throw new IllegalArgumentException("wifiNanHash should be WIFI_NAN_HASH_LENGTH_BYTES long, but the input is " + wifiNanHash.length + " bytes");
            }
        } else if (wifiNanHash != null) {
            throw new IllegalArgumentException("wifiNanHash should not be used when orgId is not WIFI_ALLIANCE_NEIGHBOR_AWARENESS_NETWORKING");
        }
        this.mOrgId = orgId;
        this.mTdsFlags = tdsFlags;
        this.mTdsFlagsMask = tdsFlagsMask;
        this.mTransportData = transportData;
        this.mTransportDataMask = transportDataMask;
        this.mWifiNanHash = wifiNanHash;
    }

    @SystemApi
    public int getOrgId() {
        return this.mOrgId;
    }

    @SystemApi
    public int getTdsFlags() {
        return this.mTdsFlags;
    }

    @SystemApi
    public int getTdsFlagsMask() {
        return this.mTdsFlagsMask;
    }

    @SystemApi
    public byte[] getTransportData() {
        return this.mTransportData;
    }

    @SystemApi
    public byte[] getTransportDataMask() {
        return this.mTransportDataMask;
    }

    @SystemApi
    public byte[] getWifiNanHash() {
        return this.mWifiNanHash;
    }

    boolean matches(ScanResult scanResult) {
        ScanRecord scanRecord = scanResult.getScanRecord();
        TransportDiscoveryData transportDiscoveryData = scanRecord.getTransportDiscoveryData();
        if (transportDiscoveryData != null) {
            for (TransportBlock transportBlock : transportDiscoveryData.getTransportBlocks()) {
                int orgId = transportBlock.getOrgId();
                int tdsFlags = transportBlock.getTdsFlags();
                int transportDataLength = transportBlock.getTransportDataLength();
                byte[] transportData = transportBlock.getTransportData();
                if (this.mOrgId != orgId || (this.mTdsFlags & this.mTdsFlagsMask) != (tdsFlags & this.mTdsFlagsMask) || this.mOrgId != 2 && this.mTransportData != null && this.mTransportDataMask != null && (transportDataLength == 0 || !ScanFilter.matchesPartialData(this.mTransportData, this.mTransportDataMask, transportData))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    @SystemApi
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mOrgId);
        dest.writeInt(this.mTdsFlags);
        dest.writeInt(this.mTdsFlagsMask);
        dest.writeInt(this.mTransportData == null ? 0 : 1);
        if (this.mTransportData != null) {
            dest.writeInt(this.mTransportData.length);
            dest.writeByteArray(this.mTransportData);
            dest.writeInt(this.mTransportDataMask == null ? 0 : 1);
            if (this.mTransportDataMask != null) {
                dest.writeInt(this.mTransportDataMask.length);
                dest.writeByteArray(this.mTransportDataMask);
            }
        }
        dest.writeInt(this.mWifiNanHash == null ? 0 : 1);
        if (this.mWifiNanHash != null) {
            dest.writeInt(this.mWifiNanHash.length);
            dest.writeByteArray(this.mWifiNanHash);
        }
    }

    public String toString() {
        return "TransportBlockFilter [mOrgId=" + this.mOrgId + ", mTdsFlags=" + this.mTdsFlags + ", mTdsFlagsMask=" + this.mTdsFlagsMask + ", mTransportData=" + Arrays.toString(this.mTransportData) + ", mTransportDataMask=" + Arrays.toString(this.mTransportDataMask) + ", mWifiNanHash=" + Arrays.toString(this.mWifiNanHash) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.mOrgId, this.mTdsFlags, this.mTdsFlagsMask, Arrays.hashCode(this.mTransportData), Arrays.hashCode(this.mTransportDataMask), Arrays.hashCode(this.mWifiNanHash));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransportBlockFilter)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        TransportBlockFilter other = (TransportBlockFilter)obj;
        return this.mOrgId == other.getOrgId() && this.mTdsFlags == other.getTdsFlags() && this.mTdsFlagsMask == other.getTdsFlagsMask() && Arrays.equals(this.mTransportData, other.getTransportData()) && Arrays.equals(this.mTransportDataMask, other.getTransportDataMask()) && Arrays.equals(this.mWifiNanHash, other.getWifiNanHash());
    }

    @SystemApi
    public static class Builder {
        private final int mOrgId;
        private int mTdsFlags = 0;
        private int mTdsFlagsMask = 0;
        private byte[] mTransportData = null;
        private byte[] mTransportDataMask = null;
        private byte[] mWifiNanHash = null;

        @SystemApi
        public Builder(int orgId) {
            if (orgId < 1) {
                throw new IllegalArgumentException("invalid organization id " + orgId);
            }
            this.mOrgId = orgId;
        }

        @SystemApi
        public Builder setTdsFlags(int tdsFlags, int tdsFlagsMask) {
            if (tdsFlags < 0) {
                throw new IllegalArgumentException("tdsFlag is invalid");
            }
            if (tdsFlagsMask < 0) {
                throw new IllegalArgumentException("tdsFlagsMask is invalid");
            }
            this.mTdsFlags = tdsFlags;
            this.mTdsFlagsMask = tdsFlagsMask;
            return this;
        }

        @SystemApi
        public Builder setTransportData(byte[] transportData, byte[] transportDataMask) {
            if (this.mOrgId == 2) {
                throw new IllegalArgumentException("setWifiNanHash() should be used instead of setTransportData() when orgId is WIFI_ALLIANCE_NEIGHBOR_AWARENESS_NETWORKING");
            }
            Objects.requireNonNull(transportData);
            Objects.requireNonNull(transportDataMask);
            if (transportData.length == 0) {
                throw new IllegalArgumentException("transportData is empty");
            }
            if (transportDataMask.length == 0) {
                throw new IllegalArgumentException("transportDataMask is empty");
            }
            if (transportData.length != transportDataMask.length) {
                throw new IllegalArgumentException("Length of transportData and transportDataMask do not match");
            }
            this.mTransportData = transportData;
            this.mTransportDataMask = transportDataMask;
            return this;
        }

        @SystemApi
        public Builder setWifiNanHash(byte[] wifiNanHash) {
            if (this.mOrgId != 2) {
                throw new IllegalArgumentException("setWifiNanHash() can only be used when orgId is WIFI_ALLIANCE_NEIGHBOR_AWARENESS_NETWORKING");
            }
            Objects.requireNonNull(wifiNanHash);
            if (wifiNanHash.length != 8) {
                throw new IllegalArgumentException("Wi-Fi NAN hash must be 8 octets long");
            }
            this.mWifiNanHash = wifiNanHash;
            return this;
        }

        @SystemApi
        public TransportBlockFilter build() {
            return new TransportBlockFilter(this.mOrgId, this.mTdsFlags, this.mTdsFlagsMask, this.mTransportData, this.mTransportDataMask, this.mWifiNanHash);
        }
    }
}

