/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.le.BluetoothLeUtils;
import android.bluetooth.le.TransportBlock;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TransportDiscoveryData
implements Parcelable {
    private static final String TAG = "TransportDiscoveryData";
    private final int mTransportDataType;
    private final List<TransportBlock> mTransportBlocks;
    public static final Parcelable.Creator<TransportDiscoveryData> CREATOR = new Parcelable.Creator<TransportDiscoveryData>(){

        @Override
        public TransportDiscoveryData createFromParcel(Parcel in) {
            return new TransportDiscoveryData(in);
        }

        public TransportDiscoveryData[] newArray(int size) {
            return new TransportDiscoveryData[size];
        }
    };

    public TransportDiscoveryData(int transportDataType, List<TransportBlock> transportBlocks) {
        this.mTransportDataType = transportDataType;
        this.mTransportBlocks = transportBlocks;
    }

    public TransportDiscoveryData(byte[] transportDiscoveryData) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(transportDiscoveryData);
        this.mTransportBlocks = new ArrayList<TransportBlock>();
        this.mTransportDataType = byteBuffer.remaining() > 0 ? (int)byteBuffer.get() : -1;
        try {
            while (byteBuffer.remaining() > 0) {
                byte orgId = byteBuffer.get();
                byte tdsFlags = byteBuffer.get();
                byte transportDataLength = byteBuffer.get();
                byte[] transportData = new byte[transportDataLength];
                byteBuffer.get(transportData, 0, transportDataLength);
                this.mTransportBlocks.add(new TransportBlock(orgId, tdsFlags, transportDataLength, transportData));
            }
        }
        catch (BufferUnderflowException e) {
            Log.e(TAG, "Error while parsing data: " + e.toString());
        }
    }

    private TransportDiscoveryData(Parcel in) {
        this.mTransportDataType = in.readInt();
        this.mTransportBlocks = in.createTypedArrayList(TransportBlock.CREATOR);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TransportDiscoveryData other = (TransportDiscoveryData)obj;
        return Arrays.equals(this.toByteArray(), other.toByteArray());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mTransportDataType);
        dest.writeTypedList(this.mTransportBlocks);
    }

    public int getTransportDataType() {
        return this.mTransportDataType;
    }

    public List<TransportBlock> getTransportBlocks() {
        if (this.mTransportBlocks == null) {
            return Collections.emptyList();
        }
        return this.mTransportBlocks;
    }

    public byte[] toByteArray() {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(this.totalBytes());
            buffer.put((byte)this.mTransportDataType);
            for (TransportBlock transportBlock : this.getTransportBlocks()) {
                buffer.put(transportBlock.toByteArray());
            }
            return buffer.array();
        }
        catch (BufferOverflowException e) {
            Log.e(TAG, "Error converting to byte array: " + e.toString());
            return null;
        }
    }

    public String toString() {
        return BluetoothLeUtils.toString(this.toByteArray());
    }

    public int totalBytes() {
        int size = 1;
        for (TransportBlock transportBlock : this.getTransportBlocks()) {
            size += transportBlock.totalBytes();
        }
        return size;
    }
}

