/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.SystemApi;
import android.companion.AssociatedDevice;
import android.net.MacAddress;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Date;
import java.util.Objects;

public class AssociationInfo
implements Parcelable {
    private static final String LAST_TIME_CONNECTED_NONE = "None";
    private final int mId;
    private final int mUserId;
    private final String mPackageName;
    private final MacAddress mDeviceMacAddress;
    private final CharSequence mDisplayName;
    private final String mDeviceProfile;
    private final AssociatedDevice mAssociatedDevice;
    private final boolean mSelfManaged;
    private final boolean mNotifyOnDeviceNearby;
    private final int mSystemDataSyncFlags;
    private final boolean mRevoked;
    private final long mTimeApprovedMs;
    private final long mLastTimeConnectedMs;
    public static final Parcelable.Creator<AssociationInfo> CREATOR = new Parcelable.Creator<AssociationInfo>(){

        public AssociationInfo[] newArray(int size) {
            return new AssociationInfo[size];
        }

        @Override
        public AssociationInfo createFromParcel(Parcel in) {
            return new AssociationInfo(in);
        }
    };

    public AssociationInfo(int id2, int userId, String packageName, MacAddress macAddress, CharSequence displayName, String deviceProfile, AssociatedDevice associatedDevice, boolean selfManaged, boolean notifyOnDeviceNearby, boolean revoked, long timeApprovedMs, long lastTimeConnectedMs, int systemDataSyncFlags) {
        if (id2 <= 0) {
            throw new IllegalArgumentException("Association ID should be greater than 0");
        }
        if (macAddress == null && displayName == null) {
            throw new IllegalArgumentException("MAC address and the Display Name must NOT be null at the same time");
        }
        this.mId = id2;
        this.mUserId = userId;
        this.mPackageName = packageName;
        this.mDeviceMacAddress = macAddress;
        this.mDisplayName = displayName;
        this.mDeviceProfile = deviceProfile;
        this.mAssociatedDevice = associatedDevice;
        this.mSelfManaged = selfManaged;
        this.mNotifyOnDeviceNearby = notifyOnDeviceNearby;
        this.mRevoked = revoked;
        this.mTimeApprovedMs = timeApprovedMs;
        this.mLastTimeConnectedMs = lastTimeConnectedMs;
        this.mSystemDataSyncFlags = systemDataSyncFlags;
    }

    public int getId() {
        return this.mId;
    }

    public int getUserId() {
        return this.mUserId;
    }

    @SystemApi
    public String getPackageName() {
        return this.mPackageName;
    }

    public MacAddress getDeviceMacAddress() {
        return this.mDeviceMacAddress;
    }

    public String getDeviceMacAddressAsString() {
        return this.mDeviceMacAddress != null ? this.mDeviceMacAddress.toString().toUpperCase() : null;
    }

    public CharSequence getDisplayName() {
        return this.mDisplayName;
    }

    public String getDeviceProfile() {
        return this.mDeviceProfile;
    }

    public AssociatedDevice getAssociatedDevice() {
        return this.mAssociatedDevice;
    }

    @SystemApi
    public boolean isSelfManaged() {
        return this.mSelfManaged;
    }

    public boolean isNotifyOnDeviceNearby() {
        return this.mNotifyOnDeviceNearby;
    }

    public long getTimeApprovedMs() {
        return this.mTimeApprovedMs;
    }

    public boolean belongsToPackage(int userId, String packageName) {
        return this.mUserId == userId && Objects.equals(this.mPackageName, packageName);
    }

    public boolean isRevoked() {
        return this.mRevoked;
    }

    public Long getLastTimeConnectedMs() {
        return this.mLastTimeConnectedMs;
    }

    public int getSystemDataSyncFlags() {
        return this.mSystemDataSyncFlags;
    }

    public boolean isLinkedTo(String addr) {
        MacAddress macAddress;
        if (this.mSelfManaged) {
            return false;
        }
        if (addr == null) {
            return false;
        }
        try {
            macAddress = MacAddress.fromString(addr);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return macAddress.equals(this.mDeviceMacAddress);
    }

    public boolean shouldBindWhenPresent() {
        return this.mNotifyOnDeviceNearby || this.mSelfManaged;
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id=").append(this.mId);
        if (this.mDeviceMacAddress != null) {
            sb.append(", addr=").append(this.getDeviceMacAddressAsString());
        }
        if (this.mSelfManaged) {
            sb.append(", self-managed");
        }
        sb.append(", pkg=u").append(this.mUserId).append('/').append(this.mPackageName);
        return sb.toString();
    }

    public String toString() {
        return "Association{mId=" + this.mId + ", mUserId=" + this.mUserId + ", mPackageName='" + this.mPackageName + '\'' + ", mDeviceMacAddress=" + this.mDeviceMacAddress + ", mDisplayName='" + this.mDisplayName + '\'' + ", mDeviceProfile='" + this.mDeviceProfile + '\'' + ", mSelfManaged=" + this.mSelfManaged + ", mAssociatedDevice=" + this.mAssociatedDevice + ", mNotifyOnDeviceNearby=" + this.mNotifyOnDeviceNearby + ", mRevoked=" + this.mRevoked + ", mTimeApprovedMs=" + new Date(this.mTimeApprovedMs) + ", mLastTimeConnectedMs=" + (this.mLastTimeConnectedMs == Long.MAX_VALUE ? LAST_TIME_CONNECTED_NONE : new Date(this.mLastTimeConnectedMs)) + ", mSystemDataSyncFlags=" + this.mSystemDataSyncFlags + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssociationInfo)) {
            return false;
        }
        AssociationInfo that = (AssociationInfo)o;
        return this.mId == that.mId && this.mUserId == that.mUserId && this.mSelfManaged == that.mSelfManaged && this.mNotifyOnDeviceNearby == that.mNotifyOnDeviceNearby && this.mRevoked == that.mRevoked && this.mTimeApprovedMs == that.mTimeApprovedMs && this.mLastTimeConnectedMs == that.mLastTimeConnectedMs && Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mDeviceMacAddress, that.mDeviceMacAddress) && Objects.equals(this.mDisplayName, that.mDisplayName) && Objects.equals(this.mDeviceProfile, that.mDeviceProfile) && Objects.equals(this.mAssociatedDevice, that.mAssociatedDevice) && this.mSystemDataSyncFlags == that.mSystemDataSyncFlags;
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mUserId, this.mPackageName, this.mDeviceMacAddress, this.mDisplayName, this.mDeviceProfile, this.mAssociatedDevice, this.mSelfManaged, this.mNotifyOnDeviceNearby, this.mRevoked, this.mTimeApprovedMs, this.mLastTimeConnectedMs, this.mSystemDataSyncFlags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeInt(this.mUserId);
        dest.writeString(this.mPackageName);
        dest.writeTypedObject(this.mDeviceMacAddress, 0);
        dest.writeCharSequence(this.mDisplayName);
        dest.writeString(this.mDeviceProfile);
        dest.writeTypedObject(this.mAssociatedDevice, 0);
        dest.writeBoolean(this.mSelfManaged);
        dest.writeBoolean(this.mNotifyOnDeviceNearby);
        dest.writeBoolean(this.mRevoked);
        dest.writeLong(this.mTimeApprovedMs);
        dest.writeLong(this.mLastTimeConnectedMs);
        dest.writeInt(this.mSystemDataSyncFlags);
    }

    private AssociationInfo(Parcel in) {
        this.mId = in.readInt();
        this.mUserId = in.readInt();
        this.mPackageName = in.readString();
        this.mDeviceMacAddress = in.readTypedObject(MacAddress.CREATOR);
        this.mDisplayName = in.readCharSequence();
        this.mDeviceProfile = in.readString();
        this.mAssociatedDevice = in.readTypedObject(AssociatedDevice.CREATOR);
        this.mSelfManaged = in.readBoolean();
        this.mNotifyOnDeviceNearby = in.readBoolean();
        this.mRevoked = in.readBoolean();
        this.mTimeApprovedMs = in.readLong();
        this.mLastTimeConnectedMs = in.readLong();
        this.mSystemDataSyncFlags = in.readInt();
    }

    public static NonActionableBuilder builder(AssociationInfo info) {
        return new Builder(info);
    }

    public static class Builder
    implements NonActionableBuilder {
        private final AssociationInfo mOriginalInfo;
        private boolean mNotifyOnDeviceNearby;
        private boolean mRevoked;
        private long mLastTimeConnectedMs;
        private int mSystemDataSyncFlags;

        private Builder(AssociationInfo info) {
            this.mOriginalInfo = info;
            this.mNotifyOnDeviceNearby = info.mNotifyOnDeviceNearby;
            this.mRevoked = info.mRevoked;
            this.mLastTimeConnectedMs = info.mLastTimeConnectedMs;
            this.mSystemDataSyncFlags = info.mSystemDataSyncFlags;
        }

        @Override
        public Builder setLastTimeConnected(long lastTimeConnectedMs) {
            if (lastTimeConnectedMs < 0L) {
                throw new IllegalArgumentException("lastTimeConnectedMs must not be negative! (Given " + lastTimeConnectedMs + " )");
            }
            this.mLastTimeConnectedMs = lastTimeConnectedMs;
            return this;
        }

        @Override
        public Builder setNotifyOnDeviceNearby(boolean notifyOnDeviceNearby) {
            this.mNotifyOnDeviceNearby = notifyOnDeviceNearby;
            return this;
        }

        @Override
        public Builder setRevoked(boolean revoked) {
            this.mRevoked = revoked;
            return this;
        }

        @Override
        public Builder setSystemDataSyncFlags(int flags) {
            this.mSystemDataSyncFlags = flags;
            return this;
        }

        public AssociationInfo build() {
            return new AssociationInfo(this.mOriginalInfo.mId, this.mOriginalInfo.mUserId, this.mOriginalInfo.mPackageName, this.mOriginalInfo.mDeviceMacAddress, this.mOriginalInfo.mDisplayName, this.mOriginalInfo.mDeviceProfile, this.mOriginalInfo.mAssociatedDevice, this.mOriginalInfo.mSelfManaged, this.mNotifyOnDeviceNearby, this.mRevoked, this.mOriginalInfo.mTimeApprovedMs, this.mLastTimeConnectedMs, this.mSystemDataSyncFlags);
        }
    }

    public static interface NonActionableBuilder {
        public Builder setNotifyOnDeviceNearby(boolean var1);

        public Builder setLastTimeConnected(long var1);

        public Builder setRevoked(boolean var1);

        public Builder setSystemDataSyncFlags(int var1);
    }
}

